/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.jpa.jpql.spi.AbstractMapping;
import org.eclipse.persistence.internal.jpa.jpql.spi.JavaType;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.spi.ITypeRepository;
import org.eclipse.persistence.jpa.jpql.spi.java.JavaTypeDeclaration;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JavaMapping
extends AbstractMapping {
    private DatabaseMapping mapping;
    private ITypeDeclaration typeDeclaration;

    JavaMapping(IManagedType parent, DatabaseMapping mapping) {
        super(parent);
        this.mapping = mapping;
    }

    private ITypeDeclaration buildTypeDeclaration() {
        ClassDescriptor descriptor;
        if (this.mapping.isAggregateMapping() && (descriptor = ((AggregateMapping)this.mapping).getReferenceDescriptor()) != null) {
            return this.buildTypeDeclaration(descriptor);
        }
        if (this.mapping.isForeignReferenceMapping()) {
            ForeignReferenceMapping referenceMapping = (ForeignReferenceMapping)this.mapping;
            if (this.mapping.isDirectMapMapping()) {
                DirectMapMapping directMapMapping = (DirectMapMapping)this.mapping;
                Class key = directMapMapping.getKeyClass();
                Class value = directMapMapping.getValueClass();
                if (key == null) {
                    MapContainerPolicy mapPolicy = (MapContainerPolicy)this.mapping.getContainerPolicy();
                    Object keyValue = mapPolicy.getKeyType();
                    if (keyValue instanceof Class) {
                        key = (Class)keyValue;
                    } else if (keyValue instanceof ClassDescriptor) {
                        ClassDescriptor descriptor2 = (ClassDescriptor)keyValue;
                        key = descriptor2.getJavaClass();
                    }
                }
                if (value == null) {
                    value = this.mapping.getAttributeClassification();
                }
                IType type = this.getTypeRepository().getType(this.mapping.getContainerPolicy().getContainerClass());
                IType keyType = this.getTypeRepository().getType(key);
                IType valueType = this.getTypeRepository().getType(value);
                return this.buildTypeDeclaration(type, new IType[]{keyType, valueType});
            }
            if (this.mapping.isCollectionMapping()) {
                ContainerPolicy containerPolicy = this.mapping.getContainerPolicy();
                if (containerPolicy.isCollectionPolicy()) {
                    Class containerClass = containerPolicy.getContainerClass();
                    Class propertyType = referenceMapping.getReferenceClass();
                    if (propertyType == null) {
                        propertyType = this.mapping.getAttributeClassification();
                    }
                    IType type = this.getTypeRepository().getType(containerClass);
                    return this.buildTypeDeclaration(type, propertyType);
                }
                if (containerPolicy.isMapPolicy()) {
                    IType keyType;
                    MapContainerPolicy mapPolicy = (MapContainerPolicy)containerPolicy;
                    IType type = this.getTypeRepository().getType(mapPolicy.getContainerClass());
                    IType valueType = this.getTypeRepository().getType(mapPolicy.getElementClass());
                    Object key = mapPolicy.getKeyType();
                    if (key instanceof Class) {
                        keyType = this.getTypeRepository().getType((Class)key);
                    } else if (key instanceof ClassDescriptor) {
                        ClassDescriptor descriptor3 = (ClassDescriptor)key;
                        keyType = this.getTypeRepository().getType(descriptor3.getJavaClass());
                    } else {
                        keyType = null;
                    }
                    return this.buildTypeDeclaration(type, new IType[]{keyType, valueType});
                }
            }
            return this.buildTypeDeclaration(referenceMapping.getReferenceDescriptor());
        }
        AttributeAccessor accessor = this.mapping.getAttributeAccessor();
        if (accessor.isInstanceVariableAttributeAccessor()) {
            InstanceVariableAttributeAccessor attributeAccessor = (InstanceVariableAttributeAccessor)accessor;
            Field field = attributeAccessor.getAttributeField();
            if (field == null) {
                try {
                    field = this.mapping.getDescriptor().getJavaClass().getDeclaredField(attributeAccessor.getAttributeName());
                }
                catch (Exception exception) {}
            }
            return this.buildTypeDeclaration(field);
        }
        if (accessor.isMethodAttributeAccessor()) {
            MethodAttributeAccessor methodAccessor = (MethodAttributeAccessor)accessor;
            Method method = methodAccessor.getGetMethod();
            if (method == null) {
                try {
                    method = this.mapping.getDescriptor().getJavaClass().getDeclaredMethod(methodAccessor.getGetMethodName(), new Class[0]);
                }
                catch (Exception exception) {}
            }
            return this.buildTypeDeclaration(method);
        }
        Class attributeType = accessor.getAttributeClass();
        IType type = this.getTypeRepository().getType(attributeType);
        return new JavaTypeDeclaration(this.getTypeRepository(), type, null, attributeType.isArray());
    }

    private ITypeDeclaration buildTypeDeclaration(ClassDescriptor descriptor) {
        JavaType type = new JavaType(this.getTypeRepository(), descriptor);
        return new JavaTypeDeclaration(this.getTypeRepository(), (IType)type, null, false);
    }

    private ITypeDeclaration buildTypeDeclaration(Field field) {
        Type genericType;
        ITypeRepository typeRepository = this.getTypeRepository();
        Class<?> fieldType = field.getType();
        if (fieldType == (genericType = field.getGenericType())) {
            genericType = null;
        }
        IType type = typeRepository.getType(fieldType);
        return new JavaTypeDeclaration(typeRepository, type, (Object)genericType, fieldType.isArray());
    }

    private ITypeDeclaration buildTypeDeclaration(IType type, Object genericType) {
        return new JavaTypeDeclaration(this.getTypeRepository(), type, genericType, false);
    }

    private ITypeDeclaration buildTypeDeclaration(Method method) {
        Type genericType;
        ITypeRepository typeRepository = this.getTypeRepository();
        Class<?> returnType = method.getReturnType();
        if (returnType == (genericType = method.getGenericReturnType())) {
            genericType = null;
        }
        IType type = typeRepository.getType(returnType);
        return new JavaTypeDeclaration(typeRepository, type, (Object)genericType, returnType.isArray());
    }

    @Override
    int calculateMappingType() {
        if (this.mapping.isDirectToFieldMapping()) {
            VersionLockingPolicy policy;
            if (this.mapping.isJPAId()) {
                return 5;
            }
            AbstractDirectMapping directToFieldMapping = (AbstractDirectMapping)this.mapping;
            if (directToFieldMapping.getDescriptor().getOptimisticLockingPolicy() instanceof VersionLockingPolicy && (policy = (VersionLockingPolicy)directToFieldMapping.getDescriptor().getOptimisticLockingPolicy()).getVersionMapping() == this.mapping) {
                return 11;
            }
            return 1;
        }
        if (this.mapping.isDirectCollectionMapping() || this.mapping.isAggregateCollectionMapping()) {
            return 2;
        }
        if (this.mapping.isAggregateObjectMapping()) {
            if (((AggregateObjectMapping)this.mapping).isPrimaryKeyMapping()) {
                return 4;
            }
            return 3;
        }
        if (this.mapping.isOneToManyMapping()) {
            return 8;
        }
        if (this.mapping.isManyToManyMapping()) {
            if (((ManyToManyMapping)this.mapping).isDefinedAsOneToManyMapping()) {
                return 8;
            }
            return 6;
        }
        if (this.mapping.isManyToOneMapping()) {
            return 7;
        }
        if (this.mapping.isOneToOneMapping()) {
            return 9;
        }
        if (this.mapping.isTransformationMapping()) {
            return 103;
        }
        if (this.mapping.isVariableOneToOneMapping()) {
            return 104;
        }
        return 10;
    }

    public int compareTo(IMapping mapping) {
        return this.getName().compareTo(mapping.getName());
    }

    DatabaseMapping getMapping() {
        return this.mapping;
    }

    public String getName() {
        return this.mapping.getAttributeName();
    }

    public IType getType() {
        return this.getTypeDeclaration().getType();
    }

    public ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = this.buildTypeDeclaration();
        }
        return this.typeDeclaration;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        AttributeAccessor accessor = this.mapping.getAttributeAccessor();
        if (accessor.isInstanceVariableAttributeAccessor()) {
            InstanceVariableAttributeAccessor attributeAccessor = (InstanceVariableAttributeAccessor)accessor;
            Field field = attributeAccessor.getAttributeField();
            if (field == null) {
                try {
                    field = this.mapping.getDescriptor().getJavaClass().getDeclaredField(attributeAccessor.getAttributeName());
                }
                catch (Exception exception) {}
            }
            return field == null ? false : field.isAnnotationPresent(annotationType);
        }
        if (accessor.isMethodAttributeAccessor()) {
            MethodAttributeAccessor methodAccessor = (MethodAttributeAccessor)accessor;
            Method method = methodAccessor.getGetMethod();
            if (method == null) {
                try {
                    method = this.mapping.getDescriptor().getJavaClass().getDeclaredMethod(methodAccessor.getGetMethodName(), new Class[0]);
                }
                catch (Exception exception) {}
            }
            return method == null ? false : method.isAnnotationPresent(annotationType);
        }
        return accessor.getAttributeClass().isAnnotationPresent(annotationType);
    }

    public boolean isCollection() {
        return this.mapping.isCollectionMapping();
    }

    public boolean isProperty() {
        return this.mapping.isDirectToFieldMapping();
    }

    public boolean isRelationship() {
        return this.mapping.isForeignReferenceMapping();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=");
        sb.append(this.getName());
        sb.append(", type=");
        sb.append(this.getMappingType());
        sb.append(", mapping=");
        sb.append(this.mapping);
        return sb.toString();
    }
}

