/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.expressions.spatial;

import java.io.StringWriter;

public class SpatialParameters {
    private String params = null;
    private Number minResolution = null;
    private Number maxResolution = null;
    private Units units = null;
    private Number distance = null;
    private QueryType queryType = null;
    private Mask[] masks = null;
    private static String UNIT_PARAM = "UNIT=";
    private static String MAX_RES_PARAM = "MAX_RESOLUTION=";
    private static String MIN_RES_PARAM = "MIN_RESOLUTION=";
    private static String DISTANCE_PARAM = "DISTANCE=";
    private static String QUERYTYPE_PARAM = "QUERYTYPE=";
    private static String MASK_PARAM = "MASK=";

    public SpatialParameters() {
    }

    public SpatialParameters(String params) {
        this.setParams(params);
    }

    public SpatialParameters setParams(String params) {
        this.params = params;
        return this;
    }

    public String getParams() {
        return this.params;
    }

    public SpatialParameters setMinResolution(Number minResolution) {
        this.minResolution = minResolution;
        return this;
    }

    public Number getMinResolution() {
        return this.minResolution;
    }

    public SpatialParameters setMaxResolution(Number maxResolution) {
        this.maxResolution = maxResolution;
        return this;
    }

    public Number getMaxResolution() {
        return this.maxResolution;
    }

    public SpatialParameters setUnits(Units units) {
        this.units = units;
        return this;
    }

    public Units getUnits() {
        return this.units;
    }

    public SpatialParameters setDistance(Number distance) {
        this.distance = distance;
        return this;
    }

    public Number getDistance() {
        return this.distance;
    }

    public SpatialParameters setQueryType(QueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public SpatialParameters setMasks(Mask[] masks) {
        this.masks = masks;
        return this;
    }

    public SpatialParameters setMask(Mask mask) {
        this.masks = new Mask[]{mask};
        return this;
    }

    public Mask[] getMasks() {
        return this.masks;
    }

    public String getParameterString() {
        if (this.getParams() != null) {
            return this.getParams();
        }
        StringWriter writer = new StringWriter();
        boolean hasParams = false;
        hasParams = this.writeParam(writer, DISTANCE_PARAM, this.getDistance(), hasParams);
        hasParams = this.writeParam(writer, MAX_RES_PARAM, this.getMaxResolution(), hasParams);
        hasParams = this.writeParam(writer, MIN_RES_PARAM, this.getMinResolution(), hasParams);
        hasParams = this.writeParam(writer, UNIT_PARAM, (Object)this.getUnits(), hasParams);
        hasParams = this.writeParam(writer, MASK_PARAM, this.getMasks(), hasParams);
        hasParams = this.writeParam(writer, QUERYTYPE_PARAM, (Object)this.getQueryType(), hasParams);
        return hasParams ? writer.toString() : null;
    }

    private boolean writeParam(StringWriter writer, String paramName, Object paramValue, boolean hasParams) {
        if (paramValue != null) {
            if (hasParams) {
                writer.write(" ");
            }
            if (paramValue.getClass().isArray()) {
                Object[] values = (Object[])paramValue;
                if (values.length == 0) {
                    return false;
                }
                writer.write(paramName);
                writer.write(values[0].toString());
                int index = 1;
                while (index < values.length) {
                    writer.write("+");
                    writer.write(values[index].toString());
                    ++index;
                }
            } else {
                writer.write(paramName);
                writer.write(paramValue.toString());
            }
            return true;
        }
        return hasParams;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mask {
        TOUCH,
        OVERLAPBDYDISJOINT,
        OVERLAPBDYINTERSECT,
        EQUAL,
        INSIDE,
        COVEREDBY,
        CONTAINS,
        COVERS,
        ANYINTERACT,
        ON;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueryType {
        WINDOW,
        JOIN,
        FILTER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Units {
        M,
        KM,
        CM,
        MM,
        MILE,
        NAUT_MILE,
        FOOT,
        INCH;

    }
}

