/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldsLockingPolicy
implements OptimisticLockingPolicy {
    protected ClassDescriptor descriptor;
    protected List<DatabaseField> allNonPrimaryKeyFields;

    @Override
    public void addLockFieldsToUpdateRow(AbstractRecord Record2, AbstractSession session) {
    }

    @Override
    public abstract void addLockValuesToTranslationRow(ObjectLevelModifyQuery var1);

    protected List buildAllNonPrimaryKeyFields() {
        ArrayList<DatabaseField> fields = new ArrayList<DatabaseField>();
        Enumeration<DatabaseField> enumtr = this.descriptor.getFields().elements();
        while (enumtr.hasMoreElements()) {
            DatabaseField dbField = enumtr.nextElement();
            if (this.isPrimaryKey(dbField)) continue;
            if (this.descriptor.hasInheritance()) {
                DatabaseField classField = this.descriptor.getInheritancePolicy().getClassIndicatorField();
                if (classField == null || dbField.equals(classField)) continue;
                fields.add(dbField);
                continue;
            }
            fields.add(dbField);
        }
        return fields;
    }

    @Override
    public Expression buildDeleteExpression(DatabaseTable table, Expression mainExpression, AbstractRecord row) {
        return mainExpression.and(this.buildExpression(table, row, null, mainExpression.getBuilder()));
    }

    protected Expression buildExpression(DatabaseTable table, AbstractRecord transRow, AbstractRecord modifyRow, ExpressionBuilder builder) {
        DatabaseField field;
        Expression exp = null;
        Iterator<DatabaseField> iterator = this.getFieldsToCompare(table, transRow, modifyRow).iterator();
        if (iterator.hasNext()) {
            field = iterator.next();
            exp = builder.getField(field).equal(builder.getParameter(field));
        }
        while (iterator.hasNext()) {
            field = iterator.next();
            exp = exp.and(builder.getField(field).equal(builder.getParameter(field)));
        }
        return exp;
    }

    @Override
    public Expression buildUpdateExpression(DatabaseTable table, Expression mainExpression, AbstractRecord transRow, AbstractRecord modifyRow) {
        return mainExpression.and(this.buildExpression(table, transRow, modifyRow, mainExpression.getBuilder()));
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public boolean supportsWriteLockValuesComparison() {
        return false;
    }

    @Override
    public int compareWriteLockValues(Object value1, Object value2) {
        return -1;
    }

    protected List<DatabaseField> getAllNonPrimaryKeyFields() {
        if (this.allNonPrimaryKeyFields == null) {
            this.allNonPrimaryKeyFields = this.buildAllNonPrimaryKeyFields();
        }
        return this.allNonPrimaryKeyFields;
    }

    protected List<DatabaseField> getAllNonPrimaryKeyFields(DatabaseTable table) {
        ArrayList<DatabaseField> filteredFields = new ArrayList<DatabaseField>();
        for (DatabaseField dbField : this.getAllNonPrimaryKeyFields()) {
            if (!dbField.getTableName().equals(table.getName())) continue;
            filteredFields.add(dbField);
        }
        return filteredFields;
    }

    @Override
    public Object getBaseValue() {
        return null;
    }

    protected abstract List<DatabaseField> getFieldsToCompare(DatabaseTable var1, AbstractRecord var2, AbstractRecord var3);

    @Override
    public DatabaseField getWriteLockField() {
        return null;
    }

    @Override
    public Expression getWriteLockUpdateExpression(ExpressionBuilder builder, AbstractSession session) {
        return null;
    }

    @Override
    public OptimisticLockingPolicy.LockOnChange getLockOnChangeMode() {
        return OptimisticLockingPolicy.LockOnChange.NONE;
    }

    @Override
    public Object getValueToPutInCache(AbstractRecord row, AbstractSession session) {
        return null;
    }

    @Override
    public int getVersionDifference(Object currentValue, Object domainObject, Object primaryKeys, AbstractSession session) {
        return 0;
    }

    @Override
    public Object getWriteLockValue(Object domainObject, Object primaryKey, AbstractSession session) {
        return null;
    }

    @Override
    public void initialize(AbstractSession session) {
        if (this.descriptor.getTables().size() > 0) {
            this.descriptor.setHasMultipleTableConstraintDependecy(true);
        }
    }

    @Override
    public void initializeProperties() {
    }

    @Override
    public boolean isStoredInCache() {
        return false;
    }

    @Override
    public boolean isCascaded() {
        return false;
    }

    @Override
    public boolean isNewerVersion(Object currentValue, Object domainObject, Object primaryKey, AbstractSession session) {
        return true;
    }

    @Override
    public boolean isNewerVersion(AbstractRecord Record2, Object domainObject, Object primaryKey, AbstractSession session) {
        return true;
    }

    protected boolean isPrimaryKey(DatabaseField dbField) {
        if (this.descriptor.getPrimaryKeyFields().contains(dbField)) {
            return true;
        }
        if (this.descriptor.isMultipleTableDescriptor()) {
            Iterator<Map<DatabaseField, DatabaseField>> enumtr = this.descriptor.getAdditionalTablePrimaryKeyFields().values().iterator();
            while (enumtr.hasNext()) {
                if (!enumtr.next().containsKey(dbField)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mergeIntoParentCache(UnitOfWorkImpl uow, Object primaryKey, Object object) {
    }

    protected void setAllNonPrimaryKeyFields(List allNonPrimaryKeyFields) {
        this.allNonPrimaryKeyFields = allNonPrimaryKeyFields;
    }

    @Override
    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void setLockOnChangeMode(OptimisticLockingPolicy.LockOnChange lockOnChangeMode) {
    }

    @Override
    public void setupWriteFieldsForInsert(ObjectLevelModifyQuery query) {
    }

    @Override
    public void updateRowAndObjectForUpdate(ObjectLevelModifyQuery query, Object domainObject) {
    }

    @Override
    public boolean shouldUpdateVersionOnOwnedMappingChange() {
        return false;
    }

    @Override
    public boolean shouldUpdateVersionOnMappingChange() {
        return false;
    }

    @Override
    public void validateDelete(int rowCount, Object object, DeleteObjectQuery query) {
        if (rowCount <= 0) {
            query.getSession().getParentIdentityMapSession(query, true, true).getIdentityMapAccessor().invalidateObject(object);
            throw OptimisticLockException.objectChangedSinceLastReadWhenDeleting(object, query);
        }
    }

    @Override
    public void validateUpdate(int rowCount, Object object, WriteObjectQuery query) {
        if (rowCount <= 0) {
            query.getSession().getParentIdentityMapSession(query, true, true).getIdentityMapAccessor().invalidateObject(object);
            throw OptimisticLockException.objectChangedSinceLastReadWhenUpdating(object, query);
        }
    }

    protected void verifyUsage(AbstractSession session) {
        if (!session.isUnitOfWork()) {
            throw ValidationException.fieldLevelLockingNotSupportedWithoutUnitOfWork();
        }
    }
}

