/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.resourcegen;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.codemodel.writer.FilterCodeWriter;
import com.sun.xml.bind.api.impl.NameConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class ResourceGenTask
extends Task {
    private FileSet resources;
    private File destDir;
    private File license;

    public void addConfiguredResource(FileSet fs) {
        this.resources = fs;
    }

    public void setDestDir(File dir) {
        this.destDir = dir;
    }

    public void setLicense(File license) {
        this.license = license;
    }

    public void execute() throws BuildException {
        if (this.resources == null) {
            throw new BuildException("No resource file is specified");
        }
        if (this.destDir == null) {
            throw new BuildException("No destdir attribute is specified");
        }
        this.destDir.mkdirs();
        JCodeModel cm = new JCodeModel();
        DirectoryScanner ds = this.resources.getDirectoryScanner(this.getProject());
        String[] includedFiles = ds.getIncludedFiles();
        File baseDir = ds.getBasedir();
        for (String value : includedFiles) {
            JClass lable_class;
            JClass l_class;
            JClass lmf_class;
            JDefinedClass clazz;
            File res = new File(baseDir, value);
            if (res.getName().contains("_")) continue;
            String className = this.getClassName(res);
            String bundleName = value.substring(0, value.lastIndexOf(46)).replace('/', '.').replace('\\', '.');
            String dirName = bundleName.substring(0, bundleName.lastIndexOf(46));
            File destFile = new File(new File(this.destDir, dirName.replace('.', '/')), className + ".java");
            if (destFile.lastModified() >= res.lastModified()) {
                this.log("Skipping " + res, 2);
                continue;
            }
            this.log("Processing " + res, 2);
            JPackage pkg = cm._package(dirName);
            Properties props = new Properties();
            try {
                FileInputStream in = new FileInputStream(res);
                props.load(in);
                in.close();
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            try {
                clazz = pkg._class(9, className);
            }
            catch (JClassAlreadyExistsException e) {
                throw new BuildException("Name conflict " + className);
            }
            clazz.javadoc().add("Defines string formatting method for each constant in the resource file");
            try {
                lmf_class = cm.parseType("com.sun.xml.ws.util.localization.LocalizableMessageFactory").boxify();
                l_class = cm.parseType("com.sun.xml.ws.util.localization.Localizer").boxify();
                lable_class = cm.parseType("com.sun.xml.ws.util.localization.Localizable").boxify();
            }
            catch (ClassNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
            JFieldVar $msgFactory = clazz.field(28, lmf_class, "messageFactory", (JExpression)JExpr._new(lmf_class).arg(JExpr.lit(bundleName)));
            JFieldVar $localizer = clazz.field(28, l_class, "localizer", (JExpression)JExpr._new(l_class));
            for (Object key : props.keySet()) {
                String methodBaseName = NameConverter.smart.toConstantName(key.toString());
                JMethod method = clazz.method(17, lable_class, "localizable" + methodBaseName);
                int countArgs = this.countArgs(props.getProperty(key.toString()));
                JInvocation format = $msgFactory.invoke("getMessage").arg(JExpr.lit(key.toString()));
                for (int i = 0; i < countArgs; ++i) {
                    format.arg(method.param(Object.class, "arg" + i));
                }
                method.body()._return(format);
                JMethod method2 = clazz.method(17, String.class, methodBaseName);
                method2.javadoc().add(props.get(key));
                JInvocation localize = JExpr.invoke(method);
                for (int i = 0; i < countArgs; ++i) {
                    localize.arg(method2.param(Object.class, "arg" + i));
                }
                method2.body()._return($localizer.invoke("localize").arg(localize));
            }
        }
        try {
            if (this.license == null) {
                cm.build(this.destDir);
            } else {
                FileCodeWriter core = new FileCodeWriter(this.destDir);
                LicenseCodeWriter writer = new LicenseCodeWriter(core, this.license);
                cm.build(writer);
            }
        }
        catch (IOException e) {
            throw new BuildException("Failed to generate code", (Throwable)e);
        }
    }

    private int countArgs(String value) {
        String r2;
        String r1;
        ArrayList<String> x = new ArrayList<String>();
        do {
            r1 = MessageFormat.format(value, x.toArray());
            x.add("xxxx");
        } while (!r1.equals(r2 = MessageFormat.format(value, x.toArray())));
        return x.size() - 1;
    }

    private String getClassName(File res) {
        String name = res.getName();
        int suffixIndex = name.lastIndexOf(46);
        name = name.substring(0, suffixIndex);
        return NameConverter.smart.toClassName(name) + "Messages";
    }

    public static class LicenseCodeWriter
    extends FilterCodeWriter {
        private final File license;

        public LicenseCodeWriter(CodeWriter core, File license) {
            super(core);
            this.license = license;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Writer openSource(JPackage pkg, String fileName) throws IOException {
            Writer w = super.openSource(pkg, fileName);
            PrintWriter out = new PrintWriter(w);
            FileInputStream fin = null;
            try {
                int len;
                fin = new FileInputStream(this.license);
                byte[] buf = new byte[8192];
                while ((len = fin.read(buf)) != -1) {
                    out.write(new String(buf, 0, len));
                }
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
            }
            out.flush();
            return w;
        }
    }
}

