/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.notification;

import com.sun.messaging.Destination;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.SequentialQueue;
import com.sun.messaging.jmq.jmsclient.notification.BrokerAddressListChangedEvent;
import com.sun.messaging.jmq.jmsclient.notification.ConnectionExitEvent;
import com.sun.messaging.jmq.jmsclient.resources.ClientResources;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jms.notification.ConnectionClosedEvent;
import com.sun.messaging.jms.notification.ConnectionClosingEvent;
import com.sun.messaging.jms.notification.ConnectionReconnectFailedEvent;
import com.sun.messaging.jms.notification.ConnectionReconnectedEvent;
import com.sun.messaging.jms.notification.ConsumerEvent;
import com.sun.messaging.jms.notification.Event;
import com.sun.messaging.jms.notification.EventListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

public class EventHandler
implements Runnable {
    private static final int CONSUMER_NOT_READY = 0;
    private static final int CONSUMER_READY = 1;
    private ConnectionImpl connection = null;
    private Thread handlerThread = null;
    protected static final String iMQEventHandler = "iMQEventHandler-";
    private SequentialQueue eventQueue = null;
    private boolean isClosed = false;
    private HashMap consumerEventListeners = new HashMap();
    private boolean closedEventdelivered = false;
    private ExceptionListener exlistener = null;
    public static final long WAIT_TIMEOUT = 120000L;
    private boolean debug = Debug.debug;
    private static boolean debugEvent = Boolean.getBoolean("imq.debug.notification");

    public EventHandler(ConnectionImpl connectionImpl) {
        this.connection = connectionImpl;
        this.init();
    }

    private void init() {
        this.eventQueue = new SequentialQueue(2);
    }

    public synchronized void addConsumerEventListener(Destination destination, EventListener eventListener) throws JMSException {
        if (this.isClosed) {
            throw new JMSException("Event handler is closed");
        }
        this.consumerEventListeners.put(destination, eventListener);
    }

    public synchronized void removeConsumerEventListener(Destination destination) throws JMSException {
        if (this.consumerEventListeners.get(destination) == null) {
            throw new JMSException("XXXI18N -Consumer event listener for destination " + destination + " not found");
        }
        this.consumerEventListeners.remove(destination);
    }

    private synchronized void onEvent(Event event) {
        if (debugEvent) {
            Debug.getPrintStream().println(new Date() + "-- event triggerred, code = " + event.getEventCode() + ", msg = " + event.getEventMessage());
        }
        if (this.isClosed) {
            return;
        }
        this.eventQueue.enqueue(event);
        if (this.handlerThread == null) {
            this.createHandlerThread();
        }
        this.notifyAll();
    }

    public synchronized void close() {
        this.isClosed = true;
        this.notifyAll();
        this.consumerEventListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHandlerThread() {
        EventHandler eventHandler = this;
        synchronized (eventHandler) {
            if (this.handlerThread == null) {
                this.handlerThread = new Thread(this);
                if (this.connection.hasDaemonThreads()) {
                    this.handlerThread.setDaemon(true);
                }
                this.handlerThread.setName(iMQEventHandler + this.connection.getLocalID());
                this.handlerThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        boolean bl2 = true;
        while (bl2) {
            bl = false;
            Object object = this;
            synchronized (object) {
                if (this.shouldWait()) {
                    try {
                        this.wait(120000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.isClosed) {
                return;
            }
            if (this.eventQueue.isEmpty()) {
                bl = true;
            } else {
                object = (Event)this.eventQueue.dequeue();
                if (object instanceof ConsumerEvent) {
                    this.deliverConsumerEvent((ConsumerEvent)object);
                } else if (object instanceof ConnectionExitEvent) {
                    this.deliverException((Event)object);
                } else {
                    this.deliverConnectionEvent((Event)object);
                }
            }
            bl2 = this.shouldContinue(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverException(Event event) {
        try {
            block4: {
                try {
                    if (this.exlistener == null || this.isClosed) break block4;
                    ConnectionExitEvent connectionExitEvent = (ConnectionExitEvent)event;
                    JMSException jMSException = connectionExitEvent.getJMSException();
                    this.exlistener.onException(jMSException);
                    if (!debugEvent) break block4;
                    Debug.getPrintStream().println(new Date() + " Exception is delivered to the listener: " + (Object)((Object)jMSException));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var5_6 = null;
                    this.isClosed = true;
                }
            }
            Object var5_5 = null;
            this.isClosed = true;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.isClosed = true;
            throw throwable;
        }
    }

    private boolean shouldWait() {
        return this.eventQueue.isEmpty() && (this.connection.getEventListener() != null || this.consumerEventListeners.size() > 0) && !this.isClosed;
    }

    private synchronized boolean shouldContinue(boolean bl) {
        boolean bl2 = true;
        if (this.isClosed || bl && this.eventQueue.isEmpty()) {
            this.handlerThread = null;
            bl2 = false;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverConnectionEvent(Event event) {
        EventListener eventListener = this.connection.getEventListener();
        try {
            block4: {
                try {
                    if (!this.shouldDeliver(eventListener, event)) break block4;
                    eventListener.onEvent(event);
                    if (!debugEvent) break block4;
                    Debug.getPrintStream().println(new Date() + "*** Delivered event, code = " + event.getEventCode() + ", msg = " + event.getEventMessage());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Object var5_4 = null;
                    this.postEventProcess(event);
                }
            }
            Object var5_3 = null;
            this.postEventProcess(event);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.postEventProcess(event);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverConsumerEvent(ConsumerEvent consumerEvent) {
        Destination destination = consumerEvent.getDestination();
        EventListener eventListener = null;
        HashMap hashMap = this.consumerEventListeners;
        synchronized (hashMap) {
            eventListener = (EventListener)this.consumerEventListeners.get(destination);
        }
        try {
            block7: {
                try {
                    if (!this.shouldDeliver(eventListener, consumerEvent)) break block7;
                    eventListener.onEvent(consumerEvent);
                    if (!debugEvent) break block7;
                    Debug.getPrintStream().println(new Date() + "*** Delivered event, code = " + consumerEvent.getEventCode() + ", msg = " + consumerEvent.getEventMessage());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Object var7_8 = null;
                    this.postEventProcess(consumerEvent);
                }
            }
            Object var7_7 = null;
            this.postEventProcess(consumerEvent);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.postEventProcess(consumerEvent);
            throw throwable;
        }
    }

    private boolean shouldDeliver(EventListener eventListener, Event event) {
        boolean bl = true;
        if (eventListener == null || this.isClosed) {
            bl = false;
        } else if (event instanceof ConnectionClosedEvent && this.closedEventdelivered) {
            bl = false;
        }
        return bl;
    }

    private void postEventProcess(Event event) {
        String string = event.getEventCode();
        if (event instanceof ConnectionReconnectedEvent) {
            this.connection.setReconnecting(false);
            this.closedEventdelivered = false;
            this.startConnection();
        } else if (event instanceof ConnectionClosedEvent) {
            this.closedEventdelivered = true;
        }
    }

    private void startConnection() {
        block3: {
            try {
                if (!this.connection.getIsStopped()) {
                    this.connection.getProtocolHandler().start();
                }
            }
            catch (Exception exception) {
                if (!this.debug) break block3;
                exception.printStackTrace(Debug.getPrintStream());
            }
        }
    }

    public void triggerConnectionClosedEvent(String string, JMSException jMSException) {
        if (this.connection.getEventListener() == null) {
            return;
        }
        String string2 = ClientResources.getResources().getKString(string, this.connection.getLastContactedBrokerAddress());
        if (string.equals("E207")) {
            string2 = string2 + ", " + "imqPingAckTimeout" + ": " + this.connection.getPingAckTimeout();
        }
        ConnectionClosedEvent connectionClosedEvent = new ConnectionClosedEvent(this.connection, string, string2, jMSException);
        this.onEvent(connectionClosedEvent);
    }

    public void triggerConnectionClosingEvent(String string, long l) {
        if (this.connection.getEventListener() == null) {
            return;
        }
        String string2 = String.valueOf(l);
        String string3 = String.valueOf(l / 1000L);
        Object[] objectArray = new Object[]{string3, string2, this.connection.getLastContactedBrokerAddress()};
        String string4 = ClientResources.getResources().getKString(string, objectArray);
        ConnectionClosingEvent connectionClosingEvent = new ConnectionClosingEvent(this.connection, string, string4, l);
        this.onEvent(connectionClosingEvent);
    }

    public void triggerConnectionReconnectFailedEvent(JMSException jMSException, String string) {
        if (this.connection.getEventListener() == null) {
            return;
        }
        String string2 = "E401";
        String string3 = ClientResources.getResources().getKString(string2, string);
        ConnectionReconnectFailedEvent connectionReconnectFailedEvent = new ConnectionReconnectFailedEvent(this.connection, string2, string3, jMSException);
        this.onEvent(connectionReconnectFailedEvent);
    }

    public void triggerConnectionReconnectedEvent() {
        if (this.connection.getEventListener() == null) {
            return;
        }
        String string = this.connection.getBrokerAddress();
        String string2 = "E301";
        String string3 = ClientResources.getResources().getKString(string2, string);
        ConnectionReconnectedEvent connectionReconnectedEvent = new ConnectionReconnectedEvent(this.connection, string2, string3);
        this.onEvent(connectionReconnectedEvent);
    }

    public void triggerConnectionExitEvent(JMSException jMSException, ExceptionListener exceptionListener) {
        try {
            if (this.connection.getEventListener() == null) {
                return;
            }
            this.exlistener = exceptionListener;
            ConnectionExitEvent connectionExitEvent = new ConnectionExitEvent(this.connection, "E500", jMSException.getMessage(), jMSException);
            this.onEvent(connectionExitEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace(Debug.getPrintStream());
        }
    }

    public void triggerConnectionAddressListChangedEvent(String string) {
        if (this.connection.getEventListener() == null) {
            return;
        }
        String string2 = "E600";
        String string3 = ClientResources.getResources().getKString(string2, string);
        BrokerAddressListChangedEvent brokerAddressListChangedEvent = new BrokerAddressListChangedEvent(this.connection, string2, string3, string);
        this.onEvent(brokerAddressListChangedEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerConsumerEvent(int n, String string, int n2) {
        String string2 = null;
        switch (n) {
            case 0: {
                string2 = "E701";
                break;
            }
            case 1: {
                string2 = "E700";
                break;
            }
            default: {
                Debug.println("Received unknown consumer event: " + n + " on destination " + string);
                return;
            }
        }
        String string3 = ClientResources.getResources().getKString(string2, (DestType.isQueue((int)n2) ? DestType.toString((int)1) : DestType.toString((int)2)) + ":" + string);
        HashMap hashMap = this.consumerEventListeners;
        synchronized (hashMap) {
            Iterator iterator = this.consumerEventListeners.keySet().iterator();
            Destination destination = null;
            while (iterator.hasNext()) {
                destination = (Destination)iterator.next();
                if (!destination.getName().equals(string) || destination.isQueue() != DestType.isQueue((int)n2) || destination.isTemporary() != DestType.isTemporary((int)n2)) continue;
                this.onEvent(new ConsumerEvent(destination, this.connection, string2, string3));
                return;
            }
        }
        Debug.println("Listener not found for consumer INFO: " + string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resendConsumerInfoRequests(ProtocolHandler protocolHandler) throws JMSException {
        HashMap hashMap = this.consumerEventListeners;
        synchronized (hashMap) {
            Iterator iterator = this.consumerEventListeners.keySet().iterator();
            Destination destination = null;
            while (iterator.hasNext()) {
                destination = (Destination)iterator.next();
                protocolHandler.requestConsumerInfo(destination, false);
            }
        }
    }
}

