/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.tcp.http11.FilterFactory;
import com.sun.grizzly.tcp.http11.InputFilter;
import com.sun.grizzly.tcp.http11.OutputFilter;
import com.sun.grizzly.tcp.http11.filters.GzipOutputFilter;
import com.sun.grizzly.tcp.http11.filters.LzmaOutputFilter;
import com.sun.grizzly.util.buf.MessageBytes;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompressionFiltersProvider {
    private static final CompressionFiltersProvider instance = new CompressionFiltersProvider();
    private final TreeMap<Key, FilterFactory> filterFactories;
    private final AtomicInteger counter = new AtomicInteger();

    private CompressionFiltersProvider() {
        this.filterFactories = new TreeMap(new Comparator<Key>(){

            @Override
            public int compare(Key key1, Key key2) {
                return key1.id - key2.id;
            }
        });
        FilterFactory lzmaFilterFactory = new FilterFactory(){

            public String getEncodingName() {
                return "lzma";
            }

            public OutputFilter createOutputFilter() {
                return new LzmaOutputFilter();
            }

            public InputFilter createInputFilter() {
                return null;
            }
        };
        this.registerOutputFilter(lzmaFilterFactory);
        FilterFactory deflateFilterFactory = new FilterFactory(){

            public String getEncodingName() {
                return "deflate";
            }

            public OutputFilter createOutputFilter() {
                return new GzipOutputFilter("deflate");
            }

            public InputFilter createInputFilter() {
                return null;
            }
        };
        FilterFactory gzipFilterFactory = new FilterFactory(){

            public String getEncodingName() {
                return "gzip";
            }

            public OutputFilter createOutputFilter() {
                return new GzipOutputFilter();
            }

            public InputFilter createInputFilter() {
                return null;
            }
        };
        this.filterFactories.put(new Key(this.counter.getAndIncrement(), "deflate"), deflateFilterFactory);
        this.filterFactories.put(new Key(this.counter.getAndIncrement(), "gzip"), gzipFilterFactory);
    }

    public static CompressionFiltersProvider provider() {
        return instance;
    }

    public void registerOutputFilter(FilterFactory filterFactory) {
        this.filterFactories.put(new Key(this.counter.getAndIncrement(), filterFactory.getEncodingName()), filterFactory);
    }

    public Collection<FilterFactory> getFilters() {
        return this.filterFactories.values();
    }

    public boolean supportsOutput(String encoding) {
        return this.getFilterFactory(encoding) != null;
    }

    public boolean supportsOutput(MessageBytes encoding) {
        return this.getOutputFilter(encoding) != null;
    }

    public FilterFactory getFilterFactory(String encoding) {
        for (Map.Entry<Key, FilterFactory> entry : this.filterFactories.entrySet()) {
            if (encoding.indexOf(entry.getKey().encoding) == -1) continue;
            return entry.getValue();
        }
        return null;
    }

    public FilterFactory getOutputFilter(MessageBytes encoding) {
        for (Map.Entry<Key, FilterFactory> entry : this.filterFactories.entrySet()) {
            if (encoding.indexOf(entry.getKey().encoding) == -1) continue;
            return entry.getValue();
        }
        return null;
    }

    private static class Key {
        private final int id;
        private final String encoding;

        public Key(int id, String encoding) {
            this.id = id;
            this.encoding = encoding;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return this.id == other.id;
        }
    }
}

