/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.ComplexSelectorHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ReadController;
import com.sun.grizzly.ReusableTCPSelectorHandler;
import com.sun.grizzly.ReusableUDPSelectorHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.util.Copyable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinSelectorHandler
extends TCPSelectorHandler
implements ComplexSelectorHandler {
    private ReadController[] rrControllers;
    private AtomicInteger roundRobinCounter = new AtomicInteger();
    private Set<Controller.Protocol> customProtocols = new CopyOnWriteArraySet<Controller.Protocol>();

    public RoundRobinSelectorHandler() {
    }

    public RoundRobinSelectorHandler(ReadController[] rrControllers) {
        this.rrControllers = rrControllers;
    }

    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        RoundRobinSelectorHandler copyHandler = (RoundRobinSelectorHandler)copy;
        copyHandler.roundRobinCounter = this.roundRobinCounter;
        copyHandler.rrControllers = this.rrControllers;
    }

    public boolean onAcceptInterest(SelectionKey key, Context context) throws IOException {
        ReadController auxController = this.nextController();
        SelectorHandler protocolSelectorHandler = context.getSelectorHandler();
        SelectableChannel channel = protocolSelectorHandler.acceptWithoutRegistration(key);
        if (channel != null) {
            protocolSelectorHandler.configureChannel(channel);
            SelectorHandler relativeSelectorHandler = auxController.getSelectorHandlerClone(protocolSelectorHandler);
            if (relativeSelectorHandler == null && (relativeSelectorHandler = auxController.getSelectorHandler(protocolSelectorHandler.protocol())) == null) {
                throw new IOException("Can not get correct SelectorHandler");
            }
            auxController.addChannel(channel, relativeSelectorHandler);
        }
        return false;
    }

    public void addProtocolSupport(Controller.Protocol customProtocol) {
        this.customProtocols.add(customProtocol);
    }

    public boolean supportsProtocol(Controller.Protocol protocol) {
        return protocol == Controller.Protocol.TCP || protocol == Controller.Protocol.TLS || this.customProtocols.contains((Object)protocol);
    }

    public boolean supportsClient(SelectorHandler selectorHandler) {
        if (selectorHandler == null) {
            return false;
        }
        if (selectorHandler instanceof ReusableTCPSelectorHandler || selectorHandler instanceof ReusableUDPSelectorHandler) {
            return false;
        }
        Controller.Protocol protocol = selectorHandler.protocol();
        return protocol == Controller.Protocol.TCP || protocol == Controller.Protocol.TLS || protocol == Controller.Protocol.UDP || this.customProtocols.contains((Object)protocol);
    }

    public ReadController nextController() {
        return this.rrControllers[(this.roundRobinCounter.incrementAndGet() & Integer.MAX_VALUE) % this.rrControllers.length];
    }

    public void shutdown() {
        super.shutdown();
        this.customProtocols.clear();
    }
}

