/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.common;

import com.simpligility.maven.plugins.android.PluginInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public final class PomConfigurationHelper {
    public static String getPluginConfigParameter(MavenProject project, String parameter, String defaultValue) {
        String value = null;
        for (Plugin plugin : project.getBuild().getPlugins()) {
            Xpp3Dom configuration;
            if (!plugin.getArtifactId().equals(PluginInfo.getArtifactId()) || (configuration = PomConfigurationHelper.getMojoConfiguration(plugin)) == null || configuration.getChild(parameter) == null) continue;
            value = configuration.getChild(parameter).getValue();
        }
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public static boolean getPluginConfigParameter(MavenProject project, String parameter, boolean defaultValue) {
        String value = PomConfigurationHelper.getPluginConfigParameter(project, parameter, Boolean.toString(defaultValue));
        return Boolean.valueOf(value);
    }

    private static Xpp3Dom getMojoConfiguration(Plugin plugin) {
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        if (configuration == null && !plugin.getExecutions().isEmpty()) {
            configuration = (Xpp3Dom)((PluginExecution)plugin.getExecutions().get(0)).getConfiguration();
        }
        return configuration;
    }
}

