/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XpathAppendingTransformer
implements ResourceTransformer {
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    boolean ignoreDtd = true;
    String resource;
    String[] elements;
    Document doc;

    public boolean canTransformResource(String r) {
        return this.resource != null && this.resource.equalsIgnoreCase(r);
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        Document r;
        try {
            SAXBuilder builder = new SAXBuilder(false);
            builder.setExpandEntities(false);
            if (this.ignoreDtd) {
                builder.setEntityResolver(new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        return new InputSource(new StringReader(""));
                    }
                });
            }
            r = builder.build(is);
        }
        catch (JDOMException e) {
            throw new RuntimeException("Error processing resource " + resource + ": " + e.getMessage(), e);
        }
        if (this.doc == null) {
            this.doc = r;
        } else if (this.elements == null || this.elements.length == 0) {
            this.appendElement(r.getRootElement(), this.doc.getRootElement());
        } else {
            for (String xpath : this.elements) {
                try {
                    XPath path = XPath.newInstance((String)xpath);
                    Object source = path.selectSingleNode((Object)r.getRootElement());
                    if (!(source instanceof Element)) {
                        throw new IOException(String.format("xpath result must be element. %s returned %s", xpath, source));
                    }
                    Object target = path.selectSingleNode((Object)this.doc.getRootElement());
                    if (!(target instanceof Element)) {
                        throw new IOException(String.format("xpath result must be element. %s returned %s", xpath, target));
                    }
                    this.appendElement((Element)source, (Element)target);
                }
                catch (JDOMException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    private void appendElement(Element source, Element target) {
        Iterator itr = source.getAttributes().iterator();
        while (itr.hasNext()) {
            Attribute a = (Attribute)itr.next();
            itr.remove();
            Attribute mergedAtt = target.getAttribute(a.getName(), a.getNamespace());
            if (mergedAtt != null) continue;
            target.setAttribute(a);
        }
        itr = source.getChildren().iterator();
        while (itr.hasNext()) {
            Content n = (Content)itr.next();
            itr.remove();
            target.addContent(n);
        }
    }

    public boolean hasTransformedResource() {
        return this.doc != null;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        jos.putNextEntry(new JarEntry(this.resource));
        new XMLOutputter(Format.getPrettyFormat()).output(this.doc, (OutputStream)jos);
        this.doc = null;
    }
}

