/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase_prebuild;

import com.jayway.maven.plugins.android.common.AndroidExtension;
import com.jayway.maven.plugins.android.common.ArtifactResolverHelper;
import com.jayway.maven.plugins.android.common.DependencyResolver;
import com.jayway.maven.plugins.android.common.PomConfigurationHelper;
import com.jayway.maven.plugins.android.common.UnpackedLibHelper;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="default")
public final class ClasspathModifierLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String INCLUDE_FROM_APKLIK_PARAM = "includeLibsJarsFromApklib";
    private static final String INCLUDE_FROM_AAR_PARAM = "includeLibsJarsFromAar";
    private static final boolean INCLUDE_FROM_APKLIB_DEFAULT = false;
    private static final boolean INCLUDE_FROM_AAR_DEFAULT = false;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Requirement
    private Logger log;
    private boolean addedJarFromLibs = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        this.log.debug("");
        this.log.debug("ClasspathModifierLifecycleParticipant#afterProjectsRead - start");
        this.log.debug("");
        this.log.debug("CurrentProject=" + session.getCurrentProject());
        List projects = session.getProjects();
        DependencyResolver dependencyResolver = new DependencyResolver(this.log, this.dependencyGraphBuilder);
        ArtifactResolverHelper artifactResolverHelper = new ArtifactResolverHelper(this.artifactResolver, this.log);
        for (MavenProject project : projects) {
            Set<Artifact> artifacts;
            this.log.debug("");
            this.log.debug("project=" + project.getArtifact());
            if (!AndroidExtension.isAndroidPackaging(project.getPackaging())) continue;
            UnpackedLibHelper helper = new UnpackedLibHelper(artifactResolverHelper, project, this.log);
            Object projectClassLoader = project.getClassRealm() != null ? project.getClassRealm() : Thread.currentThread().getContextClassLoader();
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)projectClassLoader);
                artifacts = dependencyResolver.getProjectDependenciesFor(project, session);
            }
            catch (DependencyGraphBuilderException e) {}
            continue;
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
                continue;
            }
            boolean includeFromAar = PomConfigurationHelper.getPluginConfigParameter(project, INCLUDE_FROM_AAR_PARAM, false);
            this.log.debug("includeLibsJarsFromAar set to " + includeFromAar);
            boolean includeFromApklib = PomConfigurationHelper.getPluginConfigParameter(project, INCLUDE_FROM_APKLIK_PARAM, false);
            this.log.debug("includeLibsJarsFromApklib set to " + includeFromApklib);
            this.log.debug("projects deps: : " + artifacts);
            for (Artifact artifact : artifacts) {
                String type = artifact.getType();
                if (type.equals("aar")) {
                    this.addClassesToClasspath(helper, project, artifact);
                    if (!includeFromAar) continue;
                    this.addLibsJarsToClassPath(helper, project, artifact);
                    continue;
                }
                if (type.equals("apk")) {
                    this.addClassesToClasspath(helper, project, artifact);
                    continue;
                }
                if (!type.equals("apklib") || !includeFromApklib) continue;
                this.addLibsJarsToClassPath(helper, project, artifact);
            }
        }
        if (this.addedJarFromLibs) {
            this.log.warn("Transitive dependencies should really be provided by Maven dependency management.\n          We suggest you to ask the above providers to package their component properly.\n          Things may break at compile and/or runtime due to multiple copies of incompatible libraries.");
        }
        this.log.debug("");
        this.log.debug("ClasspathModifierLifecycleParticipant#afterProjectsRead - finish");
    }

    private void addLibsJarsToClassPath(UnpackedLibHelper helper, MavenProject project, Artifact artifact) throws MavenExecutionException {
        try {
            File unpackLibFolder = helper.getUnpackedLibFolder(artifact);
            File artifactFile = helper.getArtifactToFile(artifact);
            ZipFile zipFile = new ZipFile(artifactFile);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                String entryName = entry.getName();
                if (!Pattern.matches("^libs/.+\\.jar$", entryName)) continue;
                File libsJarFile = new File(unpackLibFolder, entryName);
                this.log.warn("Adding jar from libs folder to classpath: " + libsJarFile);
                if (!libsJarFile.getParentFile().exists()) {
                    libsJarFile.getParentFile().mkdirs();
                }
                libsJarFile.createNewFile();
                Dependency dependency = this.createSystemScopeDependency(artifact, libsJarFile, libsJarFile.getName());
                project.getModel().addDependency(dependency);
                this.addedJarFromLibs = true;
            }
        }
        catch (MojoExecutionException e) {
            this.log.debug("Error extract jars");
        }
        catch (ZipException e) {
            this.log.debug("Error");
        }
        catch (IOException e) {
            this.log.debug("Error");
        }
    }

    private void addClassesToClasspath(UnpackedLibHelper helper, MavenProject project, Artifact artifact) throws MavenExecutionException {
        File classesJar = helper.getUnpackedClassesJar(artifact);
        this.log.debug("Adding to classpath : " + classesJar);
        classesJar.getParentFile().mkdirs();
        try {
            classesJar.createNewFile();
            this.log.debug("Created dummy " + classesJar.getName() + " exist=" + classesJar.exists());
        }
        catch (IOException e) {
            throw new MavenExecutionException("Could not add " + classesJar.getName() + " as dependency", (Throwable)e);
        }
        Dependency dependency = this.createSystemScopeDependency(artifact, classesJar, "extracted");
        project.getModel().addDependency(dependency);
    }

    private Dependency createSystemScopeDependency(Artifact artifact, File location, String suffix) {
        String artifactId = artifact.getArtifactId();
        if (suffix != null) {
            artifactId = artifactId + "_" + suffix;
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifactId);
        dependency.setVersion(artifact.getVersion());
        dependency.setScope("system");
        dependency.setSystemPath(location.getAbsolutePath());
        return dependency;
    }
}

