/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import oracle.jdbc.SecurityInformation;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.nl.NLException;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.DNVerifier;
import oracle.net.nt.ExtendedSSLContext;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.SSLConfig;
import oracle.net.nt.SSLContextCache;
import oracle.net.nt.SSLSocketChannel;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TcpsConfigure;
import oracle.net.nt.WSSSocketChannel;

public class TcpsNTAdapter
extends TcpNTAdapter {
    private static final String CLASS_NAME = TcpsNTAdapter.class.getName();
    private static final int SSL_CERT_SAN_TYPE_DNS_NAME = 2;
    private static final int SSL_CERT_SAN_TYPE_IP_ADDR = 7;
    private String dnToMatch;
    private SecurityInformation.DNMatchStatus dnMatchStatus = SecurityInformation.DNMatchStatus.NOT_VERIFIED;
    private String hostNameForDNMatch = this.host;
    private String serviceNameForDNMatch = null;
    private SocketChannel underlyingSocketChannel = null;
    private SSLEngine sslEngine;
    private String webSocketURI = "/sqlnet";
    private ExtendedSSLContext extendedSSLContext;
    private SSLConfig sslConfig;
    private final DNVerifier dnVerifier;

    public TcpsNTAdapter(String address, @Blind(value=PropertiesBlinder.class) Properties socketOptions, Diagnosable diagnosable, ConnOption connOption) throws NLException, IOException {
        super(address, socketOptions, diagnosable, connOption);
        this.dnVerifier = new DNVerifier(connOption, Boolean.valueOf((String)this.getOption(106)), diagnosable);
        if ("WSS".equalsIgnoreCase(this.protocol) && connOption.webSocketUri != null) {
            this.webSocketURI = connOption.webSocketUri;
        }
    }

    @Override
    public void connect(DMSFactory.DMSNoun dmsParent) throws IOException, InterruptedIOException {
        this.sslEngine = this.newSSLEngine();
        super.connect(dmsParent);
    }

    @Override
    protected void establishSocket(InetSocketAddress inetAddr, DMSFactory.DMSNoun dmsParent) throws IOException, InterruptedIOException {
        long socketConnectStartTime = System.currentTimeMillis();
        super.establishSocket(inetAddr, dmsParent);
        try {
            this.underlyingSocketChannel = this.socketChannel;
            this.socketChannel = new SSLSocketChannel(this.socketChannel, this.sslEngine, this.getDiagnosable(), this.dnVerifier, false, this.extendedSSLContext);
            this.socket = this.socketChannel.socket();
            this.setSSLSocketOptions();
            if ("WSS".equalsIgnoreCase(this.protocol)) {
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "establishSocket", "websocketURI={0}. ", (String)null, null, (Object)this.webSocketURI);
                String httpAuthUser = (String)this.socketOptions.get(26);
                OpaqueString httpAuthPwd = (OpaqueString)this.socketOptions.get(27);
                this.socketChannel = new WSSSocketChannel(this.socketChannel, this.webSocketURI, this.host, this.port, httpAuthUser, httpAuthPwd, this.getDiagnosable());
            }
        }
        catch (IOException ioe) {
            throw this.socketConnectFailure(ioe, System.currentTimeMillis() - socketConnectStartTime, inetAddr.getHostString());
        }
    }

    private IOException socketConnectFailure(IOException initCause, long elapsed, String hostIdentifier) {
        String newExMessage = String.format("%s, socket connect lapse %d ms. %s %d %s %s %s %s", initCause.getMessage(), elapsed, hostIdentifier, this.port, this.proxy == null ? "" : "Proxy = " + this.proxy.toString(), this.connectTimeout, this.getInetAddress(), this.useNio);
        IOException newEx = new IOException(newExMessage, initCause);
        return newEx;
    }

    @Override
    public final CompletionStage<Void> connectAsync(DMSFactory.DMSNoun dmsParent, AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor) {
        if (!this.useNio.booleanValue()) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous connection is not supported when oracle.jdbc.javaNetNio=false"));
        }
        if ("WSS".equalsIgnoreCase(this.protocol)) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous connection is not supported with the WebSocket Secureprotocol"));
        }
        try {
            this.sslEngine = this.newSSLEngine();
        }
        catch (IOException newEngineFailure) {
            return CompletionStageUtil.failedStage(newEngineFailure);
        }
        return super.connectAsync(dmsParent, outboundTimeout, asyncExecutor);
    }

    @Override
    protected CompletionStage<Void> establishSocketAsync(InetSocketAddress inetAddr, DMSFactory.DMSNoun dmsParent, AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor) {
        long socketConnectStartTime = System.currentTimeMillis();
        return super.establishSocketAsync(inetAddr, dmsParent, outboundTimeout, asyncExecutor).thenCompose(nil -> {
            try {
                this.underlyingSocketChannel = this.socketChannel;
                SSLSocketChannel sslSocketChannel = new SSLSocketChannel(this.socketChannel, this.sslEngine, this.getDiagnosable(), this.dnVerifier, false, this.extendedSSLContext);
                this.socketChannel = sslSocketChannel;
                this.setSSLSocketOptions();
                return sslSocketChannel.doSSLHandshakeAsync(asyncExecutor).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, ioException -> {
                    throw new AsyncHandshakeException((IOException)ioException);
                }));
            }
            catch (IOException ioe) {
                return CompletionStageUtil.failedStage(this.socketConnectFailure(ioe, System.currentTimeMillis() - socketConnectStartTime, inetAddr.getHostString()));
            }
        });
    }

    public void renegotiateSession() throws IOException {
        this.sslEngine = this.newSSLEngine();
        SSLSocketChannel newSSLSocketChannel = new SSLSocketChannel(this.underlyingSocketChannel, this.sslEngine, this.getDiagnosable(), this.dnVerifier, true, this.extendedSSLContext);
        if (this.protocol.equalsIgnoreCase("wss")) {
            this.socketChannel.setUnderlyingChannel(newSSLSocketChannel);
        } else {
            this.socketChannel = newSSLSocketChannel;
        }
        this.socket = this.socketChannel.socket();
        String temp = (String)this.socketOptions.get(3);
        if (temp != null) {
            this.setOption(3, temp);
        }
        this.setSSLSocketOptions();
    }

    public void setSSLSocketOptions() throws IOException {
        super.setSocketOptions();
    }

    public String getNegotiatedTLSVersion() throws IOException {
        SSLSession session = this.getSSLSession();
        if (session != null) {
            return session.getProtocol();
        }
        return null;
    }

    @Override
    public void setOption(int option, Object value) throws IOException, NetException {
        switch (option) {
            case 108: {
                this.setServerDNMatchValue((String[])value);
                break;
            }
            default: {
                super.setOption(option, value);
            }
        }
    }

    @Override
    public Object getOption(int option) throws IOException, NetException {
        switch (option) {
            case 102: {
                String cipherSuiteInUse = this.getSSLSession().getCipherSuite();
                if (cipherSuiteInUse != null && cipherSuiteInUse.indexOf("NULL") == -1) {
                    return "TRUE";
                }
                return "FALSE";
            }
            case 105: {
                return this.getSSLSession().getCipherSuite();
            }
            case 103: {
                X509Certificate l_certificate = (X509Certificate)this.getSSLSession().getPeerCertificates()[0];
                return l_certificate.getSubjectDN().getName();
            }
            case 104: {
                return this.getSSLSession().getPeerCertificateChain();
            }
            case 106: {
                String sslServerDNMatchRequiredString = (String)this.socketOptions.getOrDefault((Object)4, this.socketOptions.get(40));
                return Boolean.toString(sslServerDNMatchRequiredString.equalsIgnoreCase("YES") || sslServerDNMatchRequiredString.equalsIgnoreCase("ON") || sslServerDNMatchRequiredString.equalsIgnoreCase("TRUE"));
            }
        }
        return super.getOption(option);
    }

    private SSLSession getSSLSession() {
        return this.sslEngine.getSession();
    }

    public SecurityInformation.DNMatchStatus getDNMatchStatus() {
        return ((SSLSocketChannel)this.socketChannel).getDnMatchStatus();
    }

    public void verifyDN() throws IOException {
        if (this.dnVerifier.isWeakDNMatchAllowed()) {
            ((SSLSocketChannel)this.socketChannel).verifyDN();
        }
    }

    private void setServerDNMatchValue(String[] value) {
        String origSSLServerCertDN = value[0];
        String origServiceName = value[1];
        if (value[2] != null) {
            this.hostNameForDNMatch = value[2];
        }
        if (origSSLServerCertDN != null) {
            this.dnToMatch = origSSLServerCertDN;
        }
        if (origServiceName != null) {
            this.serviceNameForDNMatch = origServiceName.trim();
        }
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.TCPS;
    }

    private SSLEngine newSSLEngine() throws IOException {
        if (this.extendedSSLContext == null) {
            if (this.sslConfig == null) {
                this.sslConfig = SSLConfig.newInstance(this.socketOptions);
            }
            this.extendedSSLContext = SSLContextCache.instance().get(this.sslConfig, this.getDiagnosable());
        }
        SSLEngine newEngine = this.extendedSSLContext.context().createSSLEngine(this.inetSocketAddress.getHostString(), this.port);
        TcpsConfigure.configure(newEngine, this.socketOptions, this.getDiagnosable());
        newEngine.setUseClientMode(true);
        return newEngine;
    }

    @Override
    public final void registerForNonBlockingRead(Consumer<Throwable> onReady) throws IOException {
        assert (this.socketChannel instanceof SSLSocketChannel) : "Not an SSLSocketChannel: " + this.socketChannel;
        if (((SSLSocketChannel)this.socketChannel).hasRemaining()) {
            onReady.accept(null);
        } else {
            super.registerForNonBlockingRead(onReady);
        }
    }

    void setSSLContext(SSLContext sslContext) {
        this.extendedSSLContext = ExtendedSSLContext.wrap(sslContext);
    }

    static class AsyncHandshakeException
    extends IOException {
        AsyncHandshakeException(IOException cause) {
            super(cause);
        }
    }
}

