/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eventbus.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.eventbus.spi.SubscriberConfigProvider;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncSubscribersGatekeeper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncSubscribersGatekeeper.class);
    public static final String ALLOW_SYNC_SUBSCRIBERS = "eventbus.allow.sync.subscribers";
    public static final String SYNC_SUBSCRIBERS_WHITELIST_JSON = "eventbus.sync.subscribers.whitelist.json";
    public static final SetMultimap<String, String> EMPTY_WHITELIST = Multimaps.forMap(Collections.emptyMap());
    private static DynamicBooleanProperty allowSyncSubs;
    private static AtomicReference<SetMultimap<String, String>> syncSubsWhiteList;
    private static DynamicStringProperty syncSubsWhitelistJson;
    private static final TypeToken<SetMultimap<String, String>> whitelistTypeToken;
    public static final String ALLOW_ALL_EVENTS = "*";
    private static final Gson whiteListJsonParser;

    public static boolean isSyncSubscriber(SubscriberConfigProvider.SubscriberConfig subscribe, Class eventClass, Class subscriberClass) {
        if (subscribe.syncIfAllowed() && allowSyncSubs.get()) {
            SetMultimap<String, String> whiteList = syncSubsWhiteList.get();
            if (whiteList.isEmpty() || !whiteList.containsKey((Object)subscriberClass.getName())) {
                return true;
            }
            Set allowedEvents = whiteList.get((Object)subscriberClass.getName());
            return allowedEvents.contains(ALLOW_ALL_EVENTS) || allowedEvents.contains(eventClass.getName());
        }
        return false;
    }

    @VisibleForTesting
    static void initState() {
        syncSubsWhiteList = new AtomicReference<SetMultimap<String, String>>(EMPTY_WHITELIST);
        allowSyncSubs = DynamicPropertyFactory.getInstance().getBooleanProperty(ALLOW_SYNC_SUBSCRIBERS, true);
        syncSubsWhitelistJson = DynamicPropertyFactory.getInstance().getStringProperty(SYNC_SUBSCRIBERS_WHITELIST_JSON, "", new Runnable(){

            @Override
            public void run() {
                SyncSubscribersGatekeeper.populateSubsWhiteList();
            }
        });
    }

    private static void populateSubsWhiteList() {
        SetMultimap<String, String> originalVal = syncSubsWhiteList.get();
        String newWhiteListStr = syncSubsWhitelistJson.get();
        SetMultimap newVal = EMPTY_WHITELIST;
        if (null != newWhiteListStr && !newWhiteListStr.isEmpty()) {
            try {
                SetMultimap parsed = (SetMultimap)whiteListJsonParser.fromJson(newWhiteListStr, whitelistTypeToken.getType());
                if (null != parsed) {
                    newVal = parsed;
                }
            }
            catch (JsonParseException e) {
                LOGGER.error(String.format("Illegal value %s for property %s. The value should be a json that can be converted to a type %s. Ignoring this change.", newWhiteListStr, SYNC_SUBSCRIBERS_WHITELIST_JSON, whitelistTypeToken.getType()), (Throwable)e);
            }
        }
        if (!syncSubsWhiteList.compareAndSet(originalVal, newVal)) {
            LOGGER.debug("Sync subscribers whitelist concurrently modified, ignoring this change: " + newWhiteListStr);
        } else {
            LOGGER.info("Sync subscribers whitelist updated to: " + newWhiteListStr);
        }
    }

    static {
        SyncSubscribersGatekeeper.initState();
        whitelistTypeToken = new TypeToken<SetMultimap<String, String>>(){};
        whiteListJsonParser = new GsonBuilder().registerTypeAdapter(whitelistTypeToken.getType(), (Object)new JsonDeserializer<SetMultimap<String, String>>(){

            public SetMultimap<String, String> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                SetMultimap toReturn = Multimaps.newSetMultimap(new HashMap(), (Supplier)new Supplier<Set<String>>(){

                    public Set<String> get() {
                        return new HashSet<String>();
                    }
                });
                for (Map.Entry entry : ((JsonObject)jsonElement).entrySet()) {
                    for (JsonElement element : (JsonArray)entry.getValue()) {
                        String value = element.getAsString();
                        if (null == value || value.isEmpty()) continue;
                        toReturn.get(entry.getKey()).add(value);
                    }
                    if (toReturn.containsKey(entry.getKey())) continue;
                    toReturn.put(entry.getKey(), (Object)SyncSubscribersGatekeeper.ALLOW_ALL_EVENTS);
                }
                return toReturn;
            }
        }).create();
    }
}

