/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.mediaservices;

import javax.validation.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="azure.mediaservices")
public class MediaServicesProperties {
    public static final String MEDIA_SERVICE_URI = "https://media.windows.net/API/";
    public static final String OAUTH_URI = "https://wamsprodglobal001acs.accesscontrol.windows.net/v2/OAuth2-13";
    public static final String SCOPE = "urn:WindowsAzureMediaServices";
    @NotEmpty(message="Please Set azure.mediaservices.account-name in application.properties")
    private @NotEmpty(message="Please Set azure.mediaservices.account-name in application.properties") String accountName;
    @NotEmpty(message="Please Set azure.mediaservices.account-key in application.properties")
    private @NotEmpty(message="Please Set azure.mediaservices.account-key in application.properties") String accountKey;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyScheme = "http";
    private boolean allowTelemetry = true;

    public boolean isAllowTelemetry() {
        return this.allowTelemetry;
    }

    public void setAllowTelemetry(boolean allowTelemetry) {
        this.allowTelemetry = allowTelemetry;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyScheme() {
        return this.proxyScheme;
    }

    public void setProxyScheme(String proxyScheme) {
        this.proxyScheme = proxyScheme;
    }
}

