/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.microsoft.azure.spring.autoconfigure.aad.AADAuthenticationFilter;
import com.microsoft.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpointsProperties;
import com.microsoft.azure.telemetry.TelemetryProxy;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="azure.activedirectory", value={"client-id", "client-secret"})
@EnableConfigurationProperties(value={AADAuthenticationProperties.class, ServiceEndpointsProperties.class})
public class AADAuthenticationFilterAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AADAuthenticationProperties.class);
    private final AADAuthenticationProperties aadAuthProps;
    private final ServiceEndpointsProperties serviceEndpointsProps;
    private final TelemetryProxy telemetryProxy;

    public AADAuthenticationFilterAutoConfiguration(AADAuthenticationProperties aadAuthFilterProps, ServiceEndpointsProperties serviceEndpointsProps) {
        this.aadAuthProps = aadAuthFilterProps;
        this.serviceEndpointsProps = serviceEndpointsProps;
        this.telemetryProxy = new TelemetryProxy(aadAuthFilterProps.isAllowTelemetry());
    }

    @Bean
    @Scope(value="singleton")
    @ConditionalOnMissingBean(value={AADAuthenticationFilter.class})
    public AADAuthenticationFilter azureADJwtTokenFilter() {
        LOG.info("AzureADJwtTokenFilter Constructor.");
        this.trackCustomEvent();
        return new AADAuthenticationFilter(this.aadAuthProps, this.serviceEndpointsProps);
    }

    private void trackCustomEvent() {
        HashMap<String, String> customTelemetryProperties = new HashMap<String, String>();
        String[] packageNames = this.getClass().getPackage().getName().split("\\.");
        if (packageNames.length > 1) {
            customTelemetryProperties.put("serviceName", packageNames[packageNames.length - 1]);
        }
        this.telemetryProxy.trackEvent(ClassUtils.getUserClass(this.getClass()).getSimpleName(), customTelemetryProperties);
    }
}

