/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.microsoft.azure.keyvault.spring.KeyVaultEnvironmentPostProcessorHelper;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ClassUtils;

public class KeyVaultEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (this.isKeyVaultEnabled(environment)) {
            KeyVaultEnvironmentPostProcessorHelper helper = new KeyVaultEnvironmentPostProcessorHelper(environment);
            helper.addKeyVaultPropertySource();
        }
    }

    private boolean isKeyVaultEnabled(ConfigurableEnvironment environment) {
        if (environment.getProperty("azure.keyvault.client-id") == null) {
            return false;
        }
        return (Boolean)environment.getProperty("azure.keyvault.enabled", Boolean.class, (Object)true) != false && this.isKeyVaultClientAvailable();
    }

    private boolean isKeyVaultClientAvailable() {
        return ClassUtils.isPresent((String)"com.microsoft.azure.keyvault.KeyVaultClient", (ClassLoader)KeyVaultEnvironmentPostProcessor.class.getClassLoader());
    }
}

