/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer.thesaurus.helpers;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.helpers.VradiTreeHelper;
import com.jurismarches.vradi.ui.offer.thesaurus.loadors.RootThesaurusNodeLoadors;
import com.jurismarches.vradi.ui.offer.thesaurus.loadors.ThesaurusNodeLoadors;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import jaxx.runtime.swing.nav.tree.NavTreeNode;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public class ThesaurusTreeHelper
extends VradiTreeHelper {
    private static final Log log = LogFactory.getLog(ThesaurusTreeHelper.class);
    protected RootThesaurus rootThesaurus;
    protected Thesaurus thesaurus;
    protected boolean listening = true;

    public ThesaurusTreeHelper(VradiDataProvider dataProvider) {
        this.init(dataProvider);
    }

    public ThesaurusTreeHelper(VradiDataProvider dataProvider, RootThesaurus rootThesaurus) {
        this.rootThesaurus = rootThesaurus;
        this.init(dataProvider);
    }

    public ThesaurusTreeHelper(VradiDataProvider dataProvider, Thesaurus thesaurus) {
        this.thesaurus = thesaurus;
        this.init(dataProvider);
    }

    protected void init(VradiDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.ALL);
    }

    public TreeModel createTreeModel() {
        VradiTreeNode root;
        if (this.thesaurus != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Root creation] thesaurus " + this.thesaurus.getName()));
            }
            root = new VradiTreeNode(Thesaurus.class, this.thesaurus.getWikittyId(), null, (NavTreeNodeChildLoador)ThesaurusTreeHelper.getChildLoador(ThesaurusNodeLoadors.class));
        } else if (this.rootThesaurus != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Root creation] root thesaurus " + this.rootThesaurus.getName()));
            }
            root = new VradiTreeNode(RootThesaurus.class, this.rootThesaurus.getWikittyId(), null, (NavTreeNodeChildLoador)ThesaurusTreeHelper.getChildLoador(ThesaurusNodeLoadors.class));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"[Root creation] all root thesaurus");
            }
            root = new VradiTreeNode(String.class, "Root node", null, (NavTreeNodeChildLoador)ThesaurusTreeHelper.getChildLoador(RootThesaurusNodeLoadors.class));
        }
        DefaultTreeModel model = this.createModel(root, new Object[0]);
        root.populateChilds(this.getBridge(), this.getDataProvider());
        this.registerLoadedIds(root);
        return model;
    }

    public void tryToSelect(String id) {
        Thesaurus thesaurus = (Thesaurus)VradiService.getWikittyProxy().restore(Thesaurus.class, id);
        this.tryToSelect(thesaurus);
    }

    public void tryToSelect(Thesaurus thesaurus) {
        VradiTreeNode nodeFound;
        if (!thesaurus.getWikittyId().equals(((VradiTreeNode)this.getRootNode()).getId()) && (nodeFound = this.findThesaurusNode(thesaurus)) != null) {
            this.selectNode((NavNode)nodeFound);
        }
    }

    public void tryToSelect(List<String> thesaurusIds) {
        WikittyProxy proxy = VradiService.getWikittyProxy();
        this.tryToSelect(proxy.restore(Thesaurus.class, thesaurusIds));
    }

    public void tryToSelect(Collection<Thesaurus> thesauruses) {
        if (thesauruses == null) {
            return;
        }
        ArrayList<VradiTreeNode> nodes = new ArrayList<VradiTreeNode>();
        for (Thesaurus thesaurus : thesauruses) {
            VradiTreeNode toSelect;
            String id;
            if (thesaurus == null || (id = thesaurus.getWikittyId()).equals(((VradiTreeNode)this.getRootNode()).getId()) || (toSelect = this.findThesaurusNode(thesaurus)) == null) continue;
            nodes.add(toSelect);
        }
        this.selectNodes(nodes);
    }

    public void tryToUnselect(String id) {
        WikittyProxy proxy = VradiService.getWikittyProxy();
        this.tryToUnselect((Thesaurus)proxy.restore(Thesaurus.class, id));
    }

    public void tryToUnselect(Thesaurus thesaurus) {
        this.tryToUnselect(thesaurus.getWikittyId());
        VradiTreeNode nodeFound = this.findThesaurusNode(thesaurus);
        if (nodeFound != null) {
            this.unSelectNode((NavNode)nodeFound);
        }
    }

    public void tryToUnselect(List<String> thesaurusIds) {
        WikittyProxy proxy = VradiService.getWikittyProxy();
        this.tryToUnselect(proxy.restore(Thesaurus.class, thesaurusIds));
    }

    public void tryToUnselect(Collection<Thesaurus> thesauruses) {
        if (thesauruses == null) {
            return;
        }
        ArrayList<VradiTreeNode> nodes = new ArrayList<VradiTreeNode>();
        for (Thesaurus thesaurus : thesauruses) {
            VradiTreeNode toSelect;
            String id;
            if (thesaurus == null || (id = thesaurus.getWikittyId()).equals(((VradiTreeNode)this.getRootNode()).getId()) || (toSelect = this.findThesaurusNode(thesaurus)) == null) continue;
            nodes.add(toSelect);
        }
        this.unSelectNodes(nodes);
    }

    protected VradiTreeNode findThesaurusNode(String thesaurusId) {
        WikittyProxy proxy = VradiService.getWikittyProxy();
        return this.findThesaurusNode((Thesaurus)proxy.restore(Thesaurus.class, thesaurusId));
    }

    protected VradiTreeNode findThesaurusNode(Thesaurus thesaurus) {
        VradiTreeNode parentNode = (VradiTreeNode)this.getRootNode();
        VradiTreeNode rootNode = (VradiTreeNode)this.getChild((NavNode)parentNode, thesaurus.getRootThesaurus());
        if (rootNode != null) {
            parentNode = rootNode;
        }
        WikittyProxy proxy = VradiService.getWikittyProxy();
        List<Thesaurus> parentList = this.getParentsPathThesaurus(proxy, thesaurus);
        for (Thesaurus parent : parentList) {
            VradiTreeNode nodeFound = (VradiTreeNode)this.getChild((NavNode)parentNode, parent.getWikittyId());
            if (nodeFound == null) continue;
            parentNode = nodeFound;
        }
        if (!parentNode.getId().equals(thesaurus.getWikittyId())) {
            return null;
        }
        return parentNode;
    }

    protected List<Thesaurus> getParentsPathThesaurus(WikittyProxy proxy, Thesaurus thesaurus) {
        Thesaurus parent;
        ArrayList<Thesaurus> parents = new ArrayList<Thesaurus>();
        if (!ThesaurusDataHelper.isFirstChild(thesaurus) && (parent = (Thesaurus)proxy.restore(Thesaurus.class, thesaurus.getParent())) != null) {
            List<Thesaurus> thesauruses = this.getParentsPathThesaurus(proxy, parent);
            parents.addAll(thesauruses);
        }
        parents.add(thesaurus);
        return parents;
    }

    protected List<String> extractIds(List<Thesaurus> beans) {
        ArrayList<String> ids = new ArrayList<String>();
        if (beans != null) {
            for (Thesaurus bean : beans) {
                if (bean == null) continue;
                ids.add(bean.getWikittyId());
            }
        }
        return ids;
    }

    public static RootThesaurus getRootThesaurus(VradiTreeNode node) {
        if (!node.getInternalClass().equals(RootThesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreRootThesaurus(node.getId());
    }

    public static Thesaurus getThesaurus(VradiTreeNode node) {
        if (!node.getInternalClass().equals(Thesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreThesaurus(node.getId());
    }

    protected void refresh(VradiTreeNode node) {
        if (node == null) {
            return;
        }
        ((NavTreeBridge)this.getBridge()).nodeChanged((TreeNode)((Object)node));
    }

    @Override
    public void putWikitty(String wikittyId, Set<String> wikittyExtensions) {
        if (wikittyExtensions.contains("Thesaurus")) {
            Thesaurus thesaurusConcerned = ThesaurusDataHelper.restoreThesaurus(wikittyId);
            if (thesaurusConcerned == null) {
                return;
            }
            if (this.idsLoaded.contains(thesaurusConcerned.getParent())) {
                VradiTreeNode existingNode = this.findThesaurusNode(wikittyId);
                if (existingNode != null) {
                    VradiTreeNode parent = (VradiTreeNode)existingNode.getParent();
                    String newParentId = thesaurusConcerned.getParent();
                    if (parent != null && !parent.getId().equals(newParentId)) {
                        VradiTreeNode newParentNode = this.findThesaurusNode(newParentId);
                        ((NavTreeBridge)this.getBridge()).removeNodeFromParent((NavTreeNode)existingNode);
                        if (this.findThesaurusNode(wikittyId) == null) {
                            this.insertNode((NavNode)newParentNode, (NavNode)existingNode);
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Modification case :  " + thesaurusConcerned.getName()));
                        }
                        this.refresh(existingNode);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creation case :  " + thesaurusConcerned.getName()));
                    }
                    VradiTreeNode parentNode = this.findThesaurusNode(thesaurusConcerned.getParent());
                    VradiTreeNode newNode = ((ThesaurusNodeLoadors)ThesaurusTreeHelper.getChildLoador(ThesaurusNodeLoadors.class)).createNode(wikittyId, (NavDataProvider)this.getDataProvider());
                    if (this.findThesaurusNode(wikittyId) == null) {
                        this.insertNode((NavNode)parentNode, (NavNode)newNode);
                    }
                }
            }
        }
        if (wikittyExtensions.contains("RootThesaurus")) {
            VradiTreeNode existingNode = this.findThesaurusNode(wikittyId);
            if (existingNode != null) {
                this.refresh(existingNode);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Refresh root thesaurus : " + wikittyId));
                }
                VradiTreeNode newNode = ((RootThesaurusNodeLoadors)ThesaurusTreeHelper.getChildLoador(RootThesaurusNodeLoadors.class)).createNode(wikittyId, (NavDataProvider)this.getDataProvider());
                this.insertNode(this.getRootNode(), (NavNode)newNode);
            }
        }
    }

    @Override
    public void removeWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove event : " + event));
        }
        for (String wikittyId : event.getIds()) {
            if (!this.isLoadedId(wikittyId)) continue;
            VradiTreeNode node = this.findThesaurusNode(wikittyId);
            this.idsLoaded.remove(wikittyId);
            if (node == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing node " + wikittyId + " from parent"));
            }
            VradiTreeNode parent = (VradiTreeNode)node.getParent();
            int index = parent.getIndex((TreeNode)((Object)node));
            node.removeFromParent();
            ((NavTreeBridge)this.getBridge()).nodesWereRemoved((TreeNode)((Object)parent), new int[]{index}, (Object[])new VradiTreeNode[]{node});
        }
    }
}

