/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.helpers;

import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.loadors.RootThesaurusTreeTableNodeLoadors;
import com.jurismarches.vradi.ui.admin.loadors.ThesaurusTreeTableNodeLoadors;
import com.jurismarches.vradi.ui.admin.models.ThesaurusTreeTableModel;
import com.jurismarches.vradi.ui.helpers.ThesaurusDataHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeTableNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.treetable.NavTreeTableBridge;
import jaxx.runtime.swing.nav.treetable.NavTreeTableHelper;
import jaxx.runtime.swing.nav.treetable.NavTreeTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

public class ThesaurusTreeTableHelper
extends NavTreeTableHelper<VradiTreeTableNode>
implements WikittyServiceListener {
    private static final Log log = LogFactory.getLog(ThesaurusTreeTableHelper.class);
    protected RootThesaurus rootThesaurus;
    protected List<String> idsLoaded = new ArrayList<String>();

    public ThesaurusTreeTableHelper() {
        this(new VradiDataProvider());
    }

    public ThesaurusTreeTableHelper(RootThesaurus rootThesaurus) {
        this(new VradiDataProvider());
        this.rootThesaurus = rootThesaurus;
    }

    public ThesaurusTreeTableHelper(VradiDataProvider dataProvider) {
        this.init(dataProvider);
    }

    protected void init(VradiDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
        VradiService.getWikittyService().addWikittyServiceListener((WikittyServiceListener)this, WikittyService.ServiceListenerType.ALL);
    }

    public void setUI(JXTreeTable tree, boolean addExpandTreeListener, boolean addOneClickSelectionListener, TreeSelectionListener listener, TreeWillExpandListener willExpandListener) {
        super.setUI(tree, addExpandTreeListener, addOneClickSelectionListener, listener, willExpandListener);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                VradiTreeTableNode node = (VradiTreeTableNode)((Object)event.getPath().getLastPathComponent());
                ThesaurusTreeTableHelper.this.registerLoadedIds(node);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                VradiTreeTableNode node = (VradiTreeTableNode)((Object)event.getPath().getLastPathComponent());
                Enumeration enumeration = node.children();
                while (enumeration.hasMoreElements()) {
                    VradiTreeTableNode child = (VradiTreeTableNode)((Object)enumeration.nextElement());
                    ThesaurusTreeTableHelper.this.idsLoaded.remove(child.getId());
                }
            }
        });
    }

    public void registerLoadedIds(VradiTreeTableNode node) {
        this.idsLoaded.add(node.getId());
        Enumeration enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            VradiTreeTableNode child = (VradiTreeTableNode)((Object)enumeration.nextElement());
            this.idsLoaded.add(child.getId());
        }
    }

    public void tryToSelect(String id) {
        Thesaurus thesaurus = (Thesaurus)VradiService.getWikittyProxy().restore(Thesaurus.class, id);
        this.tryToSelect(thesaurus);
    }

    public void tryToSelect(Thesaurus thesaurus) {
        VradiTreeTableNode nodeFound;
        if (!thesaurus.getWikittyId().equals(((VradiTreeTableNode)this.getRootNode()).getId()) && (nodeFound = this.findThesaurusNode(thesaurus)) != null) {
            this.selectNode((NavNode)nodeFound);
        }
    }

    public void tryToSelect(List<String> thesaurusIds) {
        WikittyProxy proxy = VradiService.getWikittyProxy();
        this.tryToSelect(proxy.restore(Thesaurus.class, thesaurusIds));
    }

    public void tryToSelect(Collection<Thesaurus> thesauruses) {
        if (thesauruses == null) {
            return;
        }
        ArrayList<VradiTreeTableNode> nodes = new ArrayList<VradiTreeTableNode>();
        for (Thesaurus thesaurus : thesauruses) {
            VradiTreeTableNode toSelect;
            String id;
            if (thesaurus == null || (id = thesaurus.getWikittyId()).equals(((VradiTreeTableNode)this.getRootNode()).getId()) || (toSelect = this.findThesaurusNode(thesaurus)) == null) continue;
            nodes.add(toSelect);
        }
        this.selectNodes(nodes);
    }

    public void tryToUnselect(String id) {
        WikittyProxy proxy = VradiService.getWikittyProxy();
        this.tryToUnselect((Thesaurus)proxy.restore(Thesaurus.class, id));
    }

    public void tryToUnselect(Thesaurus thesaurus) {
        this.tryToUnselect(thesaurus.getWikittyId());
        VradiTreeTableNode nodeFound = this.findThesaurusNode(thesaurus);
        if (nodeFound != null) {
            this.unSelectNode((NavNode)nodeFound);
        }
    }

    public void tryToUnselect(List<String> thesaurusIds) {
        WikittyProxy proxy = VradiService.getWikittyProxy();
        this.tryToUnselect(proxy.restore(Thesaurus.class, thesaurusIds));
    }

    public void tryToUnselect(Collection<Thesaurus> thesauruses) {
        if (thesauruses == null) {
            return;
        }
        ArrayList<VradiTreeTableNode> nodes = new ArrayList<VradiTreeTableNode>();
        for (Thesaurus thesaurus : thesauruses) {
            VradiTreeTableNode toSelect;
            String id;
            if (thesaurus == null || (id = thesaurus.getWikittyId()).equals(((VradiTreeTableNode)this.getRootNode()).getId()) || (toSelect = this.findThesaurusNode(thesaurus)) == null) continue;
            nodes.add(toSelect);
        }
        this.unSelectNodes(nodes);
    }

    public VradiTreeTableNode findThesaurusNode(String thesaurusId) {
        WikittyProxy proxy = VradiService.getWikittyProxy();
        return this.findThesaurusNode((Thesaurus)proxy.restore(Thesaurus.class, thesaurusId));
    }

    public VradiTreeTableNode findThesaurusNode(Thesaurus thesaurus) {
        VradiTreeTableNode parentNode = (VradiTreeTableNode)this.getRootNode();
        VradiTreeTableNode rootNode = (VradiTreeTableNode)this.getChild((NavNode)parentNode, thesaurus.getRootThesaurus());
        if (rootNode != null) {
            parentNode = rootNode;
        }
        WikittyProxy proxy = VradiService.getWikittyProxy();
        List<Thesaurus> parentList = this.getParentsPathThesaurus(proxy, thesaurus);
        for (Thesaurus parent : parentList) {
            VradiTreeTableNode nodeFound = (VradiTreeTableNode)this.getChild((NavNode)parentNode, parent.getWikittyId());
            if (nodeFound == null) continue;
            parentNode = nodeFound;
        }
        if (!parentNode.getId().equals(thesaurus.getWikittyId())) {
            return null;
        }
        return parentNode;
    }

    protected List<Thesaurus> getParentsPathThesaurus(WikittyProxy proxy, Thesaurus thesaurus) {
        Thesaurus parent;
        ArrayList<Thesaurus> parents = new ArrayList<Thesaurus>();
        if (!ThesaurusDataHelper.isFirstChild(thesaurus) && (parent = (Thesaurus)proxy.restore(Thesaurus.class, thesaurus.getParent())) != null) {
            List<Thesaurus> thesauruses = this.getParentsPathThesaurus(proxy, parent);
            parents.addAll(thesauruses);
        }
        parents.add(thesaurus);
        return parents;
    }

    protected List<String> extractIds(List<Thesaurus> beans) {
        ArrayList<String> ids = new ArrayList<String>();
        if (beans != null) {
            for (Thesaurus bean : beans) {
                ids.add(bean.getWikittyId());
            }
        }
        return ids;
    }

    public VradiDataProvider getDataProvider() {
        return (VradiDataProvider)this.dataProvider;
    }

    public NavTreeTableModel createTreeModel() {
        NavTreeTableModel model;
        if (this.rootThesaurus != null) {
            VradiTreeTableNode root = new VradiTreeTableNode(String.class, "Root node", null, null);
            VradiTreeTableNode rootThesaurusNode = new VradiTreeTableNode(RootThesaurus.class, this.rootThesaurus.getWikittyId(), null, new ThesaurusTreeTableNodeLoadors());
            root.add(rootThesaurusNode);
            model = this.createModel(root, new Object[]{new ThesaurusTreeTableModel()});
            rootThesaurusNode.populateChilds(this.getBridge(), this.getDataProvider());
            this.registerLoadedIds(root);
        } else {
            VradiTreeTableNode root = new VradiTreeTableNode(String.class, "Root node", null, new RootThesaurusTreeTableNodeLoadors());
            model = this.createModel(root, new Object[]{new ThesaurusTreeTableModel()});
            root.populateChilds(this.getBridge(), this.getDataProvider());
            this.registerLoadedIds(root);
        }
        return model;
    }

    public static RootThesaurus getRootThesaurus(VradiTreeTableNode node) {
        if (!node.getInternalClass().equals(RootThesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreRootThesaurus(node.getId());
    }

    public static Thesaurus getThesaurus(VradiTreeTableNode node) {
        if (!node.getInternalClass().equals(Thesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreThesaurus(node.getId());
    }

    protected void refresh(VradiTreeTableNode node) {
        if (node == null) {
            return;
        }
        ((NavTreeTableBridge)this.getBridge()).nodeChanged((TreeNode)((Object)node));
    }

    public VradiTreeTableNode createRootThesaurusAndSelect(String rootThesaurusIdToAdd) {
        VradiTreeTableNode newNode = this.createRootThesaurus(rootThesaurusIdToAdd);
        this.selectNode((NavNode)newNode);
        return newNode;
    }

    public VradiTreeTableNode createRootThesaurus(String rootThesaurusIdToAdd) {
        VradiTreeTableNode newNode = ((ThesaurusTreeTableNodeLoadors)ThesaurusTreeTableHelper.getChildLoador(ThesaurusTreeTableNodeLoadors.class)).createNode(rootThesaurusIdToAdd, (NavDataProvider)this.getDataProvider());
        this.insertNode(this.getRootNode(), (NavNode)newNode);
        return newNode;
    }

    public VradiTreeTableNode createThesaurusAndSelect(String parentId, String thesaurusIdToAdd) {
        VradiTreeTableNode newNode = this.createThesaurus(parentId, thesaurusIdToAdd);
        this.selectNode((NavNode)newNode);
        return newNode;
    }

    public VradiTreeTableNode createThesaurus(String parentId, String thesaurusIdToAdd) {
        VradiTreeTableNode parentNode = this.findThesaurusNode(parentId);
        VradiTreeTableNode newNode = ((ThesaurusTreeTableNodeLoadors)ThesaurusTreeTableHelper.getChildLoador(ThesaurusTreeTableNodeLoadors.class)).createNode(thesaurusIdToAdd, (NavDataProvider)this.getDataProvider());
        this.insertNode((NavNode)parentNode, (NavNode)newNode);
        return newNode;
    }

    public VradiTreeTableNode createThesaurusChildOfRootAndSelect(String rootThesaurusId, String thesaurusIdToAdd) {
        VradiTreeTableNode newNode = this.createThesaurusChildOfRoot(rootThesaurusId, thesaurusIdToAdd);
        this.selectNode((NavNode)newNode);
        return newNode;
    }

    public VradiTreeTableNode createThesaurusChildOfRoot(String rootThesaurusId, String thesaurusIdToAdd) {
        VradiTreeTableNode rootNode = (VradiTreeTableNode)this.getChild(this.getRootNode(), rootThesaurusId);
        VradiTreeTableNode newNode = ((ThesaurusTreeTableNodeLoadors)ThesaurusTreeTableHelper.getChildLoador(ThesaurusTreeTableNodeLoadors.class)).createNode(thesaurusIdToAdd, (NavDataProvider)this.getDataProvider());
        this.insertNode((NavNode)rootNode, (NavNode)newNode);
        return newNode;
    }

    public void putWikitty(WikittyServiceEvent event) {
        Map idAndExtensions = event.getIdExtensions();
        for (String wikittyId : event.getIds()) {
            Thesaurus thesaurusConcerned;
            Set wikittyExtensions = (Set)idAndExtensions.get(wikittyId);
            if (wikittyExtensions.contains("Thesaurus") && (thesaurusConcerned = ThesaurusDataHelper.restoreThesaurus(wikittyId)) != null && (this.idsLoaded.contains(thesaurusConcerned.getParent()) || this.idsLoaded.contains(thesaurusConcerned.getWikittyId()))) {
                VradiTreeTableNode existingNode = this.findThesaurusNode(wikittyId);
                if (existingNode != null) {
                    VradiTreeTableNode parent = (VradiTreeTableNode)existingNode.getParent();
                    String newParentId = thesaurusConcerned.getParent();
                    if (parent != null && !parent.getId().equals(newParentId)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Move case :  " + thesaurusConcerned.getName()));
                        }
                        VradiTreeTableNode newParentNode = this.findThesaurusNode(newParentId);
                        this.removeNode((NavNode)existingNode);
                        if (this.getChild((NavNode)newParentNode, wikittyId) == null) {
                            this.createThesaurus(newParentNode.getId(), wikittyId);
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Modification case :  " + thesaurusConcerned.getName()));
                        }
                        this.refresh(existingNode);
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creation case :  " + thesaurusConcerned.getName()));
                    }
                    if (this.findThesaurusNode(wikittyId) == null) {
                        this.createThesaurus(thesaurusConcerned.getParent(), wikittyId);
                    }
                }
            }
            if (!wikittyExtensions.contains("RootThesaurus")) continue;
            VradiTreeTableNode existingNode = this.findThesaurusNode(wikittyId);
            if (existingNode != null) {
                this.refresh(existingNode);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Refresh root thesaurus : " + wikittyId));
            }
            VradiTreeTableNode newNode = ((RootThesaurusTreeTableNodeLoadors)ThesaurusTreeTableHelper.getChildLoador(RootThesaurusTreeTableNodeLoadors.class)).createNode(wikittyId, (NavDataProvider)this.getDataProvider());
            this.insertNode(this.getRootNode(), (NavNode)newNode);
        }
    }

    public void removeWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove event : " + event));
        }
        for (String wikittyId : event.getIds()) {
            if (!this.idsLoaded.contains(wikittyId)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing node " + wikittyId + " from parent"));
            }
            VradiTreeTableNode node = this.findThesaurusNode(wikittyId);
            this.idsLoaded.remove(wikittyId);
            if (node == null) continue;
            this.removeNode((NavNode)node);
        }
    }

    public void clearWikitty(WikittyServiceEvent event) {
    }

    public void putExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service put extension event : " + event));
        }
    }

    public void removeExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receive wikitty service remove extension event : " + event));
        }
    }

    public void clearExtension(WikittyServiceEvent event) {
    }
}

