/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiTestAbstract;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.ThesaurusImpl;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.wikitty.entities.BusinessEntity;

public class ThesaurusManagerTest
extends VradiTestAbstract {
    protected ThesaurusManager thesaurusManager;

    @Before
    public void initThesaurusManager() {
        this.thesaurusManager = new ThesaurusManager(this.wikittyProxy);
    }

    @Test
    public void testIsRootThesaurusNameExists() throws VradiException {
        this.thesaurusManager.createRootThesaurus("Thesaurus");
        Assert.assertTrue((boolean)this.thesaurusManager.isRootThesaurusNameExists("Thesaurus"));
        Assert.assertFalse((boolean)this.thesaurusManager.isRootThesaurusNameExists("NoExists"));
    }

    @Test
    public void testIsThesaurusNameExistInThesaurus() throws VradiException {
        RootThesaurus rootThesaurus = this.thesaurusManager.createRootThesaurus("Thesaurus");
        ThesaurusImpl thesaurus1 = new ThesaurusImpl();
        thesaurus1.setName("AO Global");
        thesaurus1.setParent(rootThesaurus.getWikittyId());
        thesaurus1.setRootThesaurus(rootThesaurus.getWikittyId());
        ThesaurusImpl thesaurus2 = new ThesaurusImpl();
        thesaurus2.setName("Appel d'offre regionnal");
        thesaurus2.setParent(thesaurus1.getWikittyId());
        thesaurus2.setRootThesaurus(rootThesaurus.getWikittyId());
        RootThesaurus rootDescripteurs = this.thesaurusManager.createRootThesaurus("descripteur");
        ThesaurusImpl thesaurus3 = new ThesaurusImpl();
        thesaurus3.setName("AO Local");
        thesaurus3.setParent(rootDescripteurs.getWikittyId());
        thesaurus3.setRootThesaurus(rootDescripteurs.getWikittyId());
        ArrayList<ThesaurusImpl> thesauruses = new ArrayList<ThesaurusImpl>();
        thesauruses.add(thesaurus1);
        thesauruses.add(thesaurus2);
        thesauruses.add(thesaurus3);
        this.wikittyProxy.store(thesauruses);
        Assert.assertTrue((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootThesaurus, "AO Global"));
        Assert.assertTrue((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootThesaurus, "Appel d'offre regionnal"));
        Assert.assertFalse((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootDescripteurs, "AO Global"));
        Assert.assertFalse((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootDescripteurs, "Appel d'offre regionnal"));
        Assert.assertFalse((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootThesaurus, "AO Local"));
        Assert.assertTrue((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootDescripteurs, "AO Local"));
        Assert.assertFalse((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootThesaurus, "Toto"));
        Assert.assertFalse((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootDescripteurs, "Titi"));
        Assert.assertFalse((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootThesaurus, "AO Global", thesaurus1.getWikittyId()));
        Assert.assertTrue((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootThesaurus, "AO Global", "9980d1ae-18bf-4284-884b-746ca916234f"));
        Assert.assertFalse((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootThesaurus, "Appel d'offre regionnal", thesaurus2.getWikittyId()));
        Assert.assertTrue((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootThesaurus, "Appel d'offre regionnal", "930db6ef-770e-4a41-ab4c-2416122ec743"));
        Assert.assertFalse((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootDescripteurs, "AO Local", thesaurus3.getWikittyId()));
        Assert.assertTrue((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootDescripteurs, "AO Local"));
    }

    @Test
    public void testDeleteThesaurus() throws VradiException {
        RootThesaurus rootThesaurus = this.thesaurusManager.createRootThesaurus("RootThesaurus");
        ThesaurusImpl thesaurus1 = new ThesaurusImpl();
        thesaurus1.setName("Thesaurus 1");
        thesaurus1.setParent(rootThesaurus.getWikittyId());
        thesaurus1.setRootThesaurus(rootThesaurus.getWikittyId());
        ThesaurusImpl thesaurus11 = new ThesaurusImpl();
        thesaurus11.setName("Thesaurus 1.1");
        thesaurus11.setParent(thesaurus1.getWikittyId());
        thesaurus11.setRootThesaurus(rootThesaurus.getWikittyId());
        ThesaurusImpl thesaurus111 = new ThesaurusImpl();
        thesaurus111.setName("Thesaurus 1.1.1");
        thesaurus111.setParent(thesaurus11.getWikittyId());
        thesaurus111.setRootThesaurus(rootThesaurus.getWikittyId());
        ThesaurusImpl thesaurus112 = new ThesaurusImpl();
        thesaurus112.setName("Thesaurus 1.1.2");
        thesaurus112.setParent(thesaurus11.getWikittyId());
        thesaurus112.setRootThesaurus(rootThesaurus.getWikittyId());
        ArrayList<ThesaurusImpl> thesauruses = new ArrayList<ThesaurusImpl>();
        thesauruses.add(thesaurus1);
        thesauruses.add(thesaurus11);
        thesauruses.add(thesaurus111);
        thesauruses.add(thesaurus112);
        this.wikittyProxy.store(thesauruses);
        Collection deletedIds = this.thesaurusManager.deleteThesaurus(thesaurus11.getWikittyId());
        Assert.assertEquals((long)3L, (long)deletedIds.size());
        Assert.assertTrue((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootThesaurus, "Thesaurus 1"));
        Assert.assertFalse((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootThesaurus, "Thesaurus 1.1"));
        Assert.assertFalse((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootThesaurus, "Thesaurus 1.1.1"));
        Assert.assertFalse((boolean)this.thesaurusManager.isThesaurusNameExistsInRootThesaurus(rootThesaurus, "Thesaurus 1.1.2"));
    }

    @Test
    public void testProposeThesaurus() throws VradiException {
        RootThesaurus rootThesaurus = this.thesaurusManager.createRootThesaurus("Thesaurus");
        FormImpl form = new FormImpl();
        ThesaurusImpl thesaurusInfo = new ThesaurusImpl();
        thesaurusInfo.setName("Informatique");
        thesaurusInfo.addTags("linux");
        thesaurusInfo.addTags("windows");
        thesaurusInfo.addTags("internet");
        thesaurusInfo.setParent(rootThesaurus.getWikittyId());
        thesaurusInfo.setRootThesaurus(rootThesaurus.getWikittyId());
        ThesaurusImpl thesaurusSci = new ThesaurusImpl();
        thesaurusSci.setName("Science");
        thesaurusSci.setParent(thesaurusInfo.getWikittyId());
        thesaurusSci.setRootThesaurus(rootThesaurus.getWikittyId());
        ThesaurusImpl thesaurusHis = new ThesaurusImpl();
        thesaurusHis.setName("Histoire");
        thesaurusHis.addTags("revolution");
        thesaurusHis.addAttachment(form.getWikittyId());
        thesaurusHis.setParent(thesaurusSci.getWikittyId());
        thesaurusHis.setRootThesaurus(rootThesaurus.getWikittyId());
        ThesaurusImpl thesaurusSport = new ThesaurusImpl();
        thesaurusSport.setName("Sport");
        thesaurusSport.setParent(thesaurusSci.getWikittyId());
        thesaurusSport.addTags("foot");
        thesaurusSport.addTags("rugby");
        thesaurusSport.addTags("tennis");
        thesaurusSport.setRootThesaurus(rootThesaurus.getWikittyId());
        ArrayList<ThesaurusImpl> thesauruses = new ArrayList<ThesaurusImpl>();
        thesauruses.add(thesaurusInfo);
        thesauruses.add(thesaurusSci);
        thesauruses.add(thesaurusHis);
        thesauruses.add(thesaurusSport);
        this.wikittyProxy.store(thesauruses);
        form.setDescription("Rien");
        form = (Form)this.wikittyProxy.store((BusinessEntity)form);
        String formId = form.getWikittyId();
        List propositions = this.thesaurusManager.proposeThesaurus(formId);
        Assert.assertEquals((long)0L, (long)propositions.size());
        form.setDescription("developpent internet");
        form = (Form)this.wikittyProxy.store((BusinessEntity)form);
        propositions = this.thesaurusManager.proposeThesaurus(formId);
        Assert.assertEquals((long)1L, (long)propositions.size());
        form.setDescription("Et c'est le foot !!!!!!!!!");
        form = (Form)this.wikittyProxy.store((BusinessEntity)form);
        propositions = this.thesaurusManager.proposeThesaurus(formId);
        Assert.assertEquals((long)1L, (long)propositions.size());
        form.setDescription("Mais le foot c'est aussi sur internet");
        form = (Form)this.wikittyProxy.store((BusinessEntity)form);
        propositions = this.thesaurusManager.proposeThesaurus(formId);
        Assert.assertEquals((long)2L, (long)propositions.size());
        form.setDescription("C'est la revolution dans le foot");
        form = (Form)this.wikittyProxy.store((BusinessEntity)form);
        propositions = this.thesaurusManager.proposeThesaurus(formId);
        Assert.assertEquals((long)1L, (long)propositions.size());
    }
}

