/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.VradiTestAbstract;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.services.managers.MailingManager;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.wikitty.entities.BusinessEntity;

public class MailingManagerTest
extends VradiTestAbstract {
    protected MailingManager mailingManager;

    @Before
    public void initMailingManager() {
        this.mailingManager = new MailingManager(this.config, this.wikittyProxy);
    }

    @Test
    public void testGetHeaderInContent1() {
        String testString = "Final-Recipient: rfc822; toto@codelutin.com\nOriginal-Recipient: rfc822;toto@codelutin.com\nAction: failed\nStatus: 5.1.1\nRemote-MTA: dns; 87.98.187.174\nDiagnostic-Code: smtp; 550 5.1.1 <toto@codelutin.com>: Recipient address\n   rejected: User unknown in local recipient table\n";
        String headerValue = this.mailingManager.getHeaderValueInContent("Diagnostic-Code", testString);
        Assert.assertEquals((Object)"smtp; 550 5.1.1 <toto@codelutin.com>: Recipient address", (Object)headerValue);
    }

    @Test
    public void testGetHeaderInContent2() {
        String testString = "Reporting-UA: Mozilla/5.0 (X11; U; Linux x86_64; en-US; rv:1.9.2.5pre)\nGecko/20100503 Icedove/2.0.0.12\nFinal-Recipient: rfc822;chatellier@codelutin.com\nOriginal-Message-ID: <1833582695.1.1272991628810.JavaMail.chatellier@genux>\nDisposition: manual-action/MDN-sent-manually; displayed";
        String headerValue = this.mailingManager.getHeaderValueInContent("Original-Message-ID", testString);
        Assert.assertEquals((Object)"<1833582695.1.1272991628810.JavaMail.chatellier@genux>", (Object)headerValue);
    }

    @Test
    public void testGetHeaderInContent3() {
        String testString = "From: vradi\nTo: toto@codelutin.com\nMessage-ID: <804992706.5.1272991629788.JavaMail.chatellier@genux>";
        String headerValue = this.mailingManager.getHeaderValueInContent("Message-ID", testString);
        Assert.assertEquals((Object)"<804992706.5.1272991629788.JavaMail.chatellier@genux>", (Object)headerValue);
    }

    @Test
    public void testGetGeneratePDFFile() {
        FormImpl myForm = new FormImpl();
        myForm = (Form)this.wikittyProxy.store((BusinessEntity)myForm);
        File formFile = this.mailingManager.getGeneratedPdfFile((Form)myForm);
        System.out.println(formFile);
        Assert.assertTrue((boolean)formFile.getName().endsWith("-1.0.pdf"));
        myForm.setObjet("toto");
        myForm = (Form)this.wikittyProxy.store((BusinessEntity)myForm);
        formFile = this.mailingManager.getGeneratedPdfFile((Form)myForm);
        Assert.assertTrue((boolean)formFile.getName().endsWith("-2.0.pdf"));
    }
}

