/*
 * #%L
 * Vradi :: Services
 * 
 * $Id: ServiceMigration.java 1724 2010-10-28 13:19:14Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.3.2/vradi-services/src/main/java/com/jurismarches/vradi/services/ServiceMigration.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package com.jurismarches.vradi.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import com.jurismarches.vradi.entities.GroupForms;
import com.jurismarches.vradi.entities.GroupFormsImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyExtensionMigration;
import org.nuiton.wikitty.WikittyExtensionMigrationRename;
import org.nuiton.wikitty.WikittyImpl;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.WikittyTreeNode;
import org.nuiton.wikitty.WikittyTreeNodeImpl;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

import com.jurismarches.vradi.entities.RootThesaurusImpl;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;

/**
 * Configure wikitty migration.
 * 
 * @author chatellier
 * @version $Revision: 1724 $
 * 
 * Last update : $Date: 2010-10-28 15:19:14 +0200 (jeu., 28 oct. 2010) $
 * By : $Author: sletellier $
 */
public class ServiceMigration {

    /** Log. */
    private static final Log log = LogFactory.getLog(ServiceMigration.class);

    /**
     * Install all migration.
     */
    public static void configureMigration() {
        configureMigration010();
        configureMigration021();
    }

    /**
     * Configure migration from 0.0.5 to 0.1.0.
     */
    protected static void configureMigration010() {
        
        // extension VradiUser renamed to WikittyUser
        WikittyExtensionMigration.migrationRegistry.put(VradiUser.EXT_VRADIUSER, new MigrationVradiUser());
        WikittyExtensionMigration.migrationRegistry.put(User.EXT_USER, new MigrationUser());
        WikittyExtensionMigration.migrationRegistry.put(Sending.EXT_SENDING, new MigrationSending());

    }

    /**
     * Configure migration from 0.1.0 to 0.2.1.
     */
    protected static void configureMigration021() {
        WikittyExtensionMigration.migrationRegistry.put(Sending.EXT_SENDING, new MigrationSendingV8());
    }

    static class MigrationVradiUser extends WikittyExtensionMigrationRename {

        /**
         * Some field names has also changed.
         * 
         * Migration 1.0 > 2.0:
         *   "VradiUser.name" to VradiUser.FQ_FIELD_LOGIN
         *   "VradiUser.password" to VradiUser.FQ_FIELD_PASSWORD
         */
        @Override
        public Wikitty migrate(WikittyService service, WikittyTransaction transaction, Wikitty wikitty, WikittyExtension oldExt, WikittyExtension newExt) {

            String wikittyId = wikitty.getId();
            String wikittyVersion = wikitty.getVersion();

            Wikitty result = new WikittyImpl(wikittyId);
            result.setVersion(wikittyVersion);

            // Add all extension and replace old by the new
            for (WikittyExtension extension : wikitty.getExtensions()) {
                // add one by one to manage require

                // during loop add new when old one is found
                if (extension.equals(oldExt)) {
                    addExtension(service, transaction, result, newExt);
                }
                else {
                    addExtension(service, transaction, result, extension);
                }
            }

            // Pas sur de la method de migration
            // les champs VradiUser.name, VradiUser.password
            // existait en 1.0, pas après
            if (oldExt.getVersion().equals("1.0")) {
                // Copy other values
                Set<String> fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    if(fieldName.equals("VradiUser.name")) {
                        Object value = wikitty.getFqField(fieldName);
                        result.setFqField(VradiUser.FQ_FIELD_WIKITTYUSER_LOGIN, value);
                    }
                    else if(fieldName.equals("VradiUser.password")) {
                        Object value = wikitty.getFqField(fieldName);
                        result.setFqField(VradiUser.FQ_FIELD_WIKITTYUSER_PASSWORD, value);
                    }
                    else {
                        Object value = wikitty.getFqField(fieldName);
                        result.setFqField(fieldName, value);
                    }
                }
            }
            else {
                // Copy other values
                Set<String> fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    Object value = wikitty.getFqField(fieldName);
                    result.setFqField(fieldName, value);
                }
            }
            return result;
        }
    }
    
    static class MigrationUser extends WikittyExtensionMigrationRename {

        /**
         * Some field names has also changed.
         * 
         * Migration 6.0 > 7.0:
         *   "User.inscriptionDate" to {@link User#FQ_FIELD_USER_BEGINSEARCHDATE}
         */
        @Override
        public Wikitty migrate(WikittyService service, WikittyTransaction transaction, Wikitty wikitty, WikittyExtension oldExt, WikittyExtension newExt) {

            String wikittyId = wikitty.getId();
            String wikittyVersion = wikitty.getVersion();

            Wikitty result = new WikittyImpl(wikittyId);
            result.setVersion(wikittyVersion);

            // Add all extension and replace old by the new
            for (WikittyExtension extension : wikitty.getExtensions()) {
                // add one by one to manage require

                // during loop add new when old one is found
                if (extension.equals(oldExt)) {
                    addExtension(service, transaction, result, newExt);
                } else {
                    addExtension(service, transaction, result, extension);
                }
            }

            // Pas sur de la method de migration
            // les champs User.inscriptionDate
            // existait en 6.0, pas après
            if (oldExt.getVersion().equals("6.0")) {
                // Copy other values
                Set<String> fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    if(fieldName.equals("User.inscriptionDate")) {
                        Object value = wikitty.getFqField(fieldName);
                        result.setFqField(User.FQ_FIELD_USER_BEGINSEARCHDATE, value);
                    } else {
                        Object value = wikitty.getFqField(fieldName);
                        result.setFqField(fieldName, value);
                    }
                }
            } else {
                // Copy other values
                Set<String> fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    Object value = wikitty.getFqField(fieldName);
                    result.setFqField(fieldName, value);
                }
            }
            return result;
        }
    }
    
    static class MigrationSending extends WikittyExtensionMigrationRename {

        /**
         * Some field names has also changed.
         * 
         * Migration 3.0 > 4.0:
         *   "Sending.queryMaker" to Sending.FQ_FIELD_SENDING_USER
         */
        @Override
        public Wikitty migrate(WikittyService service, WikittyTransaction transaction, Wikitty wikitty, WikittyExtension oldExt, WikittyExtension newExt) {

            String wikittyId = wikitty.getId();
            String wikittyVersion = wikitty.getVersion();

            Wikitty result = new WikittyImpl(wikittyId);
            result.setVersion(wikittyVersion);

            // Add all extension and replace old by the new
            for (WikittyExtension extension : wikitty.getExtensions()) {
                // add one by one to manage require

                // during loop add new when old one is found
                if (extension.equals(oldExt)) {
                    addExtension(service, transaction, result, newExt);
                }
                else {
                    addExtension(service, transaction, result, extension);
                }
            }

            // Pas sur de la method de migration
            // les champs Sending.queryMaker
            // existait en 3.0, pas après
            if (oldExt.getVersion().equals("3.0")) {
                // Copy other values
                Set<String> fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    if(fieldName.equals("Sending.queryMaker")) {
                        Object value = wikitty.getFqField(fieldName);
                        result.setFqField(Sending.FQ_FIELD_SENDING_USER, value);
                    }
                    else {
                        Object value = wikitty.getFqField(fieldName);
                        result.setFqField(fieldName, value);
                    }
                }
            }
            else {
                // Copy other values
                Set<String> fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    Object value = wikitty.getFqField(fieldName);
                    result.setFqField(fieldName, value);
                }
            }
            return result;
        }
    }

    static class MigrationSendingV8 extends WikittyExtensionMigrationRename {

        /**
         * Some field names has also changed.
         *
         * Migration 7.0 > 8.0:
         *   "Sending.queryMaker" to Sending.FQ_FIELD_SENDING_USER
         */
        @Override
        public Wikitty migrate(WikittyService service, WikittyTransaction transaction, Wikitty wikitty, WikittyExtension oldExt, WikittyExtension newExt) {

            if (log.isDebugEnabled()) {
                log.debug("migrate, old " + oldExt + " new " + newExt);
            }

            String wikittyId = wikitty.getId();
            String wikittyVersion = wikitty.getVersion();

            Wikitty result = new WikittyImpl(wikittyId);
            result.setVersion(wikittyVersion);

            // Add all extension and replace old by the new
            for (WikittyExtension extension : wikitty.getExtensions()) {
                // add one by one to manage require

                // during loop add new when old one is found
                if (extension.equals(oldExt)) {
                    addExtension(service, transaction, result, newExt);
                }
                else {
                    addExtension(service, transaction, result, extension);
                }
            }

            // Pas sur de la method de migration
            // les champs Sending.queryMaker
            // existait en 3.0, pas après
            if (oldExt.getVersion().equals("4.0") ||
                    oldExt.getVersion().equals("5.0") ||
                    oldExt.getVersion().equals("6.0") ||
                    oldExt.getVersion().equals("7.0")) {

                // Migrate
                Set<String> fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    if (!fieldName.equals("Sending.form") &&
                            !fieldName.equals("Sending.deletedForms") &&
                            !fieldName.equals("Sending.addedForms") &&
                            !fieldName.equals("Sending.groupsConcerned")){
                        
                        Object value = wikitty.getFqField(fieldName);
                        result.setFqField(fieldName, value);
                    }
                }
            }
            else {
                // Copy other values
                Set<String> fqFieldNames = wikitty.fieldNames();
                for (String fieldName : fqFieldNames) {
                    Object value = wikitty.getFqField(fieldName);
                    result.setFqField(fieldName, value);
                }
            }
            return result;
        }

        protected void addExtentions(WikittyService service, WikittyTransaction transaction, Wikitty groupFormsWikitty) {

            for (WikittyExtension extension : groupFormsWikitty.getExtensions()) {
                addExtension(service, transaction, groupFormsWikitty, extension);
            }
        }
    }

    /**
     * Do migration that wikitty extension migration can't handle.
     * 
     * They are done only at version change time, because, can take
     * some times to perform...
     * 
     * @param lastVersionAsString last launch version
     * @param currentVersionAsString current application version
     * @param localWikittyProxy local wikitty proxy
     */
    public static void versionChangeMigration(String lastVersionAsString,
            String currentVersionAsString, WikittyProxy localWikittyProxy) {

        if (log.isDebugEnabled()) {
            log.debug("versionChangeMigration, old " + lastVersionAsString + " current " + currentVersionAsString);
        }

        // Remove snapshot if exist
        currentVersionAsString = VersionUtil.removeSnapshot(currentVersionAsString);
        lastVersionAsString = VersionUtil.removeSnapshot(lastVersionAsString);

        // Create comparable version object
        Version currentVersion = VersionUtil.valueOf(currentVersionAsString);
        Version lastVersion = VersionUtil.valueOf(lastVersionAsString);

        // last version < 0.1.0 <= Current version : add extension RootThesaurus on "Thesaurus" node
        Version thesaurusMigrationVersion = VersionUtil.valueOf("0.1.0");
        if (isConcernedByMigration(lastVersion, currentVersion, thesaurusMigrationVersion)) {

            // modification du noeud root
            if (log.isInfoEnabled()) {
                log.info("Migration root Thesaurus node : add RootThesaurus extension");
            }

            Search search = Search.query().eq(Element.ELT_EXTENSION, WikittyTreeNode.EXT_WIKITTYTREENODE)
                .eq(WikittyTreeNode.FQ_FIELD_WIKITTYTREENODE_NAME, "Thesaurus");
            Criteria criteria = search.criteria();
            WikittyTreeNodeImpl rootThesaurus = localWikittyProxy.findByCriteria(WikittyTreeNodeImpl.class, criteria);
            if (rootThesaurus != null) {
                if (!rootThesaurus.getWikitty().hasExtension(RootThesaurusImpl.EXT_ROOTTHESAURUS)) {
                    rootThesaurus.getWikitty().addExtension(RootThesaurusImpl.extensionRootThesaurus);
                    // WARNING, fake modification to force wikitty version increments
                    rootThesaurus.setName("Thesaurus");
                    localWikittyProxy.store(rootThesaurus);
                }

                // referencement du noeud root pour tous les noeud existants
                if (log.isInfoEnabled()) {
                    log.info("Set rootThesaurus id to all existing thesaurus");
                }
                search = Search.query().eq(Element.ELT_EXTENSION, Thesaurus.EXT_THESAURUS);
                criteria = search.criteria();
                List<Thesaurus> thesauruses = localWikittyProxy.findAllByCriteria(Thesaurus.class, criteria).getAll();
                for (Thesaurus thesaurus : thesauruses) {
                    thesaurus.setRootThesaurus(rootThesaurus.getWikittyId());
                }
                localWikittyProxy.store(thesauruses);
            }

            // migration des status
            Criteria criteriaStatus = Search.query().eq(Element.ELT_EXTENSION, Status.EXT_STATUS).criteria();
            List<Status> statuses = localWikittyProxy.findAllByCriteria(Status.class, criteriaStatus).getAll();
            List<String> statusesIds = new ArrayList<String>();
            for (Status status : statuses) {
                statusesIds.add(status.getWikittyId());
                if (log.isInfoEnabled()) {
                    log.info("Deleting status " + status.getName());
                }
            }
            localWikittyProxy.delete(statusesIds);
            // les status sont normalement créer tout seul
        }

        // last version < 0.3 <= Current version : migre sending
        Version sendingMigrationVersion = VersionUtil.valueOf("0.3");
        if (isConcernedByMigration(lastVersion, currentVersion, sendingMigrationVersion)) {

            // modification du noeud root
            if (log.isInfoEnabled()) {
                log.info("Sendings migration");
            }

            Search search = Search.query().eq(Element.ELT_EXTENSION, Sending.EXT_SENDING);
            Criteria criteria = search.criteria();
            List<Sending> sendings = localWikittyProxy.findAllByCriteria(Sending.class, criteria).getAll();
            for (Sending sending : sendings) {
                if (sending != null) {
                    
                    Wikitty wikitty = sending.getWikitty();

                    // Migrate
                    Set<String> fqFieldNames = wikitty.fieldNames();
                    for (String fieldName : fqFieldNames) {
                        if(fieldName.equals("Sending.form")) {
                            Object value = wikitty.getFqField(fieldName);

                            GroupFormsImpl groupFormCreated = new GroupFormsImpl();
                            Wikitty groupFormsWikitty = groupFormCreated.getWikitty();
                            groupFormsWikitty.setFqField(GroupForms.FQ_FIELD_GROUPFORMS_FORM, value);

                            localWikittyProxy.store(groupFormCreated);

                            sending.addGroupForms(groupFormCreated.getWikittyId());

                        } else if (fieldName.equals("Sending.deletedForms")) {
                            Object value = wikitty.getFqField(fieldName);

                            GroupFormsImpl groupFormCreated = new GroupFormsImpl();
                            Wikitty groupFormsWikitty = groupFormCreated.getWikitty();
                            groupFormsWikitty.setFqField(GroupForms.FQ_FIELD_GROUPFORMS_FORM, value);

                            localWikittyProxy.store(groupFormCreated);

                            sending.addDeletedGroupForms(groupFormCreated.getWikittyId());

                        }
                    }
                    localWikittyProxy.store(sending);
                }
            }
        }
    }

    /**
     * Return true if :
     *
     * lastVersion < migrationVersion <= currentVersion
     *
     * @param lastVersion last version installed of vradi
     * @param currentVersion curent version of vradi
     * @param migrationVersion concerned version to apply migration
     * @return if is concerned
     */
    protected static boolean isConcernedByMigration(Version lastVersion,
                                                    Version currentVersion,
                                                    Version migrationVersion) {

        if (lastVersion.equals(currentVersion)) {
            // If version not chaged, do nothing
            return false;
        }

        return lastVersion.before(migrationVersion) &&
                (currentVersion.equals(migrationVersion)
                        || currentVersion.after(migrationVersion));
    }
}
