/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecureRandom;
import java.util.Collection;
import org.jgroups.Address;
import org.jgroups.blocks.LazyRemovalCache;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class UUID
implements Address,
Streamable,
Comparable<Address> {
    private long mostSigBits;
    private long leastSigBits;
    private byte[] additional_data;
    private static volatile SecureRandom numberGenerator;
    private static LazyRemovalCache<Address, String> cache;
    private static final long serialVersionUID = 3972962439975931228L;
    private static boolean print_uuids;
    private static final int SIZE = 17;
    private static final LazyRemovalCache.Printable<UUID, String> print_function;

    public UUID() {
    }

    public UUID(long mostSigBits, long leastSigBits) {
        this.mostSigBits = mostSigBits;
        this.leastSigBits = leastSigBits;
    }

    private UUID(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        if (data.length != 16) {
            throw new RuntimeException("UUID needs a 16-byte array");
        }
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        this.mostSigBits = msb;
        this.leastSigBits = lsb;
    }

    public static void add(UUID uuid, String logical_name) {
        cache.add(uuid, logical_name);
    }

    public static String get(Address logical_addr) {
        return cache.get(logical_addr);
    }

    public static void remove(UUID uuid) {
        cache.remove(uuid);
    }

    public static void removeAll(Collection<Address> mbrs) {
        cache.removeAll(mbrs);
    }

    public static void retainAll(Collection<Address> logical_addrs) {
        cache.retainAll(logical_addrs);
    }

    public static String printCache() {
        return cache.printCache(print_function);
    }

    public final byte[] getAdditionalData() {
        return this.additional_data;
    }

    public final void setAdditionalData(byte[] additional_data) {
        this.additional_data = additional_data;
    }

    public static UUID randomUUID() {
        SecureRandom ng = numberGenerator;
        if (ng == null) {
            numberGenerator = ng = new SecureRandom();
        }
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        return new UUID(randomBytes);
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public String toString() {
        if (print_uuids) {
            return this.toStringLong();
        }
        String val = cache.get(this);
        return val != null ? val : this.toStringLong();
    }

    public String toStringLong() {
        return UUID.digits(this.mostSigBits >> 32, 8) + "-" + UUID.digits(this.mostSigBits >> 16, 4) + "-" + UUID.digits(this.mostSigBits, 4) + "-" + UUID.digits(this.leastSigBits >> 48, 4) + "-" + UUID.digits(this.leastSigBits, 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public int hashCode() {
        return (int)(this.mostSigBits >> 32 ^ this.mostSigBits ^ this.leastSigBits >> 32 ^ this.leastSigBits);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UUID)) {
            return false;
        }
        UUID id = (UUID)obj;
        return this == id || this.mostSigBits == id.mostSigBits && this.leastSigBits == id.leastSigBits;
    }

    @Override
    public int compareTo(Address other) {
        UUID val = (UUID)other;
        if (this == val) {
            return 0;
        }
        return this.mostSigBits < val.mostSigBits ? -1 : (this.mostSigBits > val.mostSigBits ? 1 : (this.leastSigBits < val.leastSigBits ? -1 : (this.leastSigBits > val.leastSigBits ? 1 : 0)));
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        out.writeLong(this.leastSigBits);
        out.writeLong(this.mostSigBits);
        if (this.additional_data != null) {
            out.writeBoolean(true);
            out.writeShort(this.additional_data.length);
            out.write(this.additional_data, 0, this.additional_data.length);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        this.leastSigBits = in.readLong();
        this.mostSigBits = in.readLong();
        if (!in.readBoolean()) {
            return;
        }
        int len = in.readUnsignedShort();
        if (len > 0) {
            this.additional_data = new byte[len];
            in.readFully(this.additional_data, 0, this.additional_data.length);
        }
    }

    @Override
    public boolean isMulticastAddress() {
        return false;
    }

    @Override
    public int size() {
        int retval = 17;
        if (this.additional_data != null) {
            retval += this.additional_data.length + 2;
        }
        return retval;
    }

    public Object clone() throws CloneNotSupportedException {
        UUID ret = new UUID(this.leastSigBits, this.mostSigBits);
        if (this.additional_data != null) {
            ret.additional_data = new byte[this.additional_data.length];
            System.arraycopy(this.additional_data, 0, ret.additional_data, 0, this.additional_data.length);
        }
        return ret;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.leastSigBits);
        out.writeLong(this.mostSigBits);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.leastSigBits = in.readLong();
        this.mostSigBits = in.readLong();
    }

    static {
        String tmp;
        numberGenerator = null;
        print_uuids = false;
        print_function = new LazyRemovalCache.Printable<UUID, String>(){

            @Override
            public String print(UUID key, String val) {
                return val + ": " + key.toStringLong() + "\n";
            }
        };
        int max_elements = 500;
        long max_age = 5000L;
        try {
            tmp = Util.getProperty(new String[]{"jgroups.uuid_cache.max_elements"}, null, null, false, "500");
            if (tmp != null) {
                max_elements = Integer.valueOf(tmp);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            tmp = Util.getProperty(new String[]{"jgroups.uuid_cache.max_age"}, null, null, false, "5000");
            if (tmp != null) {
                max_age = Long.valueOf(tmp);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        cache = new LazyRemovalCache(max_elements, max_age);
        try {
            tmp = Util.getProperty(new String[]{"jgroups.print_uuids"}, null, null, false, "false");
            print_uuids = Boolean.valueOf(tmp);
        }
        catch (SecurityException ex) {
            // empty catch block
        }
    }
}

