/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.variables;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class Variable {
    public abstract byte[] toBinary();

    public abstract byte[] toBinary(String var1);

    public abstract String toString();

    public abstract String toString(String var1);

    public abstract List toList();

    public abstract boolean isEmpty();

    public abstract Object getWrappedObject();

    public boolean toBoolean() {
        Object wrappedObject = this.getWrappedObject();
        if (wrappedObject == null) {
            return false;
        }
        if (wrappedObject instanceof Boolean) {
            return (Boolean)wrappedObject;
        }
        String strValue = this.toString().trim();
        return "true".equalsIgnoreCase(strValue) || "yes".equalsIgnoreCase(strValue) || "1".equalsIgnoreCase(strValue);
    }

    public int toInt() {
        Object wrappedObject = this.getWrappedObject();
        if (wrappedObject == null) {
            return 0;
        }
        if (wrappedObject instanceof Number) {
            return ((Number)wrappedObject).intValue();
        }
        if (wrappedObject instanceof Boolean) {
            return (Boolean)wrappedObject != false ? 1 : 0;
        }
        return Integer.parseInt(this.toString().trim());
    }

    public long toLong() {
        Object wrappedObject = this.getWrappedObject();
        if (wrappedObject == null) {
            return 0L;
        }
        if (wrappedObject instanceof Number) {
            return ((Number)wrappedObject).longValue();
        }
        if (wrappedObject instanceof Boolean) {
            return (Boolean)wrappedObject != false ? 1L : 0L;
        }
        return Long.parseLong(this.toString().trim());
    }

    public double toDouble() {
        Object wrappedObject = this.getWrappedObject();
        if (wrappedObject == null) {
            return 0.0;
        }
        if (wrappedObject instanceof Number) {
            return ((Number)wrappedObject).doubleValue();
        }
        if (wrappedObject instanceof Boolean) {
            return (Boolean)wrappedObject != false ? 1.0 : 0.0;
        }
        return Double.parseDouble(this.toString().trim());
    }

    public Object[] toArray() {
        Object wrappedObject = this.getWrappedObject();
        if (wrappedObject == null) {
            return new Object[0];
        }
        if (wrappedObject instanceof Object[]) {
            return (Object[])wrappedObject;
        }
        if (wrappedObject instanceof Collection) {
            Collection collection = (Collection)wrappedObject;
            Object[] result = new Object[collection.size()];
            int index = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                result[index] = iterator.next();
                ++index;
            }
            return result;
        }
        return new Object[]{wrappedObject};
    }
}

