/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.RecordComponent;
import java.util.Collection;
import java.util.Map;
import org.apache.parquet.io.api.Binary;
import org.locationtech.jts.geom.Geometry;

public class JavaType {
    private final String typeName;
    private final Class<?> type;
    private final Annotation[] declaredAnnotations;

    public JavaType(RecordComponent recordComponent) {
        this(recordComponent.getType(), recordComponent.getDeclaredAnnotations());
    }

    public JavaType(Class<?> type) {
        this(type, null);
    }

    public JavaType(Class<?> type, Annotation[] declaredAnnotations) {
        this.type = type;
        this.typeName = type.getName();
        this.declaredAnnotations = declaredAnnotations;
    }

    public Class<?> getJavaType() {
        return this.type;
    }

    public boolean isJavaPrimitive() {
        return this.type.isPrimitive();
    }

    public boolean isString() {
        return this.typeName.equals("java.lang.String");
    }

    public boolean isBinary() {
        return Binary.class.isAssignableFrom(this.type);
    }

    public boolean isInteger() {
        return this.typeName.equals("int") || this.typeName.equals("java.lang.Integer");
    }

    public boolean isLong() {
        return this.typeName.equals("long") || this.typeName.equals("java.lang.Long");
    }

    public boolean isShort() {
        return this.typeName.equals("short") || this.typeName.equals("java.lang.Short");
    }

    public boolean isByte() {
        return this.typeName.equals("byte") || this.typeName.equals("java.lang.Byte");
    }

    public boolean isDouble() {
        return this.typeName.equals("double") || this.typeName.equals("java.lang.Double");
    }

    public boolean isFloat() {
        return this.typeName.equals("float") || this.typeName.equals("java.lang.Float");
    }

    public boolean isBoolean() {
        return this.typeName.equals("boolean") || this.typeName.equals("java.lang.Boolean");
    }

    public boolean isUuid() {
        return this.typeName.equals("java.util.UUID");
    }

    public boolean isBigDecimal() {
        return this.typeName.equals("java.math.BigDecimal");
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isEnum() {
        return this.type.isEnum();
    }

    public boolean isLocalDate() {
        return this.typeName.equals("java.time.LocalDate");
    }

    public boolean isLocalTime() {
        return this.typeName.equals("java.time.LocalTime");
    }

    public boolean isLocalDateTime() {
        return this.typeName.equals("java.time.LocalDateTime");
    }

    public boolean isInstant() {
        return this.typeName.equals("java.time.Instant");
    }

    public boolean isGeometry() {
        return this.typeName.equals("org.locationtech.jts.geom.Geometry") || Geometry.class.isAssignableFrom(this.type);
    }

    public boolean isVariant() {
        return this.typeName.equals("org.apache.parquet.variant.Variant");
    }

    public boolean isRecord() {
        return this.type.isRecord();
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.type);
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.type);
    }

    public <T extends Annotation> boolean isAnnotatedWith(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (this.declaredAnnotations == null) {
            return null;
        }
        for (Annotation annotation : this.declaredAnnotations) {
            if (!annotation.annotationType().equals(annotationClass)) continue;
            return (T)annotation;
        }
        return null;
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.declaredAnnotations;
    }
}

