/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.jayway.maven.plugins.android.ExecutionException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CommandExecutor {
    public void setLogger(Log var1);

    public void executeCommand(String var1, List<String> var2) throws ExecutionException;

    public void executeCommand(String var1, List<String> var2, boolean var3) throws ExecutionException;

    public void executeCommand(String var1, List<String> var2, File var3, boolean var4) throws ExecutionException;

    public int getResult();

    public long getPid();

    public String getStandardOut();

    public String getStandardError();

    public static class Factory {
        private Factory() {
        }

        public static CommandExecutor createDefaultCommmandExecutor() {
            return new CommandExecutor(){
                private Log logger;
                private StreamConsumer stdOut;
                private ErrorStreamConsumer stdErr;
                private int result;
                long pid;
                private Commandline commandline;

                @Override
                public void setLogger(Log logger) {
                    this.logger = logger;
                }

                @Override
                public void executeCommand(String executable, List<String> commands) throws ExecutionException {
                    this.executeCommand(executable, commands, null, true);
                }

                @Override
                public void executeCommand(String executable, List<String> commands, boolean failsOnErrorOutput) throws ExecutionException {
                    this.executeCommand(executable, commands, null, failsOnErrorOutput);
                }

                @Override
                public void executeCommand(String executable, List<String> commands, File workingDirectory, boolean failsOnErrorOutput) throws ExecutionException {
                    if (commands == null) {
                        commands = new ArrayList<String>();
                    }
                    this.stdOut = new StreamConsumerImpl();
                    this.stdErr = new ErrorStreamConsumer();
                    this.commandline = new Commandline();
                    this.commandline.setExecutable(executable);
                    this.commandline.addArguments(commands.toArray(new String[commands.size()]));
                    if (workingDirectory != null && workingDirectory.exists()) {
                        this.commandline.setWorkingDirectory(workingDirectory.getAbsolutePath());
                    }
                    try {
                        this.result = CommandLineUtils.executeCommandLine((Commandline)this.commandline, (StreamConsumer)this.stdOut, (StreamConsumer)this.stdErr);
                        if (this.logger != null) {
                            this.logger.debug((CharSequence)("ANDROID-040-000: Executed command: Commandline = " + this.commandline + ", Result = " + this.result));
                        } else {
                            System.out.println("ANDROID-040-000: Executed command: Commandline = " + this.commandline + ", Result = " + this.result);
                        }
                        if (failsOnErrorOutput && this.stdErr.hasError() || this.result != 0) {
                            throw new ExecutionException("ANDROID-040-001: Could not execute: Command = " + this.commandline.toString() + ", Result = " + this.result);
                        }
                    }
                    catch (CommandLineException e) {
                        throw new ExecutionException("ANDROID-040-002: Could not execute: Command = " + this.commandline.toString() + ", Error message = " + e.getMessage());
                    }
                    this.setPid(this.commandline.getPid());
                }

                @Override
                public int getResult() {
                    return this.result;
                }

                @Override
                public String getStandardOut() {
                    return this.stdOut.toString();
                }

                @Override
                public String getStandardError() {
                    return this.stdErr.toString();
                }

                public void setPid(long pid) {
                    this.pid = pid;
                }

                @Override
                public long getPid() {
                    return this.pid;
                }

                class StreamConsumerImpl
                implements StreamConsumer {
                    private DefaultConsumer consumer;
                    private StringBuffer sb = new StringBuffer();

                    public StreamConsumerImpl() {
                        this.consumer = new DefaultConsumer();
                    }

                    public void consumeLine(String line) {
                        this.sb.append(line);
                        if (logger != null) {
                            this.consumer.consumeLine(line);
                        }
                    }

                    public String toString() {
                        return this.sb.toString();
                    }
                }

                class ErrorStreamConsumer
                implements StreamConsumer {
                    private boolean error;
                    private StringBuffer sbe = new StringBuffer();

                    public ErrorStreamConsumer() {
                        if (logger == null) {
                            System.out.println("ANDROID-040-003: Error Log not set: Will not output error logs");
                        }
                        this.error = false;
                    }

                    public void consumeLine(String line) {
                        this.sbe.append(line);
                        if (logger != null) {
                            logger.error((CharSequence)line);
                        }
                        this.error = true;
                    }

                    public boolean hasError() {
                        return this.error;
                    }

                    public String toString() {
                        return this.sbe.toString();
                    }
                }
            };
        }
    }
}

