/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.standalonemojos;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import com.jayway.maven.plugins.android.ExecutionException;
import com.jayway.maven.plugins.android.config.ConfigHandler;
import com.jayway.maven.plugins.android.config.ConfigPojo;
import com.jayway.maven.plugins.android.config.PullParameter;
import com.jayway.maven.plugins.android.configuration.Lint;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class LintMojo
extends AbstractAndroidMojo {
    @ConfigPojo
    private Lint lint;
    private Boolean lintFailOnError;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedFailOnError;
    private Boolean lintSkip;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedSkip;
    private Boolean lintIgnoreWarnings;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedIgnoreWarnings;
    private Boolean lintWarnAll;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedWarnAll;
    private Boolean lintWarningsAsErrors;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedWarningsAsErrors;
    private String lintConfig;
    @PullParameter(defaultValue={"null"})
    private String parsedConfig;
    private Boolean lintFullPath;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedFullPath;
    private Boolean lintShowAll;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedShowAll;
    private Boolean lintDisableSourceLines;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedDisableSourceLines;
    private String lintUrl;
    @PullParameter(defaultValue={"none"})
    private String parsedUrl;
    private Boolean lintEnableHtml;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedEnableHtml;
    private String lintHtmlOutputPath;
    @PullParameter(defaultValueGetterMethod="getHtmlOutputPath")
    private String parsedHtmlOutputPath;
    private Boolean lintEnableSimpleHtml;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedEnableSimpleHtml;
    private String lintSimpleHtmlOutputPath;
    @PullParameter(defaultValueGetterMethod="getSimpleHtmlOutputPath")
    private String parsedSimpleHtmlOutputPath;
    private Boolean lintEnableXml;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedEnableXml;
    private String lintXmlOutputPath;
    @PullParameter(defaultValueGetterMethod="getXmlOutputPath")
    private String parsedXmlOutputPath;
    private Boolean lintEnableSource;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedEnableSources;
    private String lintSources;
    @PullParameter(defaultValueGetterMethod="getSources")
    private String parsedSources;
    private Boolean lintEnableClasspath;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedEnableClasspath;
    private String lintClasspath;
    @PullParameter(defaultValueGetterMethod="getClasspath")
    private String parsedClasspath;
    private Boolean lintEnableLibraries;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedEnableLibraries;
    private String lintLibraries;
    @PullParameter(defaultValueGetterMethod="getLibraries")
    private String parsedLibraries;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ConfigHandler configHandler = new ConfigHandler((Object)this, this.session, this.execution);
        configHandler.parseConfiguration();
        this.getLog().debug((CharSequence)"Parsed values for Android Lint invocation: ");
        this.getLog().debug((CharSequence)("failOnError:" + this.parsedFailOnError));
        this.getLog().debug((CharSequence)("skip:" + this.parsedSkip));
        this.getLog().debug((CharSequence)("ignoreWarnings:" + this.parsedIgnoreWarnings));
        this.getLog().debug((CharSequence)("warnAll:" + this.parsedWarnAll));
        this.getLog().debug((CharSequence)("warningsAsErrors:" + this.parsedWarningsAsErrors));
        this.getLog().debug((CharSequence)("config2:" + this.parsedConfig));
        this.getLog().debug((CharSequence)("fullPath:" + this.parsedFullPath));
        this.getLog().debug((CharSequence)("showAll:" + this.parsedShowAll));
        this.getLog().debug((CharSequence)("disableSourceLines:" + this.parsedDisableSourceLines));
        this.getLog().debug((CharSequence)("enablehtml: " + this.parsedEnableHtml));
        this.getLog().debug((CharSequence)("htmlOutputPath:" + this.parsedHtmlOutputPath));
        this.getLog().debug((CharSequence)("enableSimpleHtml: " + this.parsedEnableSimpleHtml));
        this.getLog().debug((CharSequence)("simpleHtmlOutputPath:" + this.parsedSimpleHtmlOutputPath));
        this.getLog().debug((CharSequence)("enableXml: " + this.parsedEnableXml));
        this.getLog().debug((CharSequence)("xmlOutputPath:" + this.parsedXmlOutputPath));
        this.getLog().debug((CharSequence)("sources:" + this.parsedSources));
        this.getLog().debug((CharSequence)("classpath:" + this.parsedClasspath));
        this.getLog().debug((CharSequence)("libraries:" + this.parsedLibraries));
        if (this.parsedSkip.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping lint analysis.");
        } else {
            this.getLog().info((CharSequence)"Performing lint analysis.");
            this.executeWhenConfigured();
        }
    }

    private void executeWhenConfigured() throws MojoExecutionException {
        block16: {
            CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
            executor.setLogger(this.getLog());
            String command = this.getAndroidSdk().getLintPath();
            ArrayList<String> parameters = new ArrayList<String>();
            if (this.isNotNullAndTrue(this.parsedIgnoreWarnings)) {
                parameters.add("-w");
            }
            if (this.isNotNullAndTrue(this.parsedWarnAll)) {
                parameters.add("-Wall");
            }
            if (this.isNotNullAndTrue(this.parsedWarningsAsErrors)) {
                parameters.add("-Werror");
            }
            if (this.isNotNullAndNotEquals(this.parsedConfig, "null")) {
                parameters.add("--config");
                parameters.add(this.parsedConfig);
            }
            if (this.isNotNullAndTrue(this.parsedFullPath)) {
                parameters.add("--fullpath");
            }
            if (this.isNotNullAndTrue(this.parsedShowAll)) {
                parameters.add("--showall");
            }
            if (this.isNotNullAndTrue(this.parsedDisableSourceLines)) {
                parameters.add("--nolines");
            }
            if (this.isNotNullAndTrue(this.parsedEnableHtml)) {
                parameters.add("--html");
                parameters.add(this.parsedHtmlOutputPath);
                this.getLog().info((CharSequence)("Writing Lint HTML report in " + this.parsedHtmlOutputPath));
            }
            if (this.isNotNullAndNotEquals(this.parsedUrl, "none")) {
                parameters.add("--url");
                parameters.add(this.parsedUrl);
            }
            if (this.isNotNullAndTrue(this.parsedEnableSimpleHtml)) {
                parameters.add("--simplehtml");
                parameters.add(this.parsedSimpleHtmlOutputPath);
                this.getLog().info((CharSequence)("Writing Lint simple HTML report in " + this.parsedSimpleHtmlOutputPath));
            }
            if (this.isNotNullAndTrue(this.parsedEnableXml)) {
                parameters.add("--xml");
                parameters.add(this.parsedXmlOutputPath);
                this.getLog().info((CharSequence)("Writing Lint XML report in " + this.parsedXmlOutputPath));
            }
            if (this.isNotNullAndTrue(this.parsedEnableSources)) {
                parameters.add("--sources");
                parameters.add(this.parsedSources);
            }
            if (this.isNotNullAndTrue(this.parsedEnableClasspath)) {
                parameters.add("--classpath");
                parameters.add(this.parsedClasspath);
            }
            if (this.isNotNullAndTrue(this.parsedEnableLibraries)) {
                parameters.add("--libraries");
                parameters.add(this.parsedLibraries);
            }
            parameters.add(this.project.getBasedir().getAbsolutePath());
            parameters.add("--exitcode");
            try {
                this.getLog().info((CharSequence)("Running command: " + command));
                this.getLog().info((CharSequence)("with parameters: " + parameters));
                executor.executeCommand(command, parameters, false);
            }
            catch (ExecutionException e) {
                if (!this.isNotNullAndTrue(this.parsedFailOnError)) break block16;
                this.getLog().info((CharSequence)"Lint analysis produced errors and project is configured to fail on error.");
                this.getLog().info((CharSequence)"Inspect lint reports or re-run with -X to see lint errors in log");
                this.getLog().info((CharSequence)"Failing build as configured. Ignore following error message.");
                throw new MojoExecutionException("", (Exception)e);
            }
        }
        this.getLog().info((CharSequence)"Lint analysis completed successfully.");
    }

    private boolean isNotNullAndTrue(Boolean b) {
        return b != null && b != false;
    }

    private boolean isNotNullAndNotEquals(String underTest, String compared) {
        return underTest != null && !underTest.equals(compared);
    }

    private String getHtmlOutputPath() {
        if (this.parsedHtmlOutputPath == null) {
            File reportPath = new File(this.project.getBuild().getDirectory(), "lint-results/lint-results-html");
            this.createReportDirIfNeeded(reportPath);
            return reportPath.getAbsolutePath();
        }
        return this.parsedHtmlOutputPath;
    }

    private String getSimpleHtmlOutputPath() {
        if (this.parsedSimpleHtmlOutputPath == null) {
            File reportPath = new File(this.project.getBuild().getDirectory(), "lint-results/lint-results-simple-html");
            this.createReportDirIfNeeded(reportPath);
            return reportPath.getAbsolutePath();
        }
        return this.parsedSimpleHtmlOutputPath;
    }

    private String getXmlOutputPath() {
        this.getLog().debug((CharSequence)("get parsed xml output path:" + this.parsedXmlOutputPath));
        if (this.parsedXmlOutputPath == null) {
            File reportPath = new File(this.project.getBuild().getDirectory(), "lint-results/lint-results.xml");
            this.createReportDirIfNeeded(reportPath);
            return reportPath.getAbsolutePath();
        }
        return this.parsedXmlOutputPath;
    }

    private void createReportDirIfNeeded(File reportPath) {
        if (!reportPath.getParentFile().exists()) {
            reportPath.getParentFile().mkdirs();
        }
    }

    private String getSources() {
        if (this.parsedSources == null) {
            this.parsedSources = new File(this.project.getBuild().getSourceDirectory()).getAbsolutePath();
        }
        return this.parsedSources;
    }

    private String getClasspath() {
        if (this.parsedClasspath == null) {
            this.parsedClasspath = new File(this.project.getBuild().getOutputDirectory()).getAbsolutePath();
        }
        return this.parsedClasspath;
    }

    private String getLibraries() {
        if (this.parsedLibraries == null) {
            StringBuilder defaultClasspathBuilder = new StringBuilder();
            Set artifacts = this.project.getDependencyArtifacts();
            if (artifacts != null) {
                for (Artifact artifact : artifacts) {
                    if ("provided".equals(artifact.getScope()) || !artifact.isResolved()) continue;
                    defaultClasspathBuilder.append(artifact.getFile().getPath());
                    defaultClasspathBuilder.append(File.pathSeparator);
                }
                if (defaultClasspathBuilder.length() > 0) {
                    defaultClasspathBuilder.deleteCharAt(defaultClasspathBuilder.length() - 1);
                    this.parsedLibraries = defaultClasspathBuilder.toString();
                }
            }
        }
        return this.parsedLibraries;
    }
}

