/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase05compile;

import com.jayway.maven.plugins.android.AbstractAndroidMojo;
import com.jayway.maven.plugins.android.CommandExecutor;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class ConsumeAarMojo
extends AbstractAndroidMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isCurrentProjectAndroid()) {
            return;
        }
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        for (Artifact artifact : this.getAllRelevantDependencyArtifacts()) {
            if (!artifact.getType().equals("aar")) continue;
            String aarJar = this.getLibraryUnpackDirectory(artifact) + "/" + "classes.jar";
            File aarFileJar = new File(aarJar);
            ZipUnArchiver unArchiver = new ZipUnArchiver(aarFileJar){

                protected Logger getLogger() {
                    return new ConsoleLogger(0, "classes-unarchiver");
                }
            };
            File classes = new File(this.project.getBuild().getOutputDirectory());
            this.getLog().info((CharSequence)("output " + classes));
            classes.mkdir();
            unArchiver.setDestDirectory(classes);
            try {
                unArchiver.extract();
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("ArchiverException while extracting " + aarFileJar.getAbsolutePath() + ". Message: " + e.getLocalizedMessage(), (Exception)((Object)e));
            }
            this.getLog().info((CharSequence)("Extracted " + aarJar));
        }
    }

    private boolean isCurrentProjectAndroid() {
        HashSet<String> androidArtifacts = new HashSet<String>(){
            {
                this.addAll(Arrays.asList("apk", "apklib", "apksources", "aar"));
            }
        };
        return androidArtifacts.contains(this.project.getArtifact().getType());
    }
}

