/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductPlace;
import com.herbocailleau.sgq.entities.ProductStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class ProductAbstract
extends TopiaEntityAbstract
implements Product {
    protected String code;
    protected String name;
    protected String category;
    protected String latinName;
    protected String family;
    protected boolean botanicControl;
    protected boolean identificationControl;
    protected String comment;
    protected boolean archived;
    protected Collection<ProductStatus> productStatus;
    protected Collection<AnalyzeType> analyzeType;
    protected ProductPlace placeProductPlace;
    private static final long serialVersionUID = 3546919190825886769L;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "code", String.class, (Object)this.code);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "category", String.class, (Object)this.category);
        visitor.visit((TopiaEntity)this, "latinName", String.class, (Object)this.latinName);
        visitor.visit((TopiaEntity)this, "family", String.class, (Object)this.family);
        visitor.visit((TopiaEntity)this, "botanicControl", Boolean.TYPE, (Object)this.botanicControl);
        visitor.visit((TopiaEntity)this, "identificationControl", Boolean.TYPE, (Object)this.identificationControl);
        visitor.visit((TopiaEntity)this, "comment", String.class, (Object)this.comment);
        visitor.visit((TopiaEntity)this, "archived", Boolean.TYPE, (Object)this.archived);
        visitor.visit((TopiaEntity)this, "productStatus", Collection.class, ProductStatus.class, this.productStatus);
        visitor.visit((TopiaEntity)this, "analyzeType", Collection.class, AnalyzeType.class, this.analyzeType);
        visitor.visit((TopiaEntity)this, "placeProductPlace", ProductPlace.class, (Object)this.placeProductPlace);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setCode(String code) {
        String oldValue = this.code;
        this.fireOnPreWrite("code", oldValue, code);
        this.code = code;
        this.fireOnPostWrite("code", oldValue, code);
    }

    @Override
    public String getCode() {
        this.fireOnPreRead("code", this.code);
        String result = this.code;
        this.fireOnPostRead("code", this.code);
        return result;
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.fireOnPreWrite("name", oldValue, name);
        this.name = name;
        this.fireOnPostWrite("name", oldValue, name);
    }

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public void setCategory(String category) {
        String oldValue = this.category;
        this.fireOnPreWrite("category", oldValue, category);
        this.category = category;
        this.fireOnPostWrite("category", oldValue, category);
    }

    @Override
    public String getCategory() {
        this.fireOnPreRead("category", this.category);
        String result = this.category;
        this.fireOnPostRead("category", this.category);
        return result;
    }

    @Override
    public void setLatinName(String latinName) {
        String oldValue = this.latinName;
        this.fireOnPreWrite("latinName", oldValue, latinName);
        this.latinName = latinName;
        this.fireOnPostWrite("latinName", oldValue, latinName);
    }

    @Override
    public String getLatinName() {
        this.fireOnPreRead("latinName", this.latinName);
        String result = this.latinName;
        this.fireOnPostRead("latinName", this.latinName);
        return result;
    }

    @Override
    public void setFamily(String family) {
        String oldValue = this.family;
        this.fireOnPreWrite("family", oldValue, family);
        this.family = family;
        this.fireOnPostWrite("family", oldValue, family);
    }

    @Override
    public String getFamily() {
        this.fireOnPreRead("family", this.family);
        String result = this.family;
        this.fireOnPostRead("family", this.family);
        return result;
    }

    @Override
    public void setBotanicControl(boolean botanicControl) {
        boolean oldValue = this.botanicControl;
        this.fireOnPreWrite("botanicControl", oldValue, botanicControl);
        this.botanicControl = botanicControl;
        this.fireOnPostWrite("botanicControl", oldValue, botanicControl);
    }

    @Override
    public boolean isBotanicControl() {
        this.fireOnPreRead("botanicControl", this.botanicControl);
        boolean result = this.botanicControl;
        this.fireOnPostRead("botanicControl", this.botanicControl);
        return result;
    }

    @Override
    public boolean getBotanicControl() {
        this.fireOnPreRead("botanicControl", this.botanicControl);
        boolean result = this.botanicControl;
        this.fireOnPostRead("botanicControl", this.botanicControl);
        return result;
    }

    @Override
    public void setIdentificationControl(boolean identificationControl) {
        boolean oldValue = this.identificationControl;
        this.fireOnPreWrite("identificationControl", oldValue, identificationControl);
        this.identificationControl = identificationControl;
        this.fireOnPostWrite("identificationControl", oldValue, identificationControl);
    }

    @Override
    public boolean isIdentificationControl() {
        this.fireOnPreRead("identificationControl", this.identificationControl);
        boolean result = this.identificationControl;
        this.fireOnPostRead("identificationControl", this.identificationControl);
        return result;
    }

    @Override
    public boolean getIdentificationControl() {
        this.fireOnPreRead("identificationControl", this.identificationControl);
        boolean result = this.identificationControl;
        this.fireOnPostRead("identificationControl", this.identificationControl);
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        this.fireOnPreWrite("comment", oldValue, comment);
        this.comment = comment;
        this.fireOnPostWrite("comment", oldValue, comment);
    }

    @Override
    public String getComment() {
        this.fireOnPreRead("comment", this.comment);
        String result = this.comment;
        this.fireOnPostRead("comment", this.comment);
        return result;
    }

    @Override
    public void setArchived(boolean archived) {
        boolean oldValue = this.archived;
        this.fireOnPreWrite("archived", oldValue, archived);
        this.archived = archived;
        this.fireOnPostWrite("archived", oldValue, archived);
    }

    @Override
    public boolean isArchived() {
        this.fireOnPreRead("archived", this.archived);
        boolean result = this.archived;
        this.fireOnPostRead("archived", this.archived);
        return result;
    }

    @Override
    public boolean getArchived() {
        this.fireOnPreRead("archived", this.archived);
        boolean result = this.archived;
        this.fireOnPostRead("archived", this.archived);
        return result;
    }

    @Override
    public void addProductStatus(ProductStatus productStatus) {
        this.fireOnPreWrite("productStatus", null, productStatus);
        if (this.productStatus == null) {
            this.productStatus = new ArrayList<ProductStatus>();
        }
        this.productStatus.add(productStatus);
        this.fireOnPostWrite("productStatus", this.productStatus.size(), null, productStatus);
    }

    @Override
    public void addAllProductStatus(Collection<ProductStatus> productStatus) {
        if (productStatus == null) {
            return;
        }
        for (ProductStatus item : productStatus) {
            this.addProductStatus(item);
        }
    }

    @Override
    public void setProductStatus(Collection<ProductStatus> productStatus) {
        ArrayList<ProductStatus> oldValue = this.productStatus != null ? new ArrayList<ProductStatus>(this.productStatus) : null;
        this.fireOnPreWrite("productStatus", oldValue, productStatus);
        this.productStatus = productStatus;
        this.fireOnPostWrite("productStatus", oldValue, productStatus);
    }

    @Override
    public void removeProductStatus(ProductStatus productStatus) {
        this.fireOnPreWrite("productStatus", productStatus, null);
        if (this.productStatus == null || !this.productStatus.remove(productStatus)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("productStatus", this.productStatus.size() + 1, productStatus, null);
    }

    @Override
    public void clearProductStatus() {
        if (this.productStatus == null) {
            return;
        }
        ArrayList<ProductStatus> oldValue = new ArrayList<ProductStatus>(this.productStatus);
        this.fireOnPreWrite("productStatus", oldValue, this.productStatus);
        this.productStatus.clear();
        this.fireOnPostWrite("productStatus", oldValue, this.productStatus);
    }

    @Override
    public Collection<ProductStatus> getProductStatus() {
        return this.productStatus;
    }

    @Override
    public ProductStatus getProductStatusByTopiaId(String topiaId) {
        return (ProductStatus)TopiaEntityHelper.getEntityByTopiaId(this.productStatus, (String)topiaId);
    }

    @Override
    public int sizeProductStatus() {
        if (this.productStatus == null) {
            return 0;
        }
        return this.productStatus.size();
    }

    @Override
    public boolean isProductStatusEmpty() {
        int size = this.sizeProductStatus();
        return size == 0;
    }

    @Override
    public void addAnalyzeType(AnalyzeType analyzeType) {
        this.fireOnPreWrite("analyzeType", null, analyzeType);
        if (this.analyzeType == null) {
            this.analyzeType = new ArrayList<AnalyzeType>();
        }
        this.analyzeType.add(analyzeType);
        this.fireOnPostWrite("analyzeType", this.analyzeType.size(), null, analyzeType);
    }

    @Override
    public void addAllAnalyzeType(Collection<AnalyzeType> analyzeType) {
        if (analyzeType == null) {
            return;
        }
        for (AnalyzeType item : analyzeType) {
            this.addAnalyzeType(item);
        }
    }

    @Override
    public void setAnalyzeType(Collection<AnalyzeType> analyzeType) {
        ArrayList<AnalyzeType> oldValue = this.analyzeType != null ? new ArrayList<AnalyzeType>(this.analyzeType) : null;
        this.fireOnPreWrite("analyzeType", oldValue, analyzeType);
        this.analyzeType = analyzeType;
        this.fireOnPostWrite("analyzeType", oldValue, analyzeType);
    }

    @Override
    public void removeAnalyzeType(AnalyzeType analyzeType) {
        this.fireOnPreWrite("analyzeType", analyzeType, null);
        if (this.analyzeType == null || !this.analyzeType.remove(analyzeType)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("analyzeType", this.analyzeType.size() + 1, analyzeType, null);
    }

    @Override
    public void clearAnalyzeType() {
        if (this.analyzeType == null) {
            return;
        }
        ArrayList<AnalyzeType> oldValue = new ArrayList<AnalyzeType>(this.analyzeType);
        this.fireOnPreWrite("analyzeType", oldValue, this.analyzeType);
        this.analyzeType.clear();
        this.fireOnPostWrite("analyzeType", oldValue, this.analyzeType);
    }

    @Override
    public Collection<AnalyzeType> getAnalyzeType() {
        return this.analyzeType;
    }

    @Override
    public AnalyzeType getAnalyzeTypeByTopiaId(String topiaId) {
        return (AnalyzeType)TopiaEntityHelper.getEntityByTopiaId(this.analyzeType, (String)topiaId);
    }

    @Override
    public int sizeAnalyzeType() {
        if (this.analyzeType == null) {
            return 0;
        }
        return this.analyzeType.size();
    }

    @Override
    public boolean isAnalyzeTypeEmpty() {
        int size = this.sizeAnalyzeType();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        ArrayList tmp = new ArrayList();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        ArrayList<ProductPlace> tmp = new ArrayList<ProductPlace>();
        if (this.placeProductPlace != null) {
            tmp.add(this.placeProductPlace);
        }
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity topiaEntity : tmp) {
            if (topiaEntity == null) continue;
            result.add(topiaEntity);
            result.addAll(topiaEntity.getComposite());
        }
        return result;
    }
}

