/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.LabelError;
import com.herbocailleau.sgq.entities.LabelErrorDAOAbstract;
import com.herbocailleau.sgq.entities.Zone;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.TopiaException;

public class LabelErrorDAOImpl<E extends LabelError>
extends LabelErrorDAOAbstract<E> {
    public long findLabelErrorsCount() throws TopiaException {
        String query = "select count(L) from " + LabelError.class.getName() + " L WHERE L." + "modified" + " = false" + " AND L." + "deleted" + " = false";
        Number result = (Number)this.context.findUnique(query, new Object[0]);
        return result.longValue();
    }

    public List<LabelError> findLabelErrorsBySource(Zone source) throws TopiaException {
        String query = "from " + LabelError.class.getName() + " where " + "source" + " = :zone" + " AND " + "modified" + " = false" + " AND " + "deleted" + " = false" + " order by " + "line";
        List result = this.context.findAll(query, new Object[]{"zone", source});
        return result;
    }

    public List<LabelError> findAllLabelErrors(Date beginDate, Date endDate) throws TopiaException {
        String suffix = " order by L.labelDate";
        List result = (List)this.findLabelErrors("", suffix, beginDate, endDate, 0, -1);
        return result;
    }

    public List<LabelError> findLabelErrors(Date beginDate, Date endDate, int offset, int limit) throws TopiaException {
        String suffix = " order by L.labelDate";
        List result = (List)this.findLabelErrors("", suffix, beginDate, endDate, offset, limit);
        return result;
    }

    public long findLabelErrorsCount(Date beginDate, Date endDate) throws TopiaException {
        String prefix = "SELECT count(L) ";
        Number count = (Number)this.findLabelErrors(prefix, "", beginDate, endDate, -1, -1);
        return count.longValue();
    }

    protected Object findLabelErrors(String prefix, String suffix, Date beginDate, Date endDate, int offset, int limit) throws TopiaException {
        String query = prefix + "from " + LabelError.class.getName() + " L where (L." + "modified" + " = true" + " OR L." + "deleted" + " = true)";
        ArrayList<Object> params = new ArrayList<Object>();
        if (beginDate != null) {
            query = query + " AND :beginDate <= L.labelDate";
            params.add("beginDate");
            params.add(beginDate);
        }
        if (endDate != null) {
            query = query + " AND L.labelDate <= :endDate";
            params.add("endDate");
            params.add(endDate);
        }
        query = query + suffix;
        Object result = offset == -1 ? this.context.findUnique(query, params.toArray()) : (limit == -1 ? this.context.findAll(query, params.toArray()) : this.context.find(query, offset, offset + limit - 1, params.toArray()));
        return result;
    }

    public List<Batch> getBatchWithLabelAfterExpiration() throws TopiaException {
        String query = "SELECT DISTINCT afterBatchExpiration from " + LabelError.class.getName() + " where " + "afterBatchExpiration" + " != null" + " AND " + "modified" + " = false" + " AND " + "deleted" + " = false";
        List result = this.context.findAll(query, new Object[0]);
        return result;
    }
}

