/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.SgqService;
import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchDAO;
import com.herbocailleau.sgq.entities.Expedition;
import com.herbocailleau.sgq.entities.ExpeditionDAO;
import com.herbocailleau.sgq.entities.LabelError;
import com.herbocailleau.sgq.entities.LabelErrorDAO;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.PresentationDAO;
import com.herbocailleau.sgq.entities.Production;
import com.herbocailleau.sgq.entities.ProductionDAO;
import com.herbocailleau.sgq.entities.Zone;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;

public class ProductionService
extends SgqService {
    private static final Log log = LogFactory.getLog(ProductionService.class);
    protected static final char ERROR_REPLAY_SEPARATOR = ',';
    protected final DateFormat LABEL_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");

    public Date getLastImportDate(Zone zone) {
        Date result = null;
        try {
            ExpeditionDAO expeditionDAO = this.daoHelper.getExpeditionDAO();
            ProductionDAO productionDAO = this.daoHelper.getProductionDAO();
            result = expeditionDAO.findMaxDateForZone(zone);
            Date result2 = productionDAO.findMaxDateForZone(zone);
            if (result2 != null && (result == null || result.before(result2))) {
                result = result2;
            }
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get configuration", ex);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ImportLog> importLabelsFile(String fileFilename, File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing labels file : " + file));
        }
        String productionFileName = this.config.getLabelProductionFilename();
        Zone sourceZone = null;
        Date lastImport = null;
        if (productionFileName.equalsIgnoreCase(fileFilename)) {
            sourceZone = Zone.ZE;
            lastImport = this.getLastImportDate(Zone.ZE);
        } else {
            String expeditionFileName = this.config.getLabelExpeditionFilename();
            if (!expeditionFileName.equalsIgnoreCase(fileFilename)) {
                throw new SgqBusinessException(I18n._((String)"Nom de fichier '%s' invalide ! (Autoris\u00e9 %s ou %s)", (Object[])new Object[]{fileFilename, productionFileName, expeditionFileName}));
            }
            sourceZone = Zone.ZP;
            lastImport = this.getLastImportDate(Zone.ZP);
        }
        Date importFrom = lastImport;
        if (importFrom == null) {
            importFrom = new Date(0L);
        }
        importFrom = DateUtils.addDays((Date)importFrom, (int)1);
        importFrom = DateUtils.truncate((Date)importFrom, (int)5);
        Date today = DateUtils.truncate((Date)new Date(), (int)5);
        ArrayList<ImportLog> importLogs = new ArrayList<ImportLog>();
        CSVReader reader = null;
        try {
            reader = new CSVReader((Reader)new FileReader(file));
            SimpleDateFormat dfOut = new SimpleDateFormat("dd/MM/yyyy");
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            ExpeditionDAO expeditionDAO = this.daoHelper.getExpeditionDAO();
            ProductionDAO productionDAO = this.daoHelper.getProductionDAO();
            LabelErrorDAO labelErrorDAO = this.daoHelper.getLabelErrorDAO();
            HashMap batchPresentations = new HashMap();
            HashMap<Integer, Batch> batchCache = new HashMap<Integer, Batch>();
            if (lastImport == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Populating cache for first import");
                }
                List allPresentations = presentationDAO.findAll();
                for (Presentation presentation : allPresentations) {
                    Batch batch = presentation.getBatch();
                    batchCache.put(batch.getNumber(), batch);
                    ArrayList<Presentation> batchPresentation = (ArrayList<Presentation>)batchPresentations.get(batch);
                    if (batchPresentation == null) {
                        batchPresentation = new ArrayList<Presentation>();
                        batchPresentations.put(batch, batchPresentation);
                    }
                    batchPresentation.add(presentation);
                }
            }
            int line = 0;
            Object[] csvdata = null;
            while ((csvdata = reader.readNext()) != null) {
                Date previousDate;
                double presQuantity;
                Date lineDate;
                if (csvdata.length <= 1) continue;
                ++line;
                String columns = "";
                for (int i = 0; i < csvdata.length; i += 2) {
                    columns = columns + csvdata[i];
                }
                if (!"DBCPLQ".equals(columns) && !"DBCPLQR".equals(columns)) {
                    throw new SgqBusinessException(I18n._((String)"Nom de colonne invalides; trouv\u00e9 : %s, attendu : %s ou %s", (Object[])new Object[]{columns, "DBCPLQ", "DBCPLQR"}));
                }
                String dateyyyyMMdd = csvdata[1];
                String clientId = csvdata[5];
                String productId = csvdata[7];
                String batchId = csvdata[9];
                String quantityStr = csvdata[11];
                String batchCorrectionId = null;
                if (csvdata.length >= 14) {
                    batchCorrectionId = csvdata[13];
                }
                if ((lineDate = this.LABEL_DATE_FORMAT.parse(dateyyyyMMdd)).before(importFrom)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)I18n._((String)"Skipping date %s, before %s", (Object[])new Object[]{lineDate.toString(), importFrom.toString()}));
                    continue;
                }
                ImportLog importLog = new ImportLog();
                importLog.setLine(line);
                importLog.setCode(dfOut.format(lineDate));
                importLogs.add(importLog);
                if (!lineDate.before(today)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)I18n._((String)"Skipping date of current day %s", (Object[])new Object[]{lineDate.toString()}));
                    }
                    importLog.setError(true);
                    importLog.setMessage(I18n._((String)"Ligne ignor\u00e9e (date du jour)", (Object[])new Object[0]));
                    continue;
                }
                int sourceBatchNumber = Integer.parseInt(batchId);
                Batch sourceBatch = (Batch)batchCache.get(sourceBatchNumber);
                if (sourceBatch == null) {
                    sourceBatch = batchDAO.findByNumber(sourceBatchNumber);
                }
                if (sourceBatch == null) {
                    importLog.setError(true);
                    importLog.setMessage(I18n._((String)"Impossible de trouver le lot %s", (Object[])new Object[]{batchId}));
                    labelErrorDAO.create(new Object[]{"line", StringUtils.join((Object[])csvdata, (char)','), "message", importLog.getMessage(), "source", sourceZone});
                    continue;
                }
                batchCache.put(sourceBatchNumber, sourceBatch);
                Batch correctionBatch = null;
                if (StringUtils.isNotBlank((CharSequence)batchCorrectionId)) {
                    int destBatchNumber = Integer.parseInt(batchCorrectionId);
                    correctionBatch = (Batch)batchCache.get(destBatchNumber);
                    if (correctionBatch == null) {
                        correctionBatch = batchDAO.findByNumber(destBatchNumber);
                    }
                    if (correctionBatch == null) {
                        importLog.setError(true);
                        importLog.setMessage(I18n._((String)"Impossible de trouver le lot %s", (Object[])new Object[]{batchCorrectionId}));
                        labelErrorDAO.create(new Object[]{"line", StringUtils.join((Object[])csvdata, (char)','), "message", importLog.getMessage(), "source", sourceZone});
                        continue;
                    }
                    batchCache.put(destBatchNumber, correctionBatch);
                }
                if (sourceBatch.isInvalid()) {
                    importLog.setError(true);
                    importLog.setMessage(I18n._((String)"Le lot %d a \u00e9t\u00e9 marqu\u00e9 comme ignor\u00e9. Impossible d'enregistrer une \u00e9tiquette sur ce lot.", (Object[])new Object[]{sourceBatch.getNumber()}));
                    labelErrorDAO.create(new Object[]{"line", StringUtils.join((Object[])csvdata, (char)','), "message", importLog.getMessage(), "source", sourceZone});
                    continue;
                }
                if (correctionBatch != null && correctionBatch.isInvalid()) {
                    importLog.setError(true);
                    importLog.setMessage(I18n._((String)"Le lot %d a \u00e9t\u00e9 marqu\u00e9 comme ignor\u00e9. Impossible d'enregistrer une \u00e9tiquette sur ce lot.", (Object[])new Object[]{correctionBatch.getNumber()}));
                    labelErrorDAO.create(new Object[]{"line", StringUtils.join((Object[])csvdata, (char)','), "message", importLog.getMessage(), "source", sourceZone});
                    continue;
                }
                if (sourceBatch.getExpiredDate() != null && lineDate.after(sourceBatch.getExpiredDate())) {
                    importLog.setError(true);
                    importLog.setMessage(I18n._((String)"La date de l'\u00e9tiquette (%1$td/%1$tm/%1$tY) porte apr\u00e8s la date d'expiration du lot %2$d (%3$td/%3$tm/%3$tY).", (Object[])new Object[]{lineDate, sourceBatch.getNumber(), sourceBatch.getExpiredDate()}));
                    labelErrorDAO.create(new Object[]{"line", StringUtils.join((Object[])csvdata, (char)','), "message", importLog.getMessage(), "source", sourceZone, "afterBatchExpiration", sourceBatch});
                    continue;
                }
                if (correctionBatch != null && correctionBatch.getExpiredDate() != null && lineDate.after(correctionBatch.getExpiredDate())) {
                    importLog.setError(true);
                    importLog.setMessage(I18n._((String)"La date de l'\u00e9tiquette (%1$td/%1$tm/%1$tY) porte apr\u00e8s la date d'expiration du lot %2$d (%3$td/%3$tm/%3$tY).", (Object[])new Object[]{lineDate, correctionBatch.getNumber(), correctionBatch.getExpiredDate()}));
                    labelErrorDAO.create(new Object[]{"line", StringUtils.join((Object[])csvdata, (char)','), "message", importLog.getMessage(), "source", sourceZone, "afterBatchExpiration", correctionBatch});
                    continue;
                }
                PresentationCode presentationCode = this.getPresentationCode(productId);
                if (presentationCode == null) {
                    importLog.setError(true);
                    importLog.setMessage(I18n._((String)"Lot %d : Code de pr\u00e9sentation inconnu %s", (Object[])new Object[]{sourceBatch.getNumber(), productId}));
                    labelErrorDAO.create(new Object[]{"line", StringUtils.join((Object[])csvdata, (char)','), "message", importLog.getMessage(), "source", sourceZone});
                    continue;
                }
                if (presentationCode.getEquivalence() != null) {
                    presentationCode = presentationCode.getEquivalence();
                }
                double quantity = Double.parseDouble(quantityStr);
                int client = Integer.parseInt(clientId);
                productId = (presentationCode == PresentationCode.F || presentationCode == PresentationCode.T) && productId.charAt(1) == '0' ? presentationCode.getCode() + productId.substring(2) : productId.substring(1);
                if (!this.checkBatchProduct(sourceBatch, productId, lineDate)) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)I18n._((String)"Lot %d : Le code produit %s ne correspond pas au code produit attendu pour ce lot %s", (Object[])new Object[]{sourceBatch.getNumber(), productId, sourceBatch.getProduct().getCode()}));
                    }
                    importLog.setError(true);
                    importLog.setMessage(I18n._((String)"Lot %d : Le code produit %s ne correspond pas au code produit attendu pour ce lot %s", (Object[])new Object[]{sourceBatch.getNumber(), productId, sourceBatch.getProduct().getCode()}));
                    labelErrorDAO.create(new Object[]{"line", StringUtils.join((Object[])csvdata, (char)','), "message", importLog.getMessage(), "source", sourceZone});
                    continue;
                }
                if (correctionBatch != null && !this.checkBatchProduct(correctionBatch, productId, lineDate)) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)I18n._((String)"Lot %d : Le code produit %s ne correspond pas au code produit attendu pour ce lot %s", (Object[])new Object[]{correctionBatch.getNumber(), productId, correctionBatch.getProduct().getCode()}));
                    }
                    importLog.setError(true);
                    importLog.setMessage(I18n._((String)"Lot %d : Le code produit %s ne correspond pas au code produit attendu pour ce lot %s", (Object[])new Object[]{correctionBatch.getNumber(), productId, correctionBatch.getProduct().getCode()}));
                    labelErrorDAO.create(new Object[]{"line", StringUtils.join((Object[])csvdata, (char)','), "message", importLog.getMessage(), "source", sourceZone});
                    continue;
                }
                List sourcePresentations = (List)batchPresentations.get(sourceBatch);
                if (sourcePresentations == null) {
                    sourcePresentations = presentationDAO.findAllByBatch(sourceBatch);
                    batchPresentations.put(sourceBatch, sourcePresentations);
                }
                Presentation srcPresentation = null;
                Presentation srcOriginPresentation = null;
                for (Presentation presentation : sourcePresentations) {
                    if (presentation.getPresentationCode() == presentationCode) {
                        srcPresentation = presentation;
                    }
                    if (!presentation.isOriginal()) continue;
                    srcOriginPresentation = presentation;
                }
                Presentation corrPresentation = null;
                Presentation corrOriginPresentation = null;
                if (correctionBatch != null) {
                    List destinationPresentations = (List)batchPresentations.get(correctionBatch);
                    if (destinationPresentations == null) {
                        destinationPresentations = presentationDAO.findAllByBatch(correctionBatch);
                        batchPresentations.put(correctionBatch, destinationPresentations);
                    }
                    for (Presentation presentation : destinationPresentations) {
                        if (presentation.getPresentationCode() == presentationCode) {
                            corrPresentation = presentation;
                        }
                        if (!presentation.isOriginal()) continue;
                        corrOriginPresentation = presentation;
                    }
                }
                if (client == Zone.ZE.getClient() || client == Zone.ZP.getClient()) {
                    if (srcPresentation == null) {
                        srcPresentation = presentationDAO.createByNaturalId(sourceBatch, presentationCode);
                        importLog.setMessage(I18n._((String)"Nouvelle presentation %c pour le lot %s", (Object[])new Object[]{Character.valueOf(presentationCode.getCode()), batchId}));
                        ((List)batchPresentations.get(sourceBatch)).add(srcPresentation);
                    } else {
                        importLog.setMessage(I18n._((String)"Mise \u00e0 jour de la presentation %c du lot %s", (Object[])new Object[]{Character.valueOf(presentationCode.getCode()), batchId}));
                    }
                    double productionQuantity = sourceZone == Zone.ZE && client == Zone.ZE.getClient() || srcPresentation.getQuantity() <= 0.0 ? quantity : (srcPresentation.getQuantity() < quantity ? quantity - srcPresentation.getQuantity() : 0.0);
                    if (srcOriginPresentation == null) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Can't find original presentation for row " + Arrays.toString(csvdata)));
                        }
                    } else {
                        double origPresQuantity = srcOriginPresentation.getQuantity();
                        origPresQuantity -= productionQuantity;
                        if (sourceBatch.getExpiredDate() == null) {
                            srcOriginPresentation.setQuantity(origPresQuantity);
                        }
                        presentationDAO.update(srcOriginPresentation);
                    }
                    presQuantity = srcPresentation.getQuantity();
                    presQuantity += productionQuantity;
                    if (sourceBatch.getExpiredDate() == null) {
                        srcPresentation.setQuantity(presQuantity);
                    }
                    presentationDAO.update(srcPresentation);
                    if (correctionBatch != null && correctionBatch.getExpiredDate() == null) {
                        if (corrOriginPresentation == null) {
                            corrOriginPresentation = presentationDAO.createByNaturalId(correctionBatch, PresentationCode._);
                        }
                        if (corrPresentation == null) {
                            corrPresentation = presentationDAO.createByNaturalId(correctionBatch, presentationCode);
                        }
                        double oldProductionQuantity = sourceZone == Zone.ZE && client == Zone.ZE.getClient() ? quantity : (corrPresentation.getQuantity() == quantity ? quantity : 0.0);
                        double corrOriginQuantity = corrOriginPresentation.getQuantity();
                        corrOriginPresentation.setQuantity(corrOriginQuantity += oldProductionQuantity);
                        presentationDAO.update(corrOriginPresentation);
                        double corrQuantity = corrPresentation.getQuantity();
                        corrPresentation.setQuantity(corrQuantity -= oldProductionQuantity);
                        presentationDAO.update(corrPresentation);
                    }
                    Production production = (Production)productionDAO.create(new Object[0]);
                    production.setDate(lineDate);
                    production.setQuantity(quantity);
                    production.setPresentation(srcPresentation);
                    production.setCorrection(corrPresentation);
                    production.setSource(sourceZone);
                    if (client == Zone.ZE.getClient()) {
                        production.setDestination(Zone.ZE);
                    } else {
                        production.setDestination(Zone.ZP);
                    }
                    productionDAO.update(production);
                    continue;
                }
                if (srcPresentation == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)(dateyyyyMMdd + " : Can't find expedition presentation for batch " + sourceBatch.getNumber() + ". Create it !"));
                    }
                    srcPresentation = presentationDAO.createByNaturalId(sourceBatch, presentationCode);
                    ((List)batchPresentations.get(sourceBatch)).add(srcPresentation);
                }
                double expeditionQuantity = 0.0;
                if (srcPresentation.getQuantity() < quantity) {
                    if (srcPresentation.getQuantity() > 0.0) {
                        expeditionQuantity = srcPresentation.getQuantity();
                    }
                    double productionQuantity = quantity - expeditionQuantity;
                    double presQuantity2 = srcOriginPresentation.getQuantity();
                    presQuantity2 -= productionQuantity;
                    if (sourceBatch.getExpiredDate() == null) {
                        srcOriginPresentation.setQuantity(presQuantity2);
                    }
                    presentationDAO.update(srcOriginPresentation);
                } else {
                    expeditionQuantity = quantity;
                }
                presQuantity = srcPresentation.getQuantity();
                presQuantity -= expeditionQuantity;
                if (sourceBatch.getExpiredDate() == null) {
                    srcPresentation.setQuantity(presQuantity);
                }
                presentationDAO.update(srcPresentation);
                importLog.setMessage(I18n._((String)"Nouvelle expedition pour le lot %s au client %s", (Object[])new Object[]{batchId, client}));
                if (correctionBatch != null && correctionBatch.getExpiredDate() == null) {
                    if (corrPresentation == null) {
                        corrPresentation = presentationDAO.createByNaturalId(correctionBatch, presentationCode);
                    }
                    double corrQuantity = corrPresentation.getQuantity();
                    corrPresentation.setQuantity(corrQuantity += quantity);
                    presentationDAO.update(corrPresentation);
                }
                Expedition expedition = (Expedition)expeditionDAO.create(new Object[0]);
                expedition.setDate(lineDate);
                expedition.setPresentation(srcPresentation);
                expedition.setCorrection(corrPresentation);
                expedition.setQuantity(quantity);
                expedition.setClient(clientId);
                expedition.setSource(sourceZone);
                if (client == Zone.ZC.getClient()) {
                    expedition.setDestination(Zone.ZC);
                } else {
                    expedition.setDestination(sourceZone);
                }
                expeditionDAO.update(expedition);
                if (sourceZone != Zone.ZP || client == Zone.ZC.getClient() || (previousDate = sourceBatch.getDmesd()) != null && !lineDate.before(previousDate)) continue;
                sourceBatch.setDmesd(lineDate);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Update dmesd for batch to " + lineDate));
            }
            this.daoHelper.commit();
        }
        catch (IOException ex) {
            try {
                throw new SgqBusinessException("Can't import label file", ex);
                catch (ParseException ex2) {
                    throw new SgqBusinessException("Can't import label file", ex2);
                }
                catch (TopiaException ex3) {
                    throw new SgqBusinessException("Can't import label file", ex3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)reader);
        return importLogs;
    }

    protected ImportLog importSingleLine(String[] csvdata, Zone sourceZone) {
        ImportLog importLog = new ImportLog();
        try {
            int destBatchNumber;
            SimpleDateFormat dfIn = new SimpleDateFormat("yyyyMMdd");
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            ExpeditionDAO expeditionDAO = this.daoHelper.getExpeditionDAO();
            ProductionDAO productionDAO = this.daoHelper.getProductionDAO();
            String dateyyyyMMdd = csvdata[1];
            String clientId = csvdata[5];
            String productId = csvdata[7];
            String batchId = csvdata[9];
            String quantityStr = csvdata[11];
            String batchCorrectionId = null;
            if (csvdata.length >= 14) {
                batchCorrectionId = csvdata[13];
            }
            Date lineDate = dfIn.parse(dateyyyyMMdd);
            int srcBatchNumber = Integer.parseInt(batchId);
            Object sourceBatch = batchDAO.findByNumber(srcBatchNumber);
            if (sourceBatch == null) {
                importLog.setError(true);
                importLog.setMessage(I18n._((String)"Impossible de trouver le lot %s", (Object[])new Object[]{batchId}));
                return importLog;
            }
            Batch correctionBatch = null;
            if (StringUtils.isNotBlank((CharSequence)batchCorrectionId) && (correctionBatch = (Batch)batchDAO.findByNumber(destBatchNumber = Integer.parseInt(batchCorrectionId))) == null) {
                importLog.setError(true);
                importLog.setMessage(I18n._((String)"Impossible de trouver le lot %s", (Object[])new Object[]{batchCorrectionId}));
                return importLog;
            }
            if (sourceBatch.isInvalid()) {
                importLog.setError(true);
                importLog.setMessage(I18n._((String)"Le lot %d a \u00e9t\u00e9 marqu\u00e9 comme ignor\u00e9. Impossible d'enregistrer une \u00e9tiquette sur ce lot.", (Object[])new Object[]{sourceBatch.getNumber()}));
                return importLog;
            }
            if (correctionBatch != null && correctionBatch.isInvalid()) {
                importLog.setError(true);
                importLog.setMessage(I18n._((String)"Le lot %d a \u00e9t\u00e9 marqu\u00e9 comme ignor\u00e9. Impossible d'enregistrer une \u00e9tiquette sur ce lot.", (Object[])new Object[]{correctionBatch.getNumber()}));
                return importLog;
            }
            if (sourceBatch.getExpiredDate() != null && lineDate.after(sourceBatch.getExpiredDate())) {
                importLog.setError(true);
                importLog.setMessage(I18n._((String)"La date de l'\u00e9tiquette (%1$td/%1$tm/%1$tY) porte apr\u00e8s la date d'expiration du lot %2$d (%3$td/%3$tm/%3$tY).", (Object[])new Object[]{lineDate, sourceBatch.getNumber(), sourceBatch.getExpiredDate()}));
                return importLog;
            }
            if (correctionBatch != null && correctionBatch.getExpiredDate() != null && lineDate.after(correctionBatch.getExpiredDate())) {
                importLog.setError(true);
                importLog.setMessage(I18n._((String)"La date de l'\u00e9tiquette (%1$td/%1$tm/%1$tY) porte apr\u00e8s la date d'expiration du lot %2$d (%3$td/%3$tm/%3$tY).", (Object[])new Object[]{lineDate, correctionBatch.getNumber(), correctionBatch.getExpiredDate()}));
                return importLog;
            }
            PresentationCode presentationCode = this.getPresentationCode(productId);
            if (presentationCode == null) {
                importLog.setError(true);
                importLog.setMessage(I18n._((String)"Lot %d : Code de pr\u00e9sentation inconnu %s", (Object[])new Object[]{sourceBatch.getNumber(), productId}));
                return importLog;
            }
            if (presentationCode.getEquivalence() != null) {
                presentationCode = presentationCode.getEquivalence();
            }
            double quantity = Double.parseDouble(quantityStr);
            int client = Integer.parseInt(clientId);
            productId = (presentationCode == PresentationCode.F || presentationCode == PresentationCode.T) && productId.charAt(1) == '0' ? presentationCode.getCode() + productId.substring(2) : productId.substring(1);
            if (correctionBatch != null && !this.checkBatchProduct(correctionBatch, productId, lineDate)) {
                if (log.isErrorEnabled()) {
                    log.error((Object)I18n._((String)"Lot %d : Le code produit %s ne correspond pas au code produit attendu pour ce lot %s", (Object[])new Object[]{correctionBatch.getNumber(), productId, correctionBatch.getProduct().getCode()}));
                }
                importLog.setError(true);
                importLog.setMessage(I18n._((String)"Lot %d : Le code produit %s ne correspond pas au code produit attendu pour ce lot %s", (Object[])new Object[]{correctionBatch.getNumber(), productId, correctionBatch.getProduct().getCode()}));
                return importLog;
            }
            if (!this.checkBatchProduct((Batch)sourceBatch, productId, lineDate)) {
                if (log.isErrorEnabled()) {
                    log.error((Object)I18n._((String)"Lot %d : Le code produit %s ne correspond pas au code produit attendu pour ce lot %s", (Object[])new Object[]{sourceBatch.getNumber(), productId, sourceBatch.getProduct().getCode()}));
                }
                importLog.setError(true);
                importLog.setMessage(I18n._((String)"Lot %d : Le code produit %s ne correspond pas au code produit attendu pour ce lot %s", (Object[])new Object[]{sourceBatch.getNumber(), productId, sourceBatch.getProduct().getCode()}));
                return importLog;
            }
            List srcPresentations = presentationDAO.findAllByBatch((Batch)sourceBatch);
            Presentation srcPresentation = null;
            Presentation srcOriginPresentation = null;
            for (Presentation presentation : srcPresentations) {
                if (presentation.getPresentationCode() == presentationCode) {
                    srcPresentation = presentation;
                }
                if (!presentation.isOriginal()) continue;
                srcOriginPresentation = presentation;
            }
            Presentation corrPresentation = null;
            Presentation corrOriginPresentation = null;
            if (correctionBatch != null) {
                List destPresentations = presentationDAO.findAllByBatch(correctionBatch);
                for (Presentation presentation : destPresentations) {
                    if (presentation.getPresentationCode() == presentationCode) {
                        corrPresentation = presentation;
                    }
                    if (!presentation.isOriginal()) continue;
                    corrOriginPresentation = presentation;
                }
            }
            if (client == Zone.ZE.getClient() || client == Zone.ZP.getClient()) {
                if (srcPresentation == null) {
                    srcPresentation = presentationDAO.createByNaturalId((Batch)sourceBatch, presentationCode);
                    importLog.setMessage(I18n._((String)"Nouvelle presentation %c pour le lot %s", (Object[])new Object[]{Character.valueOf(presentationCode.getCode()), batchId}));
                } else {
                    importLog.setMessage(I18n._((String)"Mise \u00e0 jour de la presentation %c du lot %s", (Object[])new Object[]{Character.valueOf(presentationCode.getCode()), batchId}));
                }
                double productionQuantity = sourceZone == Zone.ZE && client == Zone.ZE.getClient() || srcPresentation.getQuantity() <= 0.0 ? quantity : (srcPresentation.getQuantity() < quantity ? quantity - srcPresentation.getQuantity() : 0.0);
                if (srcOriginPresentation == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Can't find original presentation for row " + Arrays.toString(csvdata)));
                    }
                } else {
                    double origPresQuantity = srcOriginPresentation.getQuantity();
                    origPresQuantity -= productionQuantity;
                    if (sourceBatch.getExpiredDate() == null) {
                        srcOriginPresentation.setQuantity(origPresQuantity);
                    }
                    presentationDAO.update(srcOriginPresentation);
                }
                double presQuantity = srcPresentation.getQuantity();
                presQuantity += productionQuantity;
                if (sourceBatch.getExpiredDate() == null) {
                    srcPresentation.setQuantity(presQuantity);
                }
                presentationDAO.update(srcPresentation);
                if (correctionBatch != null && correctionBatch.getExpiredDate() == null) {
                    if (corrOriginPresentation == null) {
                        corrOriginPresentation = presentationDAO.createByNaturalId(correctionBatch, PresentationCode._);
                    }
                    if (corrPresentation == null) {
                        corrPresentation = presentationDAO.createByNaturalId(correctionBatch, presentationCode);
                    }
                    double oldProductionQuantity = sourceZone == Zone.ZE && client == Zone.ZE.getClient() ? quantity : (corrPresentation.getQuantity() == quantity ? quantity : 0.0);
                    double corrOriginQuantity = corrOriginPresentation.getQuantity();
                    corrOriginPresentation.setQuantity(corrOriginQuantity += oldProductionQuantity);
                    presentationDAO.update(corrOriginPresentation);
                    double corrQuantity = corrPresentation.getQuantity();
                    corrPresentation.setQuantity(corrQuantity -= oldProductionQuantity);
                    presentationDAO.update(corrPresentation);
                }
                Production production = (Production)productionDAO.create(new Object[0]);
                production.setDate(lineDate);
                production.setQuantity(quantity);
                production.setPresentation(srcPresentation);
                production.setCorrection(corrPresentation);
                production.setSource(sourceZone);
                if (client == Zone.ZE.getClient()) {
                    production.setDestination(Zone.ZE);
                } else {
                    production.setDestination(Zone.ZP);
                }
                productionDAO.update(production);
            } else {
                Date previousDate;
                if (srcPresentation == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)(dateyyyyMMdd + " : Can't find expedition presentation for batch " + sourceBatch.getNumber() + ". Create it !"));
                    }
                    srcPresentation = presentationDAO.createByNaturalId((Batch)sourceBatch, presentationCode);
                }
                double expeditionQuantity = 0.0;
                if (srcPresentation.getQuantity() < quantity) {
                    if (srcPresentation.getQuantity() > 0.0) {
                        expeditionQuantity = srcPresentation.getQuantity();
                    }
                    double productionQuantity = quantity - expeditionQuantity;
                    double presQuantity = srcOriginPresentation.getQuantity();
                    presQuantity -= productionQuantity;
                    if (sourceBatch.getExpiredDate() == null) {
                        srcOriginPresentation.setQuantity(presQuantity);
                    }
                    presentationDAO.update(srcOriginPresentation);
                } else {
                    expeditionQuantity = quantity;
                }
                double presQuantity = srcPresentation.getQuantity();
                presQuantity -= expeditionQuantity;
                if (sourceBatch.getExpiredDate() == null) {
                    srcPresentation.setQuantity(presQuantity);
                }
                presentationDAO.update(srcPresentation);
                importLog.setMessage(I18n._((String)"Nouvelle expedition pour le lot %s au client %s", (Object[])new Object[]{batchId, client}));
                if (correctionBatch != null && correctionBatch.getExpiredDate() == null) {
                    if (corrPresentation == null) {
                        corrPresentation = presentationDAO.createByNaturalId(correctionBatch, presentationCode);
                    }
                    double corrQuantity = corrPresentation.getQuantity();
                    corrPresentation.setQuantity(corrQuantity += quantity);
                    presentationDAO.update(corrPresentation);
                }
                Expedition expedition = (Expedition)expeditionDAO.create(new Object[0]);
                expedition.setDate(lineDate);
                expedition.setPresentation(srcPresentation);
                expedition.setCorrection(corrPresentation);
                expedition.setQuantity(quantity);
                expedition.setClient(clientId);
                expedition.setSource(sourceZone);
                if (client == Zone.ZC.getClient()) {
                    expedition.setDestination(Zone.ZC);
                } else {
                    expedition.setDestination(sourceZone);
                }
                expeditionDAO.update(expedition);
                if (sourceZone == Zone.ZP && client != Zone.ZC.getClient() && ((previousDate = sourceBatch.getDmesd()) == null || lineDate.before(previousDate))) {
                    sourceBatch.setDmesd(lineDate);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Update dmesd for batch to " + lineDate));
                    }
                }
            }
        }
        catch (ParseException ex) {
            throw new SgqBusinessException("Can't import line", ex);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't import line", ex);
        }
        return importLog;
    }

    protected PresentationCode getPresentationCode(String productId) {
        char presentationChar = productId.charAt(0);
        PresentationCode result = PresentationCode.getPresentationCodeFor(presentationChar);
        if (result == null && ("ZSAF00".equals(productId) || "ZSAF01".equals(productId))) {
            result = PresentationCode._;
        }
        return result;
    }

    protected boolean checkBatchProduct(Batch batch, String productCode, Date date) {
        boolean result = batch.getProduct().getCode().equals(productCode);
        if (!result) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Testing special case for batch %d and product %s", batch.getNumber(), productCode));
            }
            if (productCode.equals("SAF00")) {
                productCode = "SAF11";
            } else if (productCode.equals("SAF01")) {
                productCode = "SAF12";
            } else if (productCode.equals("BOL13")) {
                productCode = "BOL12";
            } else if (productCode.equals("BOU23")) {
                productCode = "BOU21";
            } else if (productCode.equals("CAS34")) {
                productCode = "CAS32";
            } else if (productCode.equals("CER34")) {
                productCode = "CER31";
            } else if (productCode.equals("CIT32")) {
                productCode = "CIT31";
            } else if (productCode.equals("NOY12")) {
                productCode = "NOY11";
            } else if (productCode.equals("OLI12")) {
                productCode = "OLI11";
            } else if (productCode.equals("SAU14")) {
                productCode = "SAU11";
            } else if (productCode.equals("SEN24")) {
                productCode = "SEN22";
            } else if (productCode.equals("VIG14")) {
                productCode = "VIG11";
            } else if (productCode.equals("ZW199")) {
                productCode = "ZW198";
            } else if (productCode.equals("BOL11")) {
                productCode = "BOL12";
            } else if (productCode.equals("EUC12")) {
                productCode = "EUC11";
            } else if (productCode.equals("HAR22")) {
                productCode = "HAR21";
            } else if (productCode.equals("ORG11")) {
                productCode = "ORG12";
            } else if (productCode.equals("SOU11")) {
                productCode = "SOU12";
            } else if (productCode.equals("BLE21")) {
                productCode = "BLE22";
            } else if (productCode.equals("GIN23")) {
                productCode = "GIN21";
            } else if (productCode.equals("GIN28")) {
                productCode = "GIN26";
            } else if (productCode.equals("MEL21")) {
                productCode = "MEL23";
            } else if (productCode.equals("MEL22")) {
                productCode = "MEL21";
            } else if (productCode.equals("MEN32")) {
                productCode = "MEL31";
            } else if (productCode.equals("TAN12")) {
                productCode = "TAN11";
            } else if (productCode.equals("AIR12")) {
                productCode = "MYR32";
            } else if (productCode.equals("BAD12")) {
                productCode = "BAD11";
            } else if (productCode.equals("CAM12")) {
                productCode = "CAM11";
            } else if (productCode.equals("MAT12")) {
                productCode = "MAT11";
            } else if (productCode.equals("TRE11")) {
                productCode = "TRE12";
            }
            result = batch.getProduct().getCode().equals(productCode);
        }
        return result;
    }

    public long getLabelErrorCount() {
        long result;
        try {
            LabelErrorDAO labelErrorDAO = this.daoHelper.getLabelErrorDAO();
            result = labelErrorDAO.findLabelErrorsCount();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get label error count", ex);
        }
        return result;
    }

    public List<LabelError> getLabelErrorsForZone(Zone source) {
        List<LabelError> errors = null;
        try {
            LabelErrorDAO labelErrorDAO = this.daoHelper.getLabelErrorDAO();
            errors = labelErrorDAO.findLabelErrorsBySource(source);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get label errors", ex);
        }
        return errors;
    }

    public Pair<List<LabelError>, Long> getHistory(Date beginDate, Date endDate, int offset, int count) {
        Pair result = null;
        try {
            LabelErrorDAO labelErrorDAO = this.daoHelper.getLabelErrorDAO();
            List<LabelError> elements = labelErrorDAO.findLabelErrors(beginDate, endDate, offset, count);
            long totalCount = labelErrorDAO.findLabelErrorsCount(beginDate, endDate);
            result = Pair.of(elements, (Object)totalCount);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get label errors", ex);
        }
        return result;
    }

    public InputStream getHistoryAsCsv(Date beginDate, Date endDate) {
        FileInputStream result = null;
        try {
            LabelErrorDAO labelErrorDAO = this.daoHelper.getLabelErrorDAO();
            List<LabelError> elements = labelErrorDAO.findAllLabelErrors(beginDate, endDate);
            File file = File.createTempFile("sgq-search", ".csv");
            file.deleteOnExit();
            CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(file), ';');
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("Source");
            headers.add("Date");
            headers.add("Donn\u00e9es");
            headers.add("\u00c9tat");
            headers.add("Commentaire");
            csvWriter.writeNext(headers.toArray(new String[headers.size()]));
            for (LabelError labelError : elements) {
                ArrayList<String> data = new ArrayList<String>(headers.size());
                if (labelError.getSource() == Zone.ZE) {
                    data.add("FIF_HIST.txt");
                } else {
                    data.add("FIC_HIST.txt");
                }
                if (labelError.getLabelDate() == null) {
                    data.add("");
                } else {
                    data.add(SgqUtils.formatSgqDate(labelError.getLabelDate()));
                }
                data.add(labelError.getLine());
                if (labelError.isDeleted()) {
                    data.add("Supprim\u00e9");
                } else if (labelError.isModified()) {
                    data.add("Corrig\u00e9");
                } else {
                    data.add("Error");
                }
                data.add(labelError.getComment());
                csvWriter.writeNext(data.toArray(new String[data.size()]));
            }
            csvWriter.close();
            result = new FileInputStream(file);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get label errors", ex);
        }
        catch (IOException ex) {
            throw new SgqBusinessException("Can't export label errors", ex);
        }
        return result;
    }

    public ImportLog replayError(String labelErrorId, String replayLine, String comment) {
        if (StringUtils.isBlank((CharSequence)comment)) {
            throw new SgqBusinessException("Comment is mandatory");
        }
        ImportLog importLog = null;
        try {
            LabelErrorDAO labelErrorDAO = this.daoHelper.getLabelErrorDAO();
            LabelError labelError = (LabelError)labelErrorDAO.findByTopiaId(labelErrorId);
            labelError.setLine(replayLine);
            labelError.setComment(comment);
            String[] csvdata = replayLine.split(String.valueOf(','));
            String columns = "";
            for (int i = 0; i < csvdata.length; i += 2) {
                columns = columns + csvdata[i];
            }
            if (!"DBCPLQ".equals(columns) && !"DBCPLQR".equals(columns)) {
                throw new SgqBusinessException(I18n._((String)"Nom de colonne invalides; trouv\u00e9 : %s, attendu : %s ou %s", (Object[])new Object[]{columns, "DBCPLQ", "DBCPLQR"}));
            }
            importLog = this.importSingleLine(csvdata, labelError.getSource());
            if (importLog.isError()) {
                labelError.setMessage(importLog.getMessage());
            } else {
                labelError.setModified(true);
                labelError.setLabelDate(this.getLabelErrorDate(labelError));
            }
            labelErrorDAO.update(labelError);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get label errors", ex);
        }
        return importLog;
    }

    protected Date getLabelErrorDate(LabelError labelError) {
        Date result;
        block3: {
            String replayLine = labelError.getLine();
            String[] csvdata = replayLine.split(String.valueOf(','));
            result = null;
            if (csvdata.length > 2) {
                String dateyyyyMMdd = csvdata[1];
                try {
                    result = this.LABEL_DATE_FORMAT.parse(dateyyyyMMdd);
                }
                catch (ParseException ex) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Can't parse " + dateyyyyMMdd + " as yyyyMMdd date"), (Throwable)ex);
                }
            }
        }
        return result;
    }

    public void deleteError(String labelErrorId, String comment) {
        if (StringUtils.isBlank((CharSequence)comment)) {
            throw new SgqBusinessException("Comment is mandatory");
        }
        try {
            LabelErrorDAO labelErrorDAO = this.daoHelper.getLabelErrorDAO();
            LabelError labelError = (LabelError)labelErrorDAO.findByTopiaId(labelErrorId);
            labelError.setDeleted(true);
            labelError.setComment(comment);
            labelError.setLabelDate(this.getLabelErrorDate(labelError));
            labelErrorDAO.update(labelError);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get label errors", ex);
        }
    }

    public List<Batch> getBatchWithLabelAfterExpiration() {
        List<Batch> result;
        try {
            LabelErrorDAO labelErrorDAO = this.daoHelper.getLabelErrorDAO();
            result = labelErrorDAO.getBatchWithLabelAfterExpiration();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get error batch", ex);
        }
        return result;
    }
}

