/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.resolve;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.text.IHasText;
import com.helger.text.IHasTextWithArgs;
import com.helger.text.resolve.EnumTextResolverWithPropertiesOverrideAndFallback;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public final class DefaultTextResolver
extends EnumTextResolverWithPropertiesOverrideAndFallback {
    private static boolean s_bDefaultInstantiated = false;

    private DefaultTextResolver() {
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    public static @NonNull DefaultTextResolver getInstance() {
        DefaultTextResolver defaultTextResolver = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return defaultTextResolver;
    }

    public static @Nullable String getTextStatic(@NonNull Enum<?> enum_, @NonNull IHasText iHasText, @NonNull Locale locale) {
        return DefaultTextResolver.getInstance().getText(enum_, iHasText, locale);
    }

    @Deprecated(forRemoval=false)
    @DevelopersNote(value="Use getTextStatic instead when no argument is needed!")
    public static @Nullable String getTextWithArgsStatic(@NonNull Enum<?> enum_, @NonNull IHasTextWithArgs iHasTextWithArgs, @NonNull Locale locale) {
        return DefaultTextResolver.getTextStatic(enum_, iHasTextWithArgs, locale);
    }

    public static @Nullable String getTextWithArgsStatic(@NonNull Enum<?> enum_, @NonNull IHasTextWithArgs iHasTextWithArgs, @NonNull Locale locale, Object ... objectArray) {
        return DefaultTextResolver.getInstance().getTextWithArgs(enum_, iHasTextWithArgs, locale, objectArray);
    }

    private static final class SingletonHolder {
        private static final DefaultTextResolver INSTANCE = new DefaultTextResolver();

        private SingletonHolder() {
        }
    }
}

