/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.rt;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.datetime.xml.XMLOffsetDate;
import com.helger.datetime.xml.XMLOffsetDateTime;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.time.zone.ZoneRules;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class OffsetDate
implements Temporal,
TemporalAdjuster,
Comparable<OffsetDate>,
Serializable {
    public static final OffsetDate MIN = OffsetDate.of(LocalDate.MIN, ZoneOffset.MAX);
    public static final OffsetDate MAX = OffsetDate.of(LocalDate.MAX, ZoneOffset.MIN);
    private static final long SECONDS_PER_DAY = 86400L;
    private final LocalDate m_aDate;
    private final ZoneOffset m_aOffset;

    public static @NonNull OffsetDate now() {
        return OffsetDate.now(Clock.systemDefaultZone());
    }

    public static @NonNull OffsetDate now(@NonNull ZoneId zoneId) {
        return OffsetDate.now(Clock.system(zoneId));
    }

    public static @NonNull OffsetDate now(@NonNull Clock clock) {
        ValueEnforcer.notNull((Object)clock, (String)"clock");
        Instant instant = clock.instant();
        return OffsetDate.ofInstant(instant, clock.getZone().getRules().getOffset(instant));
    }

    public static @NonNull OffsetDate of(@NonNull LocalDate localDate, @NonNull ZoneOffset zoneOffset) {
        return new OffsetDate(localDate, zoneOffset);
    }

    public static @NonNull OffsetDate of(int n, int n2, int n3, @NonNull ZoneOffset zoneOffset) {
        LocalDate localDate = LocalDate.of(n, n2, n3);
        return new OffsetDate(localDate, zoneOffset);
    }

    public static @NonNull OffsetDate of(int n, Month month, int n2, @NonNull ZoneOffset zoneOffset) {
        LocalDate localDate = LocalDate.of(n, month, n2);
        return new OffsetDate(localDate, zoneOffset);
    }

    public static @NonNull OffsetDate ofInstant(@NonNull Instant instant, @NonNull ZoneId zoneId) {
        ValueEnforcer.notNull((Object)instant, (String)"instant");
        ValueEnforcer.notNull((Object)zoneId, (String)"zone");
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        long l = instant.getEpochSecond() + (long)zoneOffset.getTotalSeconds();
        long l2 = Math.floorDiv(l, 86400L);
        LocalDate localDate = LocalDate.ofEpochDay(l2);
        return new OffsetDate(localDate, zoneOffset);
    }

    public static @NonNull OffsetDate from(@NonNull TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof OffsetDate) {
            OffsetDate offsetDate = (OffsetDate)temporalAccessor;
            return offsetDate;
        }
        try {
            LocalDate localDate = LocalDate.from(temporalAccessor);
            ZoneOffset zoneOffset = ZoneOffset.from(temporalAccessor);
            return new OffsetDate(localDate, zoneOffset);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain OffsetDate from TemporalAccessor: " + String.valueOf(temporalAccessor.getClass()), dateTimeException);
        }
    }

    public static @NonNull OffsetDate parse(@NonNull CharSequence charSequence) {
        return OffsetDate.parse(charSequence, DateTimeFormatter.ISO_OFFSET_DATE);
    }

    public static @NonNull OffsetDate parse(@NonNull CharSequence charSequence, @NonNull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull((Object)dateTimeFormatter, (String)"formatter");
        return dateTimeFormatter.parse(charSequence, OffsetDate::from);
    }

    protected OffsetDate(@NonNull LocalDate localDate, @NonNull ZoneOffset zoneOffset) {
        this.m_aDate = (LocalDate)ValueEnforcer.notNull((Object)localDate, (String)"date");
        this.m_aOffset = (ZoneOffset)ValueEnforcer.notNull((Object)zoneOffset, (String)"offset");
    }

    protected Object readResolve() {
        return OffsetDate.of(this.m_aDate, this.m_aOffset);
    }

    private @NonNull OffsetDate _with(@NonNull LocalDate localDate, @NonNull ZoneOffset zoneOffset) {
        if (this.m_aDate == localDate && this.m_aOffset.equals(zoneOffset)) {
            return this;
        }
        return new OffsetDate(localDate, zoneOffset);
    }

    @Override
    public boolean isSupported(@Nullable TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isDateBased() || temporalField == ChronoField.OFFSET_SECONDS;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(@Nullable TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isDateBased();
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(@NonNull TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return temporalField.range();
            }
            return this.m_aDate.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(@NonNull TemporalField temporalField) {
        return Temporal.super.get(temporalField);
    }

    @Override
    public long getLong(@NonNull TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return this.getOffset().getTotalSeconds();
            }
            return this.m_aDate.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    public @NonNull ZoneOffset getOffset() {
        return this.m_aOffset;
    }

    public @NonNull OffsetDate withOffsetSameLocal(@NonNull ZoneOffset zoneOffset) {
        ValueEnforcer.notNull((Object)zoneOffset, (String)"offset");
        return this._with(this.m_aDate, zoneOffset);
    }

    public @NonNull LocalDate toLocalDate() {
        return this.m_aDate;
    }

    public int getYear() {
        return this.m_aDate.getYear();
    }

    public int getMonthValue() {
        return this.m_aDate.getMonthValue();
    }

    public @NonNull Month getMonth() {
        return this.m_aDate.getMonth();
    }

    public int getDayOfMonth() {
        return this.m_aDate.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.m_aDate.getDayOfYear();
    }

    public @NonNull DayOfWeek getDayOfWeek() {
        return this.m_aDate.getDayOfWeek();
    }

    @Override
    public @NonNull OffsetDate with(@NonNull TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalDate) {
            LocalDate localDate = (LocalDate)temporalAdjuster;
            return this._with(localDate, this.m_aOffset);
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            ZoneOffset zoneOffset = (ZoneOffset)temporalAdjuster;
            return this._with(this.m_aDate, zoneOffset);
        }
        if (temporalAdjuster instanceof OffsetDate) {
            OffsetDate offsetDate = (OffsetDate)temporalAdjuster;
            return offsetDate;
        }
        return (OffsetDate)temporalAdjuster.adjustInto(this);
    }

    @Override
    public @NonNull OffsetDate with(@NonNull TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return this._with(this.m_aDate, ZoneOffset.ofTotalSeconds(chronoField.checkValidIntValue(l)));
            }
            return this._with(this.m_aDate.with(temporalField, l), this.m_aOffset);
        }
        return temporalField.adjustInto(this, l);
    }

    public @NonNull OffsetDate withYear(int n) {
        return this._with(this.m_aDate.withYear(n), this.m_aOffset);
    }

    public @NonNull OffsetDate withMonth(int n) {
        return this._with(this.m_aDate.withMonth(n), this.m_aOffset);
    }

    public @NonNull OffsetDate withDayOfMonth(int n) {
        return this._with(this.m_aDate.withDayOfMonth(n), this.m_aOffset);
    }

    public @NonNull OffsetDate withDayOfYear(int n) {
        return this._with(this.m_aDate.withDayOfYear(n), this.m_aOffset);
    }

    @Override
    public @NonNull OffsetDate plus(@NonNull TemporalAmount temporalAmount) {
        return (OffsetDate)temporalAmount.addTo(this);
    }

    @Override
    public @NonNull OffsetDate plus(long l, @NonNull TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return this._with(this.m_aDate.plus(l, temporalUnit), this.m_aOffset);
        }
        return temporalUnit.addTo(this, l);
    }

    public @NonNull OffsetDate plusYears(long l) {
        return this._with(this.m_aDate.plusYears(l), this.m_aOffset);
    }

    public @NonNull OffsetDate plusMonths(long l) {
        return this._with(this.m_aDate.plusMonths(l), this.m_aOffset);
    }

    public @NonNull OffsetDate plusWeeks(long l) {
        return this._with(this.m_aDate.plusWeeks(l), this.m_aOffset);
    }

    public @NonNull OffsetDate plusDays(long l) {
        return this._with(this.m_aDate.plusDays(l), this.m_aOffset);
    }

    @Override
    public @NonNull OffsetDate minus(@NonNull TemporalAmount temporalAmount) {
        return (OffsetDate)temporalAmount.subtractFrom(this);
    }

    @Override
    public @NonNull OffsetDate minus(long l, @NonNull TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    public @NonNull OffsetDate minusYears(long l) {
        return this._with(this.m_aDate.minusYears(l), this.m_aOffset);
    }

    public @NonNull OffsetDate minusMonths(long l) {
        return this._with(this.m_aDate.minusMonths(l), this.m_aOffset);
    }

    public @NonNull OffsetDate minusWeeks(long l) {
        return this._with(this.m_aDate.minusWeeks(l), this.m_aOffset);
    }

    public @NonNull OffsetDate minusDays(long l) {
        return this._with(this.m_aDate.minusDays(l), this.m_aOffset);
    }

    @Override
    public <R> R query(@NonNull TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.chronology()) {
            return (R)IsoChronology.INSTANCE;
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.DAYS;
        }
        if (temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.zone()) {
            return (R)this.getOffset();
        }
        return Temporal.super.query(temporalQuery);
    }

    @Override
    public Temporal adjustInto(@NonNull Temporal temporal) {
        return temporal.with(ChronoField.OFFSET_SECONDS, this.getOffset().getTotalSeconds()).with(ChronoField.EPOCH_DAY, this.toLocalDate().toEpochDay());
    }

    @Override
    public long until(@NonNull Temporal temporal, @NonNull TemporalUnit temporalUnit) {
        OffsetDate offsetDate = OffsetDate.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            long l = (long)offsetDate.m_aOffset.getTotalSeconds() - (long)this.m_aOffset.getTotalSeconds();
            LocalDate localDate = offsetDate.m_aDate.plusDays(Math.floorDiv(-l, 86400L));
            return this.m_aDate.until(localDate, temporalUnit);
        }
        return temporalUnit.between(this, offsetDate);
    }

    public @NonNull String format(@NonNull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull((Object)dateTimeFormatter, (String)"formatter");
        return dateTimeFormatter.format(this);
    }

    public @NonNull OffsetDateTime atTime(@NonNull LocalTime localTime) {
        return OffsetDateTime.of(this.m_aDate, localTime, this.m_aOffset);
    }

    public @NonNull XMLOffsetDateTime atTimeXML(@NonNull LocalTime localTime) {
        return XMLOffsetDateTime.of(this.m_aDate, localTime, this.m_aOffset);
    }

    private long _toEpochSecond() {
        long l = this.m_aDate.toEpochDay();
        long l2 = l * 86400L;
        return l2 - (long)this.m_aOffset.getTotalSeconds();
    }

    public long toEpochSecond(@NonNull LocalTime localTime) {
        ValueEnforcer.notNull((Object)localTime, (String)"time");
        return this._toEpochSecond() + (long)localTime.toSecondOfDay();
    }

    @Override
    public int compareTo(@NonNull OffsetDate offsetDate) {
        if (this.m_aOffset.equals(offsetDate.m_aOffset)) {
            return this.m_aDate.compareTo(offsetDate.m_aDate);
        }
        int n = Long.compare(this._toEpochSecond(), offsetDate._toEpochSecond());
        if (n == 0) {
            n = this.m_aDate.compareTo(offsetDate.m_aDate);
        }
        return n;
    }

    public boolean isAfter(@NonNull OffsetDate offsetDate) {
        return this._toEpochSecond() > offsetDate._toEpochSecond();
    }

    public boolean isBefore(@NonNull OffsetDate offsetDate) {
        return this._toEpochSecond() < offsetDate._toEpochSecond();
    }

    public boolean isEqual(@NonNull OffsetDate offsetDate) {
        return this._toEpochSecond() == offsetDate._toEpochSecond();
    }

    public @NonNull XMLOffsetDate toXMLOffsetDate() {
        return XMLOffsetDate.of(this.m_aDate, this.m_aOffset);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        OffsetDate offsetDate = (OffsetDate)object;
        return this.m_aDate.equals(offsetDate.m_aDate) && this.m_aOffset.equals(offsetDate.m_aOffset);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aDate).append((Object)this.m_aOffset).getHashCode();
    }

    @Deprecated(forRemoval=false)
    public @NonNull @Nonempty String getAsString() {
        return this.toString();
    }

    public String toString() {
        return this.m_aDate.toString() + this.m_aOffset.toString();
    }
}

