/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.version;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.compare.IComparable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.version.Version;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class VersionRange
implements IComparable<VersionRange> {
    public static final String DEFAULT_VERSION_RANGE_STRING = "[0)";
    private final boolean m_bIncludeFloor;
    private final Version m_aFloorVersion;
    private final boolean m_bIncludeCeil;
    private final Version m_aCeilVersion;

    public static @NonNull VersionRange parse(@Nullable String string) {
        Version version;
        Version version2;
        boolean bl;
        boolean bl2;
        String string2;
        String string3 = string2 = string == null ? "" : string.trim();
        if (string2.length() == 0) {
            return new VersionRange(Version.DEFAULT_VERSION, true, null, false);
        }
        int n = 0;
        if (string2.charAt(n) == '[') {
            bl2 = true;
            ++n;
        } else if (string2.charAt(n) == '(') {
            bl2 = false;
            ++n;
        } else {
            bl2 = true;
        }
        int n2 = 0;
        if (StringHelper.endsWith((CharSequence)string2, ']')) {
            bl = true;
            ++n2;
        } else if (StringHelper.endsWith((CharSequence)string2, ')')) {
            bl = false;
            ++n2;
        } else {
            bl = false;
        }
        int n3 = string2.length() - n - n2;
        if (n3 == 0) {
            version2 = Version.DEFAULT_VERSION;
            version = null;
        } else {
            String[] stringArray = StringHelper.getExplodedArray(',', string2.substring(n, string2.length() - n2));
            String string4 = stringArray[0].trim();
            String string5 = stringArray.length > 1 ? stringArray[1].trim() : null;
            version2 = Version.parse(string4);
            version = StringHelper.isEmpty(string5) ? null : Version.parse(string5);
        }
        if (version != null && version2.compareTo(version) > 0) {
            throw new IllegalArgumentException("Floor version may not be greater than the ceiling version!");
        }
        return new VersionRange(version2, bl2, version, bl);
    }

    public VersionRange(@NonNull Version version, @Nullable Version version2) {
        this(version, true, version2, true);
    }

    public VersionRange(@NonNull Version version, boolean bl, @Nullable Version version2, boolean bl2) {
        ValueEnforcer.notNull(version, "FloorVersion");
        this.m_aFloorVersion = version;
        this.m_bIncludeFloor = bl;
        this.m_aCeilVersion = version2;
        this.m_bIncludeCeil = bl2;
        if (this.m_aCeilVersion != null && this.m_aFloorVersion.compareTo(this.m_aCeilVersion) > 0) {
            throw new IllegalArgumentException("Floor version may not be greater than the ceiling version!");
        }
    }

    public boolean isIncludingFloor() {
        return this.m_bIncludeFloor;
    }

    public @Nullable Version getFloorVersion() {
        return this.m_aFloorVersion;
    }

    public boolean isIncludingCeil() {
        return this.m_bIncludeCeil;
    }

    public @Nullable Version getCeilVersion() {
        return this.m_aCeilVersion;
    }

    public boolean versionMatches(@NonNull Version version) {
        int n = this.m_aFloorVersion.compareTo(version);
        if (this.m_bIncludeFloor ? n > 0 : n >= 0) {
            return false;
        }
        if (this.m_aCeilVersion != null) {
            n = this.m_aCeilVersion.compareTo(version);
            if (this.m_bIncludeCeil ? n < 0 : n <= 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(@NonNull VersionRange versionRange) {
        int n = this.m_aFloorVersion.compareTo(versionRange.m_aFloorVersion);
        if (n == 0) {
            if (this.m_bIncludeFloor && !versionRange.m_bIncludeFloor) {
                n = -1;
            } else if (!this.m_bIncludeFloor && versionRange.m_bIncludeFloor) {
                n = 1;
            }
            if (n == 0) {
                if (this.m_aCeilVersion != null && versionRange.m_aCeilVersion == null) {
                    n = -1;
                } else if (this.m_aCeilVersion == null && versionRange.m_aCeilVersion != null) {
                    n = 1;
                } else if (this.m_aCeilVersion != null && versionRange.m_aCeilVersion != null) {
                    n = this.m_aCeilVersion.compareTo(versionRange.m_aCeilVersion);
                }
                if (n == 0) {
                    if (this.m_bIncludeCeil && !versionRange.m_bIncludeCeil) {
                        n = 1;
                    } else if (!this.m_bIncludeCeil && versionRange.m_bIncludeCeil) {
                        n = -1;
                    }
                }
            }
        }
        return n;
    }

    public @NonNull String getAsString() {
        return this.getAsString(false);
    }

    public @NonNull String getAsString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(this.m_bIncludeFloor ? "[" : "(");
        stringBuilder.append(this.m_aFloorVersion.getAsString(bl));
        if (this.m_aCeilVersion != null) {
            stringBuilder.append(',').append(this.m_aCeilVersion.getAsString(bl));
        }
        return stringBuilder.append(this.m_bIncludeCeil ? (char)']' : ')').toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        VersionRange versionRange = (VersionRange)object;
        return this.m_bIncludeFloor == versionRange.m_bIncludeFloor && this.m_aFloorVersion.equals(versionRange.m_aFloorVersion) && this.m_bIncludeCeil == versionRange.m_bIncludeCeil && EqualsHelper.equals(this.m_aCeilVersion, versionRange.m_aCeilVersion);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aFloorVersion).append(this.m_bIncludeFloor).append(this.m_aCeilVersion).append(this.m_bIncludeCeil).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("floorVersion", this.m_aFloorVersion).append("inclFloor", this.m_bIncludeFloor).append("ceilVersion", this.m_aCeilVersion).append("inclCeil", this.m_bIncludeCeil).getToString();
    }
}

