/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.apt;

import com.google.web.bindery.requestfactory.apt.ClientToDomainMapper;
import com.google.web.bindery.requestfactory.apt.Messages;
import com.google.web.bindery.requestfactory.apt.ScannerBase;
import com.google.web.bindery.requestfactory.apt.State;
import com.google.web.bindery.requestfactory.apt.TypeSimplifier;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.ProxyForName;
import com.google.web.bindery.requestfactory.shared.Service;
import com.google.web.bindery.requestfactory.shared.ServiceName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

class DomainChecker
extends ScannerBase<Void> {
    private TypeElement checkedElement;
    private boolean currentTypeIsProxy;
    private TypeElement domainElement;
    private boolean requireInstanceDomainMethods;
    private boolean requireStaticDomainMethods;

    DomainChecker() {
    }

    @Override
    public Void visitExecutable(ExecutableElement clientMethodElement, State state) {
        boolean isInstanceRequest;
        ExecutableElement domainMethod;
        TypeMirror returnType;
        if (this.shouldIgnore(clientMethodElement, state)) {
            return null;
        }
        Name name = clientMethodElement.getSimpleName();
        if (this.currentTypeIsProxy && name.contentEquals("stableId") && clientMethodElement.getParameters().isEmpty()) {
            return null;
        }
        ExecutableType clientMethod = DomainChecker.viewIn(this.checkedElement, clientMethodElement, state);
        ArrayList<TypeMirror> lookFor = new ArrayList<TypeMirror>();
        try {
            returnType = this.convertToDomainTypes(clientMethod, lookFor, clientMethodElement, state);
        }
        catch (ClientToDomainMapper.UnmappedTypeException e) {
            return null;
        }
        if (this.currentTypeIsProxy && this.isSetter(clientMethodElement, state)) {
            domainMethod = (ExecutableElement)new MethodFinder(name, state.types.getNoType(TypeKind.VOID), lookFor, false, state).scan((Element)this.domainElement, state);
            if (domainMethod == null) {
                domainMethod = (ExecutableElement)new MethodFinder(name, this.domainElement.asType(), lookFor, false, state).scan((Element)this.domainElement, state);
            }
        } else {
            domainMethod = (ExecutableElement)new MethodFinder(name, returnType, lookFor, !this.currentTypeIsProxy, state).scan((Element)this.domainElement, state);
        }
        if (domainMethod == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(returnType).append(" ").append(name).append("(");
            for (TypeMirror param : lookFor) {
                sb.append(param);
            }
            sb.append(")");
            state.poison(clientMethodElement, Messages.domainMissingMethod(sb));
            return null;
        }
        if (!domainMethod.getModifiers().contains((Object)Modifier.PUBLIC)) {
            state.poison(clientMethodElement, Messages.domainMethodNotPublic(domainMethod.getSimpleName()));
        }
        if (((isInstanceRequest = state.types.isSubtype(clientMethod.getReturnType(), state.instanceRequestType)) || this.requireInstanceDomainMethods) && domainMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            state.poison(clientMethodElement, Messages.domainMethodWrongModifier(false, domainMethod.getSimpleName()));
        }
        if (!isInstanceRequest && this.requireStaticDomainMethods && !domainMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            state.poison(clientMethodElement, Messages.domainMethodWrongModifier(true, domainMethod.getSimpleName()));
        }
        state.addMapping(clientMethodElement, domainMethod);
        return null;
    }

    @Override
    public Void visitType(TypeElement clientTypeElement, State state) {
        TypeMirror clientType = clientTypeElement.asType();
        this.checkedElement = clientTypeElement;
        boolean isEntityProxy = state.types.isSubtype(clientType, state.entityProxyType);
        this.currentTypeIsProxy = isEntityProxy || state.types.isSubtype(clientType, state.valueProxyType);
        this.domainElement = (TypeElement)state.getClientToDomainMap().get(clientTypeElement);
        if (this.domainElement == null) {
            return null;
        }
        this.requireInstanceDomainMethods = false;
        this.requireStaticDomainMethods = false;
        if (this.currentTypeIsProxy) {
            this.requireInstanceDomainMethods = true;
            if (!this.hasProxyLocator(clientTypeElement, state)) {
                if (!this.isDefaultInstantiable(this.domainElement)) {
                    state.warn(clientTypeElement, Messages.domainNotDefaultInstantiable(this.domainElement.getSimpleName(), clientTypeElement.getSimpleName(), state.requestContextType.asElement().getSimpleName()));
                }
                if (isEntityProxy && !state.types.isSameType(clientType, state.entityProxyType)) {
                    this.checkDomainEntityMethods(state);
                }
            }
        } else if (!this.hasServiceLocator(clientTypeElement, state)) {
            this.requireStaticDomainMethods = true;
        }
        this.scanAllInheritedMethods(clientTypeElement, state);
        return null;
    }

    private void checkDomainEntityMethods(State state) {
        ExecutableElement getId = (ExecutableElement)new MethodFinder("getId", null, Collections.<TypeMirror>emptyList(), false, state).scan((Element)this.domainElement, state);
        if (getId == null) {
            state.poison(this.checkedElement, Messages.domainNoGetId(this.domainElement.asType()));
        } else {
            ExecutableElement find;
            if (getId.getModifiers().contains((Object)Modifier.STATIC)) {
                state.poison(this.checkedElement, Messages.domainGetIdStatic());
            }
            if ((find = (ExecutableElement)new MethodFinder("find" + this.domainElement.getSimpleName(), this.domainElement.asType(), Collections.singletonList(getId.getReturnType()), false, state).scan((Element)this.domainElement, state)) == null) {
                state.warn(this.checkedElement, Messages.domainMissingFind(this.domainElement.asType(), this.domainElement.getSimpleName(), getId.getReturnType(), this.checkedElement.getSimpleName()));
            } else if (!find.getModifiers().contains((Object)Modifier.STATIC)) {
                state.poison(this.checkedElement, Messages.domainFindNotStatic(this.domainElement.getSimpleName()));
            }
        }
        ExecutableElement getVersion = (ExecutableElement)new MethodFinder("getVersion", null, Collections.<TypeMirror>emptyList(), false, state).scan((Element)this.domainElement, state);
        if (getVersion == null) {
            state.poison(this.checkedElement, Messages.domainNoGetVersion(this.domainElement.asType()));
        } else if (getVersion.getModifiers().contains((Object)Modifier.STATIC)) {
            state.poison(this.checkedElement, Messages.domainGetVersionStatic());
        }
    }

    private TypeMirror convertToDomainTypes(ExecutableType clientMethod, List<TypeMirror> parameterAccumulator, ExecutableElement warnTo, State state) throws ClientToDomainMapper.UnmappedTypeException {
        TypeMirror returnType;
        boolean error = false;
        try {
            returnType = clientMethod.getReturnType().accept(new ClientToDomainMapper(), state);
        }
        catch (ClientToDomainMapper.UnmappedTypeException e) {
            error = true;
            returnType = null;
            state.warn(warnTo, Messages.methodNoDomainPeer(e.getClientType(), false));
        }
        for (TypeMirror typeMirror : clientMethod.getParameterTypes()) {
            try {
                parameterAccumulator.add(typeMirror.accept(new ClientToDomainMapper(), state));
            }
            catch (ClientToDomainMapper.UnmappedTypeException e) {
                parameterAccumulator.add(null);
                error = true;
                state.warn(warnTo, Messages.methodNoDomainPeer(e.getClientType(), true));
            }
        }
        if (error) {
            throw new ClientToDomainMapper.UnmappedTypeException();
        }
        return returnType;
    }

    private boolean hasProxyLocator(TypeElement x, State state) {
        ProxyFor proxyFor = x.getAnnotation(ProxyFor.class);
        if (proxyFor != null) {
            try {
                proxyFor.locator();
                throw new RuntimeException("Should not reach here");
            }
            catch (MirroredTypeException expected) {
                TypeMirror locatorType = expected.getTypeMirror();
                return !state.types.asElement(locatorType).equals(state.locatorType.asElement());
            }
        }
        ProxyForName proxyForName = x.getAnnotation(ProxyForName.class);
        return proxyForName != null && !proxyForName.locator().isEmpty();
    }

    private boolean hasServiceLocator(TypeElement x, State state) {
        Service service = x.getAnnotation(Service.class);
        if (service != null) {
            try {
                service.locator();
                throw new RuntimeException("Should not reach here");
            }
            catch (MirroredTypeException expected) {
                TypeMirror locatorType = expected.getTypeMirror();
                return !state.types.asElement(locatorType).equals(state.serviceLocatorType.asElement());
            }
        }
        ServiceName serviceName = x.getAnnotation(ServiceName.class);
        return serviceName != null && !serviceName.locator().isEmpty();
    }

    private boolean isDefaultInstantiable(TypeElement x) {
        if (x.getKind() != ElementKind.CLASS) {
            return false;
        }
        if (x.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return false;
        }
        if (x.getNestingKind() == NestingKind.ANONYMOUS || x.getNestingKind() == NestingKind.LOCAL || x.getNestingKind() == NestingKind.MEMBER && !x.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(x.getEnclosedElements());
        if (constructors.isEmpty()) {
            return true;
        }
        for (ExecutableElement constructor : constructors) {
            if (!constructor.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    static class MethodFinder
    extends ScannerBase<ExecutableElement> {
        private TypeElement domainType;
        private ExecutableElement found;
        private final boolean boxReturnType;
        private final CharSequence name;
        private final TypeMirror returnType;
        private final List<TypeMirror> params;

        public MethodFinder(CharSequence name, TypeMirror returnType, List<TypeMirror> params, boolean boxReturnType, State state) {
            this.boxReturnType = boxReturnType;
            this.name = name;
            this.returnType = TypeSimplifier.simplify(returnType, boxReturnType, state);
            ArrayList<TypeMirror> temp = new ArrayList<TypeMirror>(params.size());
            for (TypeMirror param : params) {
                temp.add(TypeSimplifier.simplify(param, false, state));
            }
            this.params = Collections.unmodifiableList(temp);
        }

        @Override
        public ExecutableElement visitExecutable(ExecutableElement domainMethodElement, State state) {
            if (domainMethodElement.getSimpleName().contentEquals(this.name) && domainMethodElement.getParameters().size() == this.params.size()) {
                boolean returnTypeMatches;
                ExecutableType domainMethod = MethodFinder.viewIn(this.domainType, domainMethodElement, state);
                if (this.returnType == null) {
                    returnTypeMatches = true;
                } else {
                    TypeMirror domainReturn = TypeSimplifier.simplify(domainMethod.getReturnType(), this.boxReturnType, state);
                    returnTypeMatches = state.types.isSubtype(domainReturn, this.returnType);
                }
                if (returnTypeMatches) {
                    boolean paramsMatch = true;
                    Iterator<TypeMirror> lookFor = this.params.iterator();
                    Iterator<? extends TypeMirror> domainParam = domainMethod.getParameterTypes().iterator();
                    while (lookFor.hasNext()) {
                        TypeMirror paramType;
                        assert (domainParam.hasNext());
                        TypeMirror requestedType = lookFor.next();
                        if (state.types.isSubtype(requestedType, paramType = TypeSimplifier.simplify(domainParam.next(), false, state))) continue;
                        paramsMatch = false;
                    }
                    if (paramsMatch && (this.found == null || state.types.isSubsignature(domainMethod, (ExecutableType)this.found.asType()))) {
                        this.found = domainMethodElement;
                    }
                }
            }
            return this.found;
        }

        @Override
        public ExecutableElement visitType(TypeElement domainType, State state) {
            this.domainType = domainType;
            return (ExecutableElement)this.scanAllInheritedMethods(domainType, state);
        }
    }
}

