/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.maps.FindPlaceFromTextRequest;
import com.google.maps.GeoApiContext;
import com.google.maps.NearbySearchRequest;
import com.google.maps.PhotoRequest;
import com.google.maps.PlaceAutocompleteRequest;
import com.google.maps.PlaceDetailsRequest;
import com.google.maps.QueryAutocompleteRequest;
import com.google.maps.TextSearchRequest;
import com.google.maps.model.LatLng;

public class PlacesApi {
    private PlacesApi() {
    }

    public static NearbySearchRequest nearbySearchQuery(GeoApiContext context, LatLng location) {
        NearbySearchRequest request = new NearbySearchRequest(context);
        request.location(location);
        return request;
    }

    public static NearbySearchRequest nearbySearchNextPage(GeoApiContext context, String nextPageToken) {
        NearbySearchRequest request = new NearbySearchRequest(context);
        request.pageToken(nextPageToken);
        return request;
    }

    public static TextSearchRequest textSearchQuery(GeoApiContext context, String query) {
        TextSearchRequest request = new TextSearchRequest(context);
        request.query(query);
        return request;
    }

    public static TextSearchRequest textSearchNextPage(GeoApiContext context, String nextPageToken) {
        TextSearchRequest request = new TextSearchRequest(context);
        request.pageToken(nextPageToken);
        return request;
    }

    public static PlaceDetailsRequest placeDetails(GeoApiContext context, String placeId, PlaceAutocompleteRequest.SessionToken sessionToken) {
        PlaceDetailsRequest request = new PlaceDetailsRequest(context);
        request.placeId(placeId);
        request.sessionToken(sessionToken);
        return request;
    }

    public static PlaceDetailsRequest placeDetails(GeoApiContext context, String placeId) {
        PlaceDetailsRequest request = new PlaceDetailsRequest(context);
        request.placeId(placeId);
        return request;
    }

    public static PhotoRequest photo(GeoApiContext context, String photoReference) {
        PhotoRequest request = new PhotoRequest(context);
        request.photoReference(photoReference);
        return request;
    }

    public static PlaceAutocompleteRequest placeAutocomplete(GeoApiContext context, String input, PlaceAutocompleteRequest.SessionToken sessionToken) {
        PlaceAutocompleteRequest request = new PlaceAutocompleteRequest(context);
        request.input(input);
        request.sessionToken(sessionToken);
        return request;
    }

    public static QueryAutocompleteRequest queryAutocomplete(GeoApiContext context, String input) {
        QueryAutocompleteRequest request = new QueryAutocompleteRequest(context);
        request.input(input);
        return request;
    }

    public static FindPlaceFromTextRequest findPlaceFromText(GeoApiContext context, String input, FindPlaceFromTextRequest.InputType inputType) {
        FindPlaceFromTextRequest request = new FindPlaceFromTextRequest(context);
        request.input(input).inputType(inputType);
        return request;
    }
}

