/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss;

import com.google.gwt.resources.gss.ExtendedConditionalNodeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PermutationsCollector
extends ExtendedConditionalNodeVisitor
implements CssCompilerPass {
    static final Pattern IS_FUNCTION = Pattern.compile("^is\\(([\"'])((?:(?!\\1).)*)\\1(?:,([\"'])((?:(?!\\3).)*)\\3)?\\)$");
    private static final String USER_AGENT_PERMUTATION = "user.agent";
    private final MutatingVisitController delegate;
    private final Set<String> permutationAxesSet;

    public PermutationsCollector(MutatingVisitController delegate) {
        this.delegate = delegate;
        this.permutationAxesSet = new HashSet<String>();
    }

    @Override
    public void enterBooleanExpression(CssBooleanExpressionNode booleanExpressionNode) {
        Matcher m;
        if (booleanExpressionNode.getType() == CssBooleanExpressionNode.Type.CONSTANT && booleanExpressionNode.getValue() != null && (m = IS_FUNCTION.matcher(booleanExpressionNode.getValue())).matches()) {
            String permutationName = m.group(2);
            String permutationValue = m.group(4);
            if (permutationValue == null) {
                permutationValue = permutationName;
                permutationName = USER_AGENT_PERMUTATION;
            }
            String string = permutationName;
            String string2 = permutationValue;
            booleanExpressionNode.setValue(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(":").append(string2).toString());
            if (!this.permutationAxesSet.contains(permutationName)) {
                this.permutationAxesSet.add(permutationName);
            }
        }
    }

    public List<String> getPermutationAxes() {
        return ImmutableList.copyOf(this.permutationAxesSet);
    }

    public void runPass() {
        this.delegate.startVisit((CssTreeVisitor)this);
    }
}

