/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Log2;
import com.google.appengine.repackaged.com.google.common.base.Log2Logger;
import com.google.appengine.repackaged.com.google.common.logging.Logger;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.annotation.Nullable;

@Deprecated
@GoogleInternal
class LogWriter
implements Logger {
    private static final String LEVEL_IDS = "DIX";
    static final int DEFAULT_THRESHOLD = 0;
    private int threshold;
    SimpleDateFormat dateFormatter = null;
    Writer writer = null;
    private Logger javaLogger = null;
    ThreadLocal<String> threadTagMap = new ThreadLocal();

    LogWriter() {
    }

    public LogWriter(Writer writer) {
        this.writer = writer;
        this.dateFormatter = new SimpleDateFormat("yyMMdd HH:mm:ss.SSS");
        this.threshold = 0;
    }

    public void setThreshold(int level) {
        if (level < 0 || level > 3) {
            throw new RuntimeException("RotatingLog#setThreshold(int) : invalid threshold value: " + level);
        }
        this.threshold = level;
        if (this.javaLogger != null) {
            this.javaLogger.setThreshold(level);
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void logDebug(String msg) {
        if (this.javaLogger != null) {
            this.javaLogger.logDebug(msg);
        } else {
            this.write(0, msg);
        }
    }

    public void logEvent(String msg) {
        if (this.javaLogger != null) {
            this.javaLogger.logEvent(msg);
        } else {
            this.write(1, msg);
        }
    }

    public void logTimedEvent(String msg, long start, long end) {
        if (this.javaLogger != null) {
            this.javaLogger.logTimedEvent(msg, start, end);
        } else {
            this.write(1, end - start + " ms.: " + msg);
        }
    }

    public void setErrorEmail(String emailAddr) {
    }

    public void logException(Throwable t) {
        this.logException(t, "");
    }

    public void logException(Throwable t, String msg) {
        if (this.javaLogger != null) {
            this.javaLogger.logException(t, msg);
        } else {
            String errorMessage = t.getMessage();
            if (errorMessage != null) {
                msg = msg + ": " + errorMessage;
            }
            this.write(2, msg + "\n" + Log2.getExceptionTrace(t));
        }
    }

    public void logSevereException(Throwable t) {
        this.logSevereException(t, "");
    }

    public void logSevereException(Throwable t, String msg) {
        if (this.javaLogger != null) {
            this.javaLogger.logSevereException(t, msg);
        } else {
            String errorMessage = t.getMessage();
            if (errorMessage != null) {
                msg = msg + ": " + errorMessage;
            }
            this.write(2, msg + "\n" + Log2.getExceptionTrace(t));
        }
    }

    public void logError(String msg) {
        if (this.javaLogger != null) {
            this.javaLogger.logError(msg);
        } else {
            this.write(2, msg + "\n" + Log2.getExceptionTrace(new LoggedError()));
        }
    }

    protected synchronized void write(int level, String msg) {
        if (level < this.threshold) {
            return;
        }
        String threadTag = this.getThreadTag();
        threadTag = threadTag == null ? "" : threadTag + " ";
        int charPrefix = LEVEL_IDS.charAt(level);
        StringTokenizer tokenizer = new StringTokenizer(msg, "\n");
        StringBuffer sb = new StringBuffer(1000);
        while (tokenizer.hasMoreTokens()) {
            if (this.dateFormatter != null) {
                sb.append(this.dateFormatter.format(new Date()));
                sb.append(':');
            }
            sb.append((char)charPrefix);
            sb.append(' ');
            sb.append(threadTag);
            sb.append(tokenizer.nextToken());
            sb.append("\n");
            charPrefix = 32;
        }
        try {
            this.writer.write(sb.toString());
            this.writer.flush();
        }
        catch (IOException ioE) {
            System.err.println("LogWriter#write(int, String) : error in writing to log!\n Exception thrown: " + ioE.getMessage() + "\nlog entry: " + msg);
        }
    }

    public String getThreadTag() {
        if (this.javaLogger != null) {
            return this.javaLogger.getThreadTag();
        }
        return this.threadTagMap.get();
    }

    public void setThreadTag(String s) {
        if (this.javaLogger != null) {
            this.javaLogger.setThreadTag(s);
        } else {
            this.threadTagMap.set(s);
        }
    }

    public void close() {
        if (this.javaLogger != null) {
            this.javaLogger.close();
            return;
        }
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createAndSetJavaLogger(String fileName, String linkName, @Nullable String extension, DateFormat recordTsFormat, DateFormat fileNameTsFormat, long rotationSize) {
        this.javaLogger = new Log2Logger(fileName, linkName, extension, recordTsFormat, fileNameTsFormat, rotationSize);
        this.javaLogger.setThreshold(0);
    }

    static class LoggedError
    extends Throwable {
        private static final long serialVersionUID = 1L;

        LoggedError() {
        }
    }
}

