/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.enhancer;

import com.google.appengine.tools.info.SdkImplInfo;
import com.google.appengine.tools.info.SdkInfo;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancerLoader
extends URLClassLoader {
    public EnhancerLoader(Set<URL> enhanceTargets) {
        super(EnhancerLoader.getClassPath(enhanceTargets), (ClassLoader)null);
    }

    private static URL[] getClassPath(Set<URL> enhanceTargets) {
        Set<URL> newTargets = EnhancerLoader.removeOrmLibs(enhanceTargets, SdkImplInfo.getOrmToolLibs());
        HashSet<URL> libs = new HashSet<URL>(SdkInfo.getSharedLibs());
        libs.addAll(new HashSet<URL>(SdkImplInfo.getOrmToolLibs()));
        libs.addAll(newTargets);
        URL[] urls = new URL[libs.size()];
        return libs.toArray(urls);
    }

    private static Set<URL> removeOrmLibs(Set<URL> enhanceTargets, List<URL> ormLibs) {
        HashSet<URL> newTargets = new HashSet<URL>();
        block0: for (URL url : enhanceTargets) {
            String userFileName = EnhancerLoader.getFileName(url);
            for (URL ormUrl : ormLibs) {
                if (!userFileName.equals(EnhancerLoader.getFileName(ormUrl))) continue;
                continue block0;
            }
            newTargets.add(url);
        }
        return newTargets;
    }

    private static String getFileName(URL url) {
        String path = url.getPath();
        int trailingSlash = path.lastIndexOf(47);
        return path.substring(trailingSlash + 1);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("org.apache.log4j.")) {
            throw new ClassNotFoundException(name);
        }
        return super.loadClass(name, resolve);
    }
}

