/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.net.sourceforge.yamlbeans;

import com.google.appengine.repackaged.net.sourceforge.yamlbeans.Beans;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

class DeferredConstruction {
    private final Constructor constructor;
    private final String[] parameterNames;
    private final Object[] parameterValues;
    private final List<PropertyValue> propertyValues = new ArrayList<PropertyValue>(16);

    public DeferredConstruction(Constructor constructor, String[] stringArray) {
        this.constructor = constructor;
        this.parameterNames = stringArray;
        this.parameterValues = new Object[stringArray.length];
    }

    public Object construct() throws InvocationTargetException {
        try {
            Object t = this.constructor.newInstance(this.parameterValues);
            for (PropertyValue propertyValue : this.propertyValues) {
                propertyValue.property.set(t, propertyValue.value);
            }
            return t;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception, "Error constructing instance of class: " + this.constructor.getDeclaringClass().getName());
        }
    }

    public void storeProperty(Beans.Property property, Object object) {
        int n = 0;
        for (String string : this.parameterNames) {
            if (property.getName().equals(string)) {
                this.parameterValues[n] = object;
                return;
            }
            ++n;
        }
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.property = property;
        propertyValue.value = object;
        this.propertyValues.add(propertyValue);
    }

    private static class PropertyValue {
        private Beans.Property property;
        private Object value;

        private PropertyValue() {
        }
    }
}

