/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.users.dev;

import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.UserServicePb;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

@ServiceProvider(value=LocalRpcService.class)
public final class LocalUserService
extends AbstractLocalRpcService {
    private static final String LOGIN_URL = "/_ah/login";
    private static final String LOGOUT_URL = "/_ah/logout";
    public static final String OAUTH_CONSUMER_KEY_PROPERTY = "oauth.consumer_key";
    public static final String OAUTH_EMAIL_PROPERTY = "oauth.email";
    public static final String OAUTH_USER_ID_PROPERTY = "oauth.user_id";
    public static final String OAUTH_AUTH_DOMAIN_PROPERTY = "oauth.auth_domain";
    public static final String OAUTH_IS_ADMIN_PROPERTY = "oauth.is_admin";
    private String oauthConsumerKey = "example.com";
    private String oauthEmail = "example@example.com";
    private String oauthUserId = "0";
    private String oauthAuthDomain = "gmail.com";
    private boolean oauthIsAdmin = false;
    public static final String PACKAGE = "user";

    public UserServicePb.CreateLoginURLResponse createLoginURL(LocalRpcService.Status status, UserServicePb.CreateLoginURLRequest request) {
        UserServicePb.CreateLoginURLResponse response = new UserServicePb.CreateLoginURLResponse();
        response.setLoginUrl("/_ah/login?continue=" + LocalUserService.encode(request.getDestinationUrl()));
        return response;
    }

    public UserServicePb.CreateLogoutURLResponse createLogoutURL(LocalRpcService.Status status, UserServicePb.CreateLogoutURLRequest request) {
        UserServicePb.CreateLogoutURLResponse response = new UserServicePb.CreateLogoutURLResponse();
        response.setLogoutUrl("/_ah/logout?continue=" + LocalUserService.encode(request.getDestinationUrl()));
        return response;
    }

    public UserServicePb.CheckOAuthSignatureResponse checkOAuthSignature(LocalRpcService.Status status, UserServicePb.CheckOAuthSignatureRequest request) {
        UserServicePb.CheckOAuthSignatureResponse response = new UserServicePb.CheckOAuthSignatureResponse();
        response.setOauthConsumerKey(this.oauthConsumerKey);
        return response;
    }

    public UserServicePb.GetOAuthUserResponse getOAuthUser(LocalRpcService.Status status, UserServicePb.GetOAuthUserRequest request) {
        UserServicePb.GetOAuthUserResponse response = new UserServicePb.GetOAuthUserResponse();
        response.setEmail(this.oauthEmail);
        response.setUserId(this.oauthUserId);
        response.setAuthDomain(this.oauthAuthDomain);
        response.setIsAdmin(this.oauthIsAdmin);
        return response;
    }

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        String oauthIsAdminProp;
        String oauthAuthDomainProp;
        String oauthUserIdProp;
        String oauthEmailProp;
        String oauthConsumerKeyProp = properties.get(OAUTH_CONSUMER_KEY_PROPERTY);
        if (oauthConsumerKeyProp != null) {
            this.oauthConsumerKey = oauthConsumerKeyProp;
        }
        if ((oauthEmailProp = properties.get(OAUTH_EMAIL_PROPERTY)) != null) {
            this.oauthEmail = oauthEmailProp;
        }
        if ((oauthUserIdProp = properties.get(OAUTH_USER_ID_PROPERTY)) != null) {
            this.oauthUserId = oauthUserIdProp;
        }
        if ((oauthAuthDomainProp = properties.get(OAUTH_AUTH_DOMAIN_PROPERTY)) != null) {
            this.oauthAuthDomain = oauthAuthDomainProp;
        }
        if ((oauthIsAdminProp = properties.get(OAUTH_IS_ADMIN_PROPERTY)) != null) {
            this.oauthIsAdmin = Boolean.valueOf(oauthIsAdminProp);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    private static String encode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Could not find UTF-8 encoding", ex);
        }
    }
}

