/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.GeometricField;
import com.google.apphosting.api.AppEngineInternal;
import com.google.apphosting.api.search.DocumentPb;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.jsoup.Jsoup;

@AppEngineInternal
public final class LuceneUtils {
    public static final String FIELDLESS_FIELD_NAME = "_GLOBAL";
    static final String DOCID_FIELD_NAME = "_DOCID";
    static final String ALLDOCS_FIELD_NAME = "_ALLDOC";
    static final String LOCALE_FIELD_NAME = "_LOCALE";
    static final String ALLDOCS_FIELD_VALUE = "X";
    static final String ALLDOCS_FIELD_MISSING_VALUE = "Y";
    static final String ORDER_ID_FIELD_NAME = "_ORDERID";
    private static final Logger LOG = Logger.getLogger(LuceneUtils.class.getName());
    static final String CONVERTED_HTML_TYPE = "HTML2TEXT";
    public static final long MSEC_PER_DAY = 86400000L;
    private static final ThreadLocal<TimeZone> UTC_TZ = new ThreadLocal<TimeZone>(){

        @Override
        protected TimeZone initialValue() {
            return TimeZone.getTimeZone("UTC");
        }
    };
    private static final ThreadLocal<DateFormat> ISO8601_SIMPLE = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return LuceneUtils.getDateFormat("yyyy-MM-dd");
        }
    };

    private static DateFormat getDateFormat(String formatString) {
        SimpleDateFormat format = new SimpleDateFormat(formatString, Locale.US);
        format.setTimeZone(UTC_TZ.get());
        return format;
    }

    public static String makeLuceneFieldName(DocumentPb.Field field) {
        return LuceneUtils.makeLuceneFieldName(field.getName(), field.getValue().getType());
    }

    public static String makeLuceneFieldName(String name, DocumentPb.FieldValue.ContentType type) {
        return type + "@" + name;
    }

    public static String makeLuceneFieldNameWithExtractedText(String name, DocumentPb.FieldValue.ContentType type) {
        if (type == DocumentPb.FieldValue.ContentType.HTML) {
            return "HTML2TEXT@" + name;
        }
        return LuceneUtils.makeLuceneFieldName(name, type);
    }

    public static String makeLuceneFieldNameWithExtractedText(DocumentPb.Field field) {
        return LuceneUtils.makeLuceneFieldNameWithExtractedText(field.getName(), field.getValue().getType());
    }

    public static String extractTextFromHtml(String html) {
        return Jsoup.parse(html).body().text();
    }

    public static double stringValueToDouble(String value) {
        try {
            return NumberFormat.getNumberInstance().parse(value).doubleValue();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document toLuceneDocument(String docId, DocumentPb.Document input) {
        Document output = new Document();
        if (input.hasLanguage()) {
            output.add(new Field(LOCALE_FIELD_NAME, input.getLanguage(), Field.Store.YES, Field.Index.NO));
        }
        for (DocumentPb.Field field : input.getFieldList()) {
            DocumentPb.FieldValue fieldValue = field.getValue();
            Field.Index indexStrategy = Field.Index.ANALYZED;
            String fieldName = LuceneUtils.makeLuceneFieldName(field);
            String value = fieldValue.getStringValue();
            AbstractField luceneField = null;
            boolean makeGlobalField = true;
            switch (fieldValue.getType()) {
                case HTML: {
                    output.add(new Field(fieldName, value, Field.Store.YES, Field.Index.NOT_ANALYZED));
                    value = LuceneUtils.extractTextFromHtml(value);
                    luceneField = new Field(LuceneUtils.makeLuceneFieldNameWithExtractedText(field), value, Field.Store.YES, Field.Index.ANALYZED);
                    break;
                }
                case TEXT: {
                    break;
                }
                case ATOM: {
                    indexStrategy = Field.Index.NOT_ANALYZED;
                    value = value.toLowerCase();
                    break;
                }
                case DATE: {
                    NumericField dateField = new NumericField(fieldName, Field.Store.YES, true);
                    try {
                        long days = LuceneUtils.dateStringToLong(value) / 86400000L;
                        value = Long.toString(days);
                        dateField.setLongValue(days);
                    }
                    catch (ParseException e) {
                        LOG.warning("Failed to parse date for " + fieldName + ": " + value);
                        dateField.setLongValue(0L);
                    }
                    luceneField = dateField;
                    indexStrategy = Field.Index.NOT_ANALYZED;
                    break;
                }
                case NUMBER: {
                    NumericField numericField = new NumericField(fieldName, Field.Store.YES, true);
                    numericField.setDoubleValue(LuceneUtils.stringValueToDouble(value));
                    luceneField = numericField;
                    indexStrategy = Field.Index.NOT_ANALYZED;
                    break;
                }
                case GEO: {
                    luceneField = new GeometricField(fieldName, fieldValue.getGeo());
                    makeGlobalField = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Field type " + fieldValue.getType() + " not handled");
                }
            }
            if (luceneField == null) {
                luceneField = new Field(fieldName, value, Field.Store.YES, indexStrategy);
            }
            output.add(luceneField);
            if (!makeGlobalField) continue;
            output.add(new Field(FIELDLESS_FIELD_NAME, value, Field.Store.NO, indexStrategy));
        }
        output.add(new Field(ALLDOCS_FIELD_NAME, ALLDOCS_FIELD_VALUE, Field.Store.NO, Field.Index.NOT_ANALYZED));
        output.add(new Field(DOCID_FIELD_NAME, docId, Field.Store.YES, Field.Index.NOT_ANALYZED));
        output.add(new Field(ORDER_ID_FIELD_NAME, Integer.toString(input.getOrderId()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        return output;
    }

    public static Long dateStringToLong(String value) throws ParseException {
        try {
            return Long.parseLong(value);
        }
        catch (IllegalArgumentException exception) {
            return ISO8601_SIMPLE.get().parse(value).getTime();
        }
    }

    public static boolean isDateString(String value) {
        try {
            ISO8601_SIMPLE.get().parse(value);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static double numericFieldToDouble(Fieldable f) {
        if (f instanceof NumericField) {
            NumericField numericField = (NumericField)f;
            return numericField.getNumericValue().doubleValue();
        }
        return Double.parseDouble(f.stringValue());
    }

    public static Object luceneFieldToValue(Fieldable f, DocumentPb.FieldValue.ContentType type) {
        switch (type) {
            case HTML: 
            case TEXT: 
            case ATOM: {
                return ((Field)f).stringValue();
            }
            case DATE: {
                long value = f instanceof NumericField ? ((NumericField)f).getNumericValue().longValue() : Long.parseLong(f.stringValue());
                return Long.toString(value);
            }
            case NUMBER: {
                if (f instanceof NumericField) {
                    NumericField numericField = (NumericField)f;
                    return Double.toString(numericField.getNumericValue().doubleValue());
                }
                return f.stringValue();
            }
            case GEO: {
                LOG.warning("GeoPoints are not implemented on dev server.");
                return "";
            }
        }
        throw new IllegalArgumentException("Failed to correctly handle type " + type);
    }

    static DocumentPb.Document.Builder toAppengineDocumentIdBuilder(Document d) {
        String docId = ((Field)d.getFieldable(DOCID_FIELD_NAME)).stringValue();
        DocumentPb.Document.Builder docBuilder = DocumentPb.Document.newBuilder();
        docBuilder.setId(docId);
        return docBuilder;
    }

    public static DocumentPb.Document toAppengineDocumentId(Document d) {
        return LuceneUtils.toAppengineDocumentIdBuilder(d).build();
    }

    public static Query getMatchAnyDocumentQuery() {
        return new TermQuery(new Term(ALLDOCS_FIELD_NAME, ALLDOCS_FIELD_VALUE));
    }

    public static Query getMatchNoneQuery() {
        return new TermQuery(new Term(ALLDOCS_FIELD_NAME, ALLDOCS_FIELD_MISSING_VALUE));
    }

    public static Term newDeleteTerm(String docId) {
        return new Term(DOCID_FIELD_NAME, docId);
    }
}

