/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.dev.BlobInfoStorage;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

class MemoryBlobStorage
implements BlobStorage {
    private final Map<BlobKey, byte[]> blobContents = new HashMap<BlobKey, byte[]>();
    private final BlobInfoStorage blobInfoStorage;

    MemoryBlobStorage(BlobInfoStorage blobInfoStorage) {
        this.blobInfoStorage = blobInfoStorage;
    }

    @Override
    public boolean hasBlob(BlobKey blobKey) {
        return this.blobContents.containsKey(blobKey);
    }

    @Override
    public OutputStream storeBlob(final BlobKey blobKey) {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                MemoryBlobStorage.this.blobContents.put(blobKey, this.toByteArray());
            }
        };
    }

    @Override
    public InputStream fetchBlob(BlobKey blobKey) throws IOException {
        if (!this.blobContents.containsKey(blobKey)) {
            throw new FileNotFoundException("Could not find blob: " + blobKey);
        }
        return new ByteArrayInputStream(this.blobContents.get(blobKey));
    }

    @Override
    public void deleteBlob(BlobKey blobKey) {
        this.blobContents.remove(blobKey);
        this.blobInfoStorage.deleteBlobInfo(blobKey);
    }

    public void deleteAllBlobs() {
        this.blobContents.clear();
        this.blobInfoStorage.deleteAllBlobInfos();
    }
}

