/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.ru;

import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.ru.RussianCharsets;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.TermAttribute;
import java.io.IOException;

public final class RussianLowerCaseFilter
extends TokenFilter {
    char[] charset;
    private TermAttribute termAtt;

    public RussianLowerCaseFilter(TokenStream in, char[] charset) {
        super(in);
        this.charset = charset;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public RussianLowerCaseFilter(TokenStream in) {
        this(in, RussianCharsets.UnicodeRussian);
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] chArray = this.termAtt.termBuffer();
            int chLen = this.termAtt.termLength();
            for (int i = 0; i < chLen; ++i) {
                chArray[i] = RussianCharsets.toLowerCase(chArray[i], this.charset);
            }
            return true;
        }
        return false;
    }
}

