/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.R1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.R2Vector;
import java.io.Serializable;
import javax.annotation.CheckReturnValue;

@GwtCompatible(serializable=true)
strictfp final class R2Rect
implements Serializable {
    private final R1Interval x;
    private final R1Interval y;

    public R2Rect() {
        this.x = new R1Interval();
        this.y = new R1Interval();
    }

    public R2Rect(R2Vector lo, R2Vector hi) {
        this.x = new R1Interval(lo.x(), hi.x());
        this.y = new R1Interval(lo.y(), hi.y());
    }

    public R2Rect(R1Interval x, R1Interval y) {
        this.x = x;
        this.y = y;
    }

    public R2Rect(R2Rect rect) {
        this.x = new R1Interval(rect.x);
        this.y = new R1Interval(rect.y);
    }

    public static R2Rect empty() {
        return new R2Rect(R1Interval.empty(), R1Interval.empty());
    }

    public static R2Rect fromCenterSize(R2Vector center, R2Vector size) {
        return new R2Rect(new R1Interval(center.x() - 0.5 * size.x(), center.x() + 0.5 * size.x()), new R1Interval(center.y() - 0.5 * size.y(), center.y() + 0.5 * size.y()));
    }

    public static R2Rect fromPoint(R2Vector p) {
        return new R2Rect(p, p);
    }

    public static R2Rect fromPointPair(R2Vector p1, R2Vector p2) {
        return new R2Rect(R1Interval.fromPointPair(p1.x(), p2.x()), R1Interval.fromPointPair(p1.y(), p2.y()));
    }

    public R1Interval x() {
        return this.x;
    }

    public R1Interval y() {
        return this.y;
    }

    public R2Vector lo() {
        return new R2Vector(this.x().lo(), this.y().lo());
    }

    public R2Vector hi() {
        return new R2Vector(this.x().hi(), this.y().hi());
    }

    public boolean isValid() {
        return this.x().isEmpty() == this.y().isEmpty();
    }

    public boolean isEmpty() {
        return this.x().isEmpty();
    }

    public R2Vector getVertex(int k) {
        return this.getVertex(k >> 1 ^ k & 1, k >> 1);
    }

    public R2Vector getVertex(int i, int j) {
        return new R2Vector(i == 0 ? this.x.lo() : this.x.hi(), j == 0 ? this.y.lo() : this.y.hi());
    }

    public R2Vector getCenter() {
        return new R2Vector(this.x().getCenter(), this.y().getCenter());
    }

    public R2Vector getSize() {
        return new R2Vector(this.x().getLength(), this.y().getLength());
    }

    public R1Interval getInterval(Axis axis) {
        return axis.getInterval(this);
    }

    public boolean contains(R2Vector p) {
        return this.x().contains(p.x()) && this.y().contains(p.y());
    }

    public boolean interiorContains(R2Vector p) {
        return this.x().interiorContains(p.x()) && this.y().interiorContains(p.y());
    }

    public boolean contains(R2Rect other) {
        return this.x().contains(other.x()) && this.y().contains(other.y());
    }

    public boolean interiorContains(R2Rect other) {
        return this.x().interiorContains(other.x()) && this.y().interiorContains(other.y());
    }

    public boolean intersects(R2Rect other) {
        return this.x().intersects(other.x()) && this.y().intersects(other.y());
    }

    public boolean interiorIntersects(R2Rect other) {
        return this.x().interiorIntersects(other.x()) && this.y().interiorIntersects(other.y());
    }

    public void addPoint(R2Vector p) {
        this.x.unionInternal(p.x());
        this.y.unionInternal(p.y());
    }

    public void addRect(R2Rect other) {
        this.x.unionInternal(other.x);
        this.y.unionInternal(other.y);
    }

    public R2Vector clampPoint(R2Vector p) {
        return new R2Vector(this.x().clampPoint(p.x()), this.y().clampPoint(p.y()));
    }

    @CheckReturnValue
    public R2Rect expanded(R2Vector margin) {
        R1Interval xx = this.x().expanded(margin.x());
        R1Interval yy = this.y().expanded(margin.y());
        if (xx.isEmpty() || yy.isEmpty()) {
            return R2Rect.empty();
        }
        return new R2Rect(xx, yy);
    }

    @CheckReturnValue
    public R2Rect expanded(double margin) {
        return this.expanded(new R2Vector(margin, margin));
    }

    @CheckReturnValue
    public R2Rect union(R2Rect other) {
        return new R2Rect(this.x().union(other.x()), this.y().union(other.y()));
    }

    @CheckReturnValue
    public R2Rect intersection(R2Rect other) {
        R1Interval xx = this.x().intersection(other.x());
        R1Interval yy = this.y().intersection(other.y());
        if (xx.isEmpty() || yy.isEmpty()) {
            return R2Rect.empty();
        }
        return new R2Rect(xx, yy);
    }

    public int hashCode() {
        return this.x.hashCode() * 701 + this.y.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof R2Rect) {
            R2Rect r2 = (R2Rect)other;
            return this.x().equals(r2.x()) && this.y().equals(r2.y());
        }
        return false;
    }

    public boolean approxEquals(R2Rect other) {
        return this.approxEquals(other, 1.0E-15);
    }

    public boolean approxEquals(R2Rect other, double maxError) {
        return this.x().approxEquals(other.x(), maxError) && this.y().approxEquals(other.y(), maxError);
    }

    public String toString() {
        return "[Lo" + this.lo() + ", Hi" + this.hi() + "]";
    }

    public strictfp static enum Axis {
        X{

            @Override
            public R1Interval getInterval(R2Rect rect) {
                return rect.x;
            }
        }
        ,
        Y{

            @Override
            public R1Interval getInterval(R2Rect rect) {
                return rect.y;
            }
        };


        public abstract R1Interval getInterval(R2Rect var1);
    }
}

