/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.payloads;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.payloads.AveragePayloadFunction;
import org.apache.lucene.search.payloads.PayloadTermQuery;
import org.apache.lucene.search.spans.TermSpans;

public class BoostingTermQuery
extends PayloadTermQuery {
    public BoostingTermQuery(Term term) {
        this(term, true);
    }

    public BoostingTermQuery(Term term, boolean includeSpanScore) {
        super(term, new AveragePayloadFunction(), includeSpanScore);
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new BoostingTermWeight(this, searcher);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BoostingTermQuery)) {
            return false;
        }
        BoostingTermQuery other = (BoostingTermQuery)o;
        return this.getBoost() == other.getBoost() && this.term.equals(other.term);
    }

    protected class BoostingTermWeight
    extends PayloadTermQuery.PayloadTermWeight {
        public BoostingTermWeight(BoostingTermQuery query, Searcher searcher) throws IOException {
            super(query, searcher);
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return new PayloadTermQuery.PayloadTermWeight.PayloadTermSpanScorer((TermSpans)this.query.getSpans(reader), this, this.similarity, reader.norms(this.query.getField()));
        }
    }
}

