/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue.dev;

import com.google.appengine.api.labs.taskqueue.InternalFailureException;
import com.google.appengine.api.labs.taskqueue.QueueConstants;
import com.google.appengine.api.labs.taskqueue.TaskQueuePb;
import com.google.appengine.api.labs.taskqueue.dev.DevQueue;
import com.google.appengine.api.labs.taskqueue.dev.LocalTaskQueueCallback;
import com.google.appengine.api.labs.taskqueue.dev.QueueStateInfo;
import com.google.appengine.api.labs.taskqueue.dev.UrlFetchJob;
import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.api.urlfetch.dev.LocalURLFetchService;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.QueueXml;
import com.google.apphosting.utils.config.QueueXmlReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public final class LocalTaskQueue
implements LocalRpcService {
    private static final Logger logger = Logger.getLogger(LocalTaskQueue.class.getName());
    public static final String PACKAGE = "taskqueue";
    public static final String DISABLE_AUTO_TASK_EXEC_PROP = "task_queue.disable_auto_task_execution";
    public static final String QUEUE_XML_PATH_PROP = "task_queue.queue_xml_path";
    public static final String CALLBACK_CLASS_PROP = "task_queue.callback_class";
    private final Map<String, DevQueue> queues = Collections.synchronizedMap(new TreeMap());
    private final AtomicInteger taskNameGenerator = new AtomicInteger(0);
    private QueueXml queueXml;
    private Scheduler scheduler;
    private boolean disableAutoTaskExecution = false;
    private LocalServerEnvironment localServerEnvironment;
    private Clock clock;
    private LocalURLFetchService fetchService;
    private LocalTaskQueueCallback callback;

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.localServerEnvironment = context.getLocalServerEnvironment();
        this.clock = context.getClock();
        final String queueXmlPath = properties.get(QUEUE_XML_PATH_PROP);
        QueueXmlReader reader = queueXmlPath != null ? new QueueXmlReader(this.localServerEnvironment.getAppDir().getPath()){

            public String getFilename() {
                return queueXmlPath;
            }
        } : new QueueXmlReader(this.localServerEnvironment.getAppDir().getPath());
        this.queueXml = reader.readQueueXml();
        logger.log(Level.INFO, "LocalTaskQueue is initialized");
        if (Boolean.valueOf(properties.get(DISABLE_AUTO_TASK_EXEC_PROP)).booleanValue()) {
            this.disableAutoTaskExecution = true;
            logger.log(Level.INFO, "Automatic task execution is disabled.");
        }
        this.fetchService = new LocalURLFetchService();
        this.fetchService.init(null, new HashMap<String, String>());
        this.fetchService.setTimeoutInMs(30000);
        this.initializeCallback(properties);
    }

    private void initializeCallback(Map<String, String> properties) {
        String callbackOverrideClass = properties.get(CALLBACK_CLASS_PROP);
        if (callbackOverrideClass != null) {
            try {
                this.callback = (LocalTaskQueueCallback)Class.forName(callbackOverrideClass).newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.callback = new UrlFetchServiceLocalTaskQueueCallback(this.fetchService);
        }
    }

    void setQueueXml(QueueXml queueXml) {
        this.queueXml = queueXml;
    }

    public void start() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                LocalTaskQueue.this.start_();
                return null;
            }
        });
    }

    private void start_() {
        Thread shutdownHook = new Thread(){

            public void run() {
                LocalTaskQueue.this.stop();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        this.fetchService.start();
        UrlFetchJob.initialize(this.localServerEnvironment, this.clock);
        this.scheduler = LocalTaskQueue.startScheduler(this.disableAutoTaskExecution);
        String baseUrl = LocalTaskQueue.getBaseUrl(this.localServerEnvironment);
        if (this.queueXml != null) {
            for (QueueXml.Entry entry : this.queueXml.getEntries()) {
                this.queues.put(entry.getName(), new DevQueue(entry, this.taskNameGenerator, this.scheduler, baseUrl, this.clock, this.callback));
            }
        }
        if (this.queues.get("default") == null) {
            QueueXml.Entry entry = QueueXml.defaultEntry();
            this.queues.put(entry.getName(), new DevQueue(entry, this.taskNameGenerator, this.scheduler, baseUrl, this.clock, this.callback));
        }
        logger.info("Local task queue initialized with base url " + baseUrl);
    }

    static String getBaseUrl(LocalServerEnvironment localServerEnvironment) {
        return String.format("http://%s:%d", localServerEnvironment.getAddress(), localServerEnvironment.getPort());
    }

    public void stop() {
        this.queues.clear();
        LocalTaskQueue.stopScheduler(this.scheduler);
        this.fetchService.stop();
    }

    public String getPackage() {
        return PACKAGE;
    }

    private long currentTimeMillis() {
        return this.clock.getCurrentTime();
    }

    private long currentTimeUsec() {
        return this.currentTimeMillis() * 1000L;
    }

    TaskQueuePb.TaskQueueServiceError.ErrorCode validateAddRequest(TaskQueuePb.TaskQueueAddRequest addRequest) {
        String taskName = addRequest.getTaskName();
        if (taskName != null && taskName.length() != 0 && !QueueConstants.TASK_NAME_PATTERN.matcher(taskName).matches()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_TASK_NAME;
        }
        String queueName = addRequest.getQueueName();
        if (queueName == null || queueName.length() == 0 || !QueueConstants.QUEUE_NAME_PATTERN.matcher(queueName).matches()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_QUEUE_NAME;
        }
        String url = addRequest.getUrl();
        if (!addRequest.hasUrl() || url.length() == 0 || url.charAt(0) != '/' || url.length() > QueueConstants.maxUrlLength()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_URL;
        }
        if (addRequest.getEtaUsec() < 0L) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_ETA;
        }
        if (addRequest.getEtaUsec() - this.currentTimeUsec() > LocalTaskQueue.getMaxEtaDeltaUsec()) {
            return TaskQueuePb.TaskQueueServiceError.ErrorCode.INVALID_ETA;
        }
        return TaskQueuePb.TaskQueueServiceError.ErrorCode.OK;
    }

    static long getMaxEtaDeltaUsec() {
        return QueueConstants.getMaxEtaDeltaMillis() * 1000L;
    }

    public TaskQueuePb.TaskQueueAddResponse add(LocalRpcService.Status status, TaskQueuePb.TaskQueueAddRequest addRequest) {
        TaskQueuePb.TaskQueueBulkAddRequest bulkRequest = new TaskQueuePb.TaskQueueBulkAddRequest();
        TaskQueuePb.TaskQueueAddResponse addResponse = new TaskQueuePb.TaskQueueAddResponse();
        bulkRequest.addAddRequest().copyFrom((ProtocolMessage)addRequest);
        TaskQueuePb.TaskQueueBulkAddResponse bulkResponse = this.bulkAdd(status, bulkRequest);
        if (bulkResponse.taskResultSize() != 1) {
            throw new InternalFailureException(String.format("expected 1 result from BulkAdd(), got %d", bulkResponse.taskResultSize()));
        }
        int result = bulkResponse.getTaskResult(0).getResult();
        if (result != TaskQueuePb.TaskQueueServiceError.ErrorCode.OK.getValue()) {
            throw new ApiProxy.ApplicationException(result);
        }
        if (bulkResponse.getTaskResult(0).hasChosenTaskName()) {
            addResponse.setChosenTaskName(bulkResponse.getTaskResult(0).getChosenTaskName());
        }
        return addResponse;
    }

    public TaskQueuePb.TaskQueueBulkAddResponse bulkAdd(LocalRpcService.Status status, TaskQueuePb.TaskQueueBulkAddRequest bulkAddRequest) {
        TaskQueuePb.TaskQueueBulkAddResponse.TaskResult taskResult;
        TaskQueuePb.TaskQueueBulkAddResponse bulkAddResponse = new TaskQueuePb.TaskQueueBulkAddResponse();
        if (bulkAddRequest.addRequestSize() == 0) {
            return bulkAddResponse;
        }
        bulkAddRequest = (TaskQueuePb.TaskQueueBulkAddRequest)bulkAddRequest.clone();
        DevQueue queue = this.getQueueByName(bulkAddRequest.getAddRequest(0).getQueueName());
        IdentityHashMap<TaskQueuePb.TaskQueueBulkAddResponse.TaskResult, String> chosenNames = new IdentityHashMap<TaskQueuePb.TaskQueueBulkAddResponse.TaskResult, String>();
        boolean errorFound = false;
        for (TaskQueuePb.TaskQueueAddRequest addRequest : bulkAddRequest.addRequests()) {
            taskResult = bulkAddResponse.addTaskResult();
            TaskQueuePb.TaskQueueServiceError.ErrorCode error = this.validateAddRequest(addRequest);
            if (error == TaskQueuePb.TaskQueueServiceError.ErrorCode.OK) {
                if (!addRequest.hasTaskName() || addRequest.getTaskName().equals("")) {
                    addRequest = addRequest.setTaskName(queue.genTaskName());
                    chosenNames.put(taskResult, addRequest.getTaskName());
                }
                taskResult.setResult(TaskQueuePb.TaskQueueServiceError.ErrorCode.SKIPPED.getValue());
                continue;
            }
            taskResult.setResult(error.getValue());
            errorFound = true;
        }
        if (errorFound) {
            return bulkAddResponse;
        }
        if (bulkAddRequest.getAddRequest(0).hasTransaction()) {
            try {
                ApiProxy.makeSyncCall((String)"datastore_v3", (String)"addActions", (byte[])bulkAddRequest.toByteArray());
            }
            catch (ApiProxy.ApplicationException exception) {
                throw new ApiProxy.ApplicationException(exception.getApplicationError() + TaskQueuePb.TaskQueueServiceError.ErrorCode.DATASTORE_ERROR.getValue(), exception.getErrorDetail());
            }
        } else {
            for (int i = 0; i < bulkAddRequest.addRequestSize(); ++i) {
                TaskQueuePb.TaskQueueAddRequest addRequest;
                addRequest = bulkAddRequest.getAddRequest(i);
                taskResult = bulkAddResponse.getTaskResult(i);
                try {
                    queue.add(addRequest);
                    continue;
                }
                catch (ApiProxy.ApplicationException exception) {
                    taskResult.setResult(exception.getApplicationError());
                }
            }
        }
        for (TaskQueuePb.TaskQueueBulkAddResponse.TaskResult taskResult2 : bulkAddResponse.taskResults()) {
            if (taskResult2.getResult() != TaskQueuePb.TaskQueueServiceError.ErrorCode.SKIPPED.getValue()) continue;
            taskResult2.setResult(TaskQueuePb.TaskQueueServiceError.ErrorCode.OK.getValue());
            if (!chosenNames.containsKey(taskResult2)) continue;
            taskResult2.setChosenTaskName((String)chosenNames.get(taskResult2));
        }
        return bulkAddResponse;
    }

    public Map<String, QueueStateInfo> getQueueStateInfo() {
        TreeMap<String, QueueStateInfo> queueStateInfo = new TreeMap<String, QueueStateInfo>();
        for (Map.Entry<String, DevQueue> entry : this.queues.entrySet()) {
            String queueName = entry.getKey();
            queueStateInfo.put(queueName, entry.getValue().getStateInfo());
        }
        return queueStateInfo;
    }

    private DevQueue getQueueByName(String queueName) {
        DevQueue queue = this.queues.get(queueName);
        if (queue == null) {
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.UNKNOWN_QUEUE.getValue(), queueName);
        }
        return queue;
    }

    public void flushQueue(String queueName) {
        DevQueue queue = this.getQueueByName(queueName);
        queue.flush();
    }

    public boolean deleteTask(String queueName, String taskName) {
        DevQueue queue = this.getQueueByName(queueName);
        return queue.deleteTask(taskName);
    }

    static Scheduler startScheduler(boolean disableAutoTaskExecution) {
        try {
            Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
            if (!disableAutoTaskExecution) {
                scheduler.start();
            }
            return scheduler;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    static void stopScheduler(Scheduler scheduler) {
        try {
            scheduler.shutdown(false);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean runTask(String queueName, String taskName) {
        DevQueue queue = this.getQueueByName(queueName);
        return queue.runTask(taskName);
    }

    static final class UrlFetchServiceLocalTaskQueueCallback
    implements LocalTaskQueueCallback {
        private final LocalURLFetchService fetchService;

        UrlFetchServiceLocalTaskQueueCallback(LocalURLFetchService fetchService) {
            this.fetchService = fetchService;
        }

        public int execute(URLFetchServicePb.URLFetchRequest fetchReq) {
            LocalRpcService.Status status = new LocalRpcService.Status();
            return this.fetchService.fetch(status, fetchReq).getStatusCode();
        }
    }
}

