/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images.dev;

import com.google.appengine.api.images.ImagesServicePb;
import com.google.appengine.api.images.dev.LocalImagesService;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.apphosting.api.ApiProxy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class LocalBlobImageServlet
extends HttpServlet {
    private LocalImagesService imagesService;

    public void init() throws ServletException {
        super.init();
        ApiProxyLocal local = (ApiProxyLocal)ApiProxy.getDelegate();
        this.imagesService = (LocalImagesService)local.getService("images");
        this.imagesService.init(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            ServletOutputStream out = resp.getOutputStream();
            try {
                ParsedUrl parsedUrl = ParsedUrl.createParsedUrl(req.getRequestURI());
                byte[] image = this.transformImage(parsedUrl);
                resp.setContentType("image/jpeg");
                out.write(image);
            }
            finally {
                out.close();
            }
        }
        catch (ApiProxy.ApplicationException e) {
            ImagesServicePb.ImagesServiceError.ErrorCode code = ImagesServicePb.ImagesServiceError.ErrorCode.valueOf((int)e.getApplicationError());
            if (code == null) {
                code = ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR;
            }
            switch (code) {
                case NOT_IMAGE: 
                case INVALID_BLOB_KEY: {
                    resp.sendError(404, e.getMessage());
                    break;
                }
                default: {
                    resp.sendError(500, e.getMessage());
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            resp.sendError(500, e.getMessage());
        }
        catch (IOException e) {
            resp.sendError(500, e.getMessage());
        }
    }

    protected byte[] transformImage(final ParsedUrl request) {
        return AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                LocalRpcService.Status unusedStatus = new LocalRpcService.Status();
                BufferedImage img = LocalBlobImageServlet.this.imagesService.openImage(new ImagesServicePb.ImageData().setBlobKey(request.getBlobKey()), unusedStatus);
                if (request.hasOptions()) {
                    if (request.getCrop()) {
                        float height;
                        ImagesServicePb.Transform cropXform = null;
                        float width = img.getWidth();
                        if (width > (height = (float)img.getHeight())) {
                            cropXform = new ImagesServicePb.Transform();
                            float delta = (width - height) / (width * 2.0f);
                            cropXform.setCropLeftX(delta);
                            cropXform.setCropRightX(1.0f - delta);
                        } else if (width < height) {
                            cropXform = new ImagesServicePb.Transform();
                            float delta = (height - width) / (height * 2.0f);
                            float topDelta = Math.max(0.0f, delta - 0.25f);
                            float bottomDelta = 1.0f - 2.0f * delta + topDelta;
                            cropXform.setCropTopY(topDelta);
                            cropXform.setCropBottomY(bottomDelta);
                        }
                        if (cropXform != null) {
                            img = LocalBlobImageServlet.this.imagesService.processTransform(img, cropXform, unusedStatus);
                        }
                    }
                    ImagesServicePb.Transform resizeXform = new ImagesServicePb.Transform().setWidth(request.getResize()).setHeight(request.getResize());
                    img = LocalBlobImageServlet.this.imagesService.processTransform(img, resizeXform, unusedStatus);
                }
                return LocalBlobImageServlet.this.imagesService.saveImage(img, ImagesServicePb.OutputSettings.MIME_TYPE.JPEG, unusedStatus);
            }
        });
    }

    protected static class ParsedUrl {
        private String blobKey;
        private String options;
        private int resize;
        private boolean crop;
        private static final Pattern pattern = Pattern.compile("/_ah/img/([-\\w]+)(=[-\\w]+)?");
        private static final Pattern optionsPattern = Pattern.compile("^s(\\d+)(-c)?");
        private static final Set<Integer> croppedSizes = ImmutableSet.of((Object)32, (Object)48, (Object)64, (Object)72, (Object)80, (Object)104, (Object[])new Integer[]{136, 144, 150, 160});
        private static final Set<Integer> uncroppedSizes = ImmutableSet.of((Object)0, (Object)32, (Object)48, (Object)64, (Object)72, (Object)80, (Object[])new Integer[]{90, 94, 104, 110, 120, 128, 144, 150, 160, 200, 220, 288, 320, 400, 512, 576, 640, 720, 800, 912, 1024, 1152, 1280, 1440, 1600});

        public boolean hasOptions() {
            return this.options != null && this.options.length() != 0;
        }

        public String getBlobKey() {
            return this.blobKey;
        }

        public int getResize() {
            return this.resize;
        }

        public boolean getCrop() {
            return this.crop;
        }

        protected static ParsedUrl createParsedUrl(String requestUri) {
            ParsedUrl parsedUrl = new ParsedUrl();
            parsedUrl.parse(requestUri);
            return parsedUrl;
        }

        protected void parse(String requestUri) {
            Matcher matcher = pattern.matcher(requestUri);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Malformed URL.");
            }
            this.blobKey = matcher.group(1);
            this.options = matcher.group(2);
            if (this.options != null && this.options.startsWith("=")) {
                this.options = this.options.substring(1);
            }
            this.parseOptions();
        }

        protected void parseOptions() {
            try {
                if (!this.hasOptions()) {
                    return;
                }
                Matcher matcher = optionsPattern.matcher(this.options);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Malformed URL Options");
                }
                this.resize = Integer.parseInt(matcher.group(1));
                this.crop = false;
                if (matcher.group(2) != null) {
                    this.crop = true;
                }
                if (this.crop && !croppedSizes.contains(this.resize)) {
                    throw new IllegalArgumentException("Invalid crop size");
                }
                if (!this.crop && !uncroppedSizes.contains(this.resize)) {
                    throw new IllegalArgumentException("Invalid resize");
                }
            }
            catch (NumberFormatException e) {
                this.options = null;
                throw new IllegalArgumentException("Invalid resize", e);
            }
        }

        private ParsedUrl() {
        }
    }
}

