/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.base.shell;

import com.google.appengine.repackaged.com.google.io.base.InputStreamSink;
import com.google.appengine.repackaged.com.google.io.base.shell.CommandResult;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

class Consumers {
    private static final Logger log = Logger.getLogger("com.google.appengine.repackaged.com.google.io.base.shell.Command");
    private static final ExecutorService pool = Executors.newCachedThreadPool(new AccumulatorThreadFactory());

    private Consumers() {
    }

    static OutErrConsumers createDiscardingConsumers() {
        return new OutErrConsumers(new DiscardingConsumer(), new DiscardingConsumer());
    }

    static OutErrConsumers createAccumulatingConsumers() {
        return new OutErrConsumers(new AccumulatingConsumer(), new AccumulatingConsumer());
    }

    static OutErrConsumers createStreamingConsumers(OutputStream out, OutputStream err) {
        return new OutErrConsumers(new StreamingConsumer(out), new StreamingConsumer(err));
    }

    private static void silentClose(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException ioe) {
            String message = "Unexpected exception while closing input stream";
            log.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.io.base.shell.Consumers", "silentClose", message, ioe);
        }
    }

    private static class ClosingSink
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;
        private final Runnable sink;
        private final boolean close;

        ClosingSink(InputStream in, OutputStream out) {
            this(in, out, false);
        }

        ClosingSink(InputStream in) {
            this.sink = InputStreamSink.newRunnableSink(in);
            this.in = in;
            this.close = false;
            this.out = null;
        }

        ClosingSink(InputStream in, OutputStream out, boolean close) {
            this.sink = InputStreamSink.newRunnableSink(in, out);
            this.in = in;
            this.out = out;
            this.close = close;
        }

        @Override
        public void run() {
            try {
                this.sink.run();
            }
            finally {
                Consumers.silentClose(this.in);
                if (this.close && this.out != null) {
                    Consumers.silentClose(this.out);
                }
            }
        }
    }

    private static class AccumulatorThreadFactory
    implements ThreadFactory {
        private static final int THREAD_STACK_SIZE = 114688;
        private static AtomicInteger threadInitNumber = new AtomicInteger(0);

        private AccumulatorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            int n = threadInitNumber.getAndIncrement();
            Thread t = new Thread(null, runnable, new StringBuilder(38).append("Command-Accumulator-Thread-").append(n).toString(), 114688L);
            t.setDaemon(true);
            return t;
        }
    }

    private static abstract class FutureConsumption {
        private Future<?> future;

        private FutureConsumption() {
        }

        public void registerInput(InputStream in, boolean closeConsumer) {
            Runnable sink = this.createConsumingAndClosingSink(in, closeConsumer);
            this.future = pool.submit(sink);
        }

        protected abstract Runnable createConsumingAndClosingSink(InputStream var1, boolean var2);

        public void cancel() {
            this.future.cancel(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCompletion() throws IOException {
            boolean wasInterrupted = false;
            try {
                while (true) {
                    try {
                        this.future.get();
                    }
                    catch (InterruptedException ie) {
                        wasInterrupted = true;
                        continue;
                    }
                    catch (ExecutionException ee) {
                        Throwable nested = ee.getCause();
                        if (nested instanceof RuntimeException) {
                            RuntimeException re = (RuntimeException)nested;
                            Throwable cause = re.getCause();
                            if (cause instanceof IOException) {
                                throw (IOException)cause;
                            }
                            throw re;
                        }
                        if (nested instanceof OutOfMemoryError) {
                            throw (OutOfMemoryError)nested;
                        }
                        if (nested instanceof Error) {
                            throw new Error("unhandled Error in worker thread", ee);
                        }
                        throw new RuntimeException("unknown execution problem", ee);
                    }
                    break;
                }
            }
            finally {
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static class DiscardingConsumer
    extends FutureConsumption
    implements OutputConsumer {
        private DiscardingConsumer() {
        }

        @Override
        public ByteArrayOutputStream getAccumulatedOut() {
            return CommandResult.NO_OUTPUT_COLLECTED;
        }

        @Override
        public void logConsumptionStrategy() {
            log.logp(Level.FINER, "com.google.appengine.repackaged.com.google.io.base.shell.Consumers$DiscardingConsumer", "logConsumptionStrategy", "Output will be ignored");
        }

        @Override
        public Runnable createConsumingAndClosingSink(InputStream in, boolean closeConsumer) {
            return new ClosingSink(in);
        }
    }

    private static class AccumulatingConsumer
    extends FutureConsumption
    implements OutputConsumer {
        private ByteArrayOutputStream out = new ByteArrayOutputStream();

        private AccumulatingConsumer() {
        }

        @Override
        public ByteArrayOutputStream getAccumulatedOut() {
            return this.out;
        }

        @Override
        public void logConsumptionStrategy() {
            log.logp(Level.FINER, "com.google.appengine.repackaged.com.google.io.base.shell.Consumers$AccumulatingConsumer", "logConsumptionStrategy", "Output will be accumulated (promptly read off) and returned");
        }

        @Override
        public Runnable createConsumingAndClosingSink(InputStream in, boolean closeConsumer) {
            return new ClosingSink(in, this.out);
        }
    }

    private static class StreamingConsumer
    extends FutureConsumption
    implements OutputConsumer {
        private OutputStream out;

        StreamingConsumer(OutputStream out) {
            this.out = out;
        }

        @Override
        public ByteArrayOutputStream getAccumulatedOut() {
            return CommandResult.NO_OUTPUT_COLLECTED;
        }

        @Override
        public void logConsumptionStrategy() {
            log.logp(Level.FINER, "com.google.appengine.repackaged.com.google.io.base.shell.Consumers$StreamingConsumer", "logConsumptionStrategy", "Output will be sent to streams provided by client");
        }

        @Override
        protected Runnable createConsumingAndClosingSink(InputStream in, boolean closeConsumer) {
            return new ClosingSink(in, this.out, closeConsumer);
        }
    }

    private static interface OutputConsumer {
        public ByteArrayOutputStream getAccumulatedOut();

        public void logConsumptionStrategy();

        public void registerInput(InputStream var1, boolean var2);

        public void cancel();

        public void waitForCompletion() throws IOException;
    }

    static class OutErrConsumers {
        private final OutputConsumer out;
        private final OutputConsumer err;

        private OutErrConsumers(OutputConsumer out, OutputConsumer err) {
            this.out = out;
            this.err = err;
        }

        void registerInputs(InputStream outInput, InputStream errInput, boolean closeStreams) {
            this.out.registerInput(outInput, closeStreams);
            this.err.registerInput(errInput, closeStreams);
        }

        void cancel() {
            this.out.cancel();
            this.err.cancel();
        }

        void waitForCompletion() throws IOException {
            this.out.waitForCompletion();
            this.err.waitForCompletion();
        }

        ByteArrayOutputStream getAccumulatedOut() {
            return this.out.getAccumulatedOut();
        }

        ByteArrayOutputStream getAccumulatedErr() {
            return this.err.getAccumulatedOut();
        }

        void logConsumptionStrategy() {
            this.out.logConsumptionStrategy();
        }
    }
}

