/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.util.concurrent.RateLimiter;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Uninterruptibles;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

@CanIgnoreReturnValue
@GoogleInternal
@GwtIncompatible
public final class ManualRateLimiter
extends RateLimiter {
    private static final RateLimiter.SleepingStopwatch THROWING_STOPWATCH = new RateLimiter.SleepingStopwatch(){

        @Override
        protected void sleepMicrosUninterruptibly(long micros) {
            throw new AssertionError();
        }

        @Override
        protected long readMicros() {
            throw new UnsupportedOperationException();
        }
    };
    private final Semaphore callsToProceed = new Semaphore(0, true);

    public ManualRateLimiter() {
        super(THROWING_STOPWATCH);
    }

    public void release(int permits) {
        this.callsToProceed.release(permits);
    }

    @Override
    public double acquire(int permits) {
        this.callsToProceed.acquireUninterruptibly(permits);
        return 1.0;
    }

    @Override
    public boolean couldAcquire() {
        return this.callsToProceed.availablePermits() > 0;
    }

    @Override
    public int getAvailablePermits() {
        return this.callsToProceed.availablePermits();
    }

    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
        Preconditions.checkArgument(timeout <= 0L, "ManualRateLimiter does not support blocking tryAcquire(); see class-level Javadoc");
        Preconditions.checkNotNull(unit);
        return Uninterruptibles.tryAcquireUninterruptibly(this.callsToProceed, permits, 0L, TimeUnit.SECONDS);
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) {
        return super.tryAcquire(timeout, unit);
    }

    @Override
    void doSetRate(double permitsPerSecond, long nowMicros) {
        throw new UnsupportedOperationException();
    }

    @Override
    double doGetRate() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean supportsAsync() {
        return false;
    }

    @Override
    long queryEarliestAvailable(long nowMicros) {
        throw new AssertionError();
    }

    @Override
    long reserveEarliestAvailable(int permits, long nowMicros) {
        throw new AssertionError();
    }
}

