/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app.filter;

import com.google.api.services.datastore.DatastoreV1;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.app.filter.ApiAnnotations;
import com.google.apphosting.client.datastoreservice.app.filter.DummyServletInputStream;
import com.google.apphosting.client.datastoreservice.app.filter.DummyServletOutputStream;
import com.google.apphosting.client.datastoreservice.app.filter.ProtoJsonConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public final class ProtoJsonFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(ProtoJsonFilter.class.getName());
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String PROTOBUF_CONTENT_TYPE = "application/x-protobuf";
    private static final String DATASTORE_SERVICE = "DatastoreService";
    private static final String DATASTOREV1_CLASS_PREFIX = "com.google.api.services.datastore.DatastoreV1$";
    private final ProtoJsonConverter protoJsonConverter;
    private final ApiAnnotations protoAnnotations;
    private final Map<String, ApiAnnotations.ProtoMethodDescriptor> serviceMethods;

    public ProtoJsonFilter() throws IOException {
        InputStream annotationStream = ProtoJsonFilter.class.getResourceAsStream("/apphosting/client/datastoreservice/proto/datastore_v1.json");
        if (annotationStream == null) {
            throw new RuntimeException("api annotations not found in resources");
        }
        this.protoAnnotations = ApiAnnotations.read((InputStream)annotationStream);
        ApiAnnotations.ProtoRegistry protoRegistry = new ApiAnnotations.ProtoRegistry(DatastoreV1.getDescriptor());
        this.protoJsonConverter = new ProtoJsonConverter(this.protoAnnotations, protoRegistry);
        this.serviceMethods = this.protoAnnotations.getServiceDescriptors(DATASTORE_SERVICE, protoRegistry, DATASTOREV1_CLASS_PREFIX);
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }

    private <T extends MessageLite, U extends MessageLite> void handleJsonRequest(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Class<T> requestClass, Parser<U> responseParser) throws IOException, ServletException {
        MessageLite protoRequest = this.protoJsonConverter.readJsonRequest((InputStream)request.getInputStream(), requestClass);
        if (protoRequest == null) {
            response.sendError(400, String.format("unable to decode request of type: \"%s\"", requestClass.getName()));
            return;
        }
        RequestWrapper requestWrapper = new RequestWrapper(request, new ByteArrayInputStream(protoRequest.toByteArray()));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ResponseWrapper responseWrapper = new ResponseWrapper(response, outputStream);
        chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        response.setContentType(JSON_CONTENT_TYPE);
        this.protoJsonConverter.writeJsonResponse((OutputStream)response.getOutputStream(), (MessageLite)responseParser.parseFrom(outputStream.toByteArray()));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        String contentType = httpRequest.getContentType();
        if (JSON_CONTENT_TYPE.equals(contentType)) {
            String requestURI = httpRequest.getRequestURI();
            String methodName = requestURI.substring(requestURI.lastIndexOf("/") + 1);
            ApiAnnotations.ProtoMethodDescriptor method = this.serviceMethods.get(methodName);
            if (method == null) {
                httpResponse.sendError(404, String.format("service method not found: \"%s\"", methodName));
                return;
            }
            this.handleJsonRequest(httpRequest, httpResponse, chain, method.getRequestClass(), method.getResponseParser());
        } else {
            chain.doFilter(servletRequest, servletResponse);
        }
    }

    private static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private final DummyServletOutputStream outputStream;
        private String contentType;

        public ResponseWrapper(HttpServletResponse httpResponse, ByteArrayOutputStream outputStream) {
            super(httpResponse);
            this.outputStream = new DummyServletOutputStream(outputStream);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.outputStream;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }
    }

    private static class RequestWrapper
    extends HttpServletRequestWrapper {
        private final DummyServletInputStream inputStream;

        public RequestWrapper(HttpServletRequest httpRequest, ByteArrayInputStream inputStream) throws IOException {
            super(httpRequest);
            this.inputStream = new DummyServletInputStream(inputStream);
        }

        public ServletInputStream getInputStream() {
            return this.inputStream;
        }

        public String getContentType() {
            return ProtoJsonFilter.PROTOBUF_CONTENT_TYPE;
        }
    }
}

