/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.datastore.DatastoreV4;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class InternDatastoreRpcService {
    static final ImmutableMap<Integer, Codes.Code> CANONICAL_ERROR_MAPPING = ImmutableMap.builder().put(DatastoreV4.Error.ErrorCode.BAD_REQUEST.getNumber(), Codes.Code.INVALID_ARGUMENT).put(DatastoreV4.Error.ErrorCode.CONCURRENT_TRANSACTION.getNumber(), Codes.Code.ABORTED).put(DatastoreV4.Error.ErrorCode.INTERNAL_ERROR.getNumber(), Codes.Code.INTERNAL).put(DatastoreV4.Error.ErrorCode.NEED_INDEX.getNumber(), Codes.Code.FAILED_PRECONDITION).put(DatastoreV4.Error.ErrorCode.TIMEOUT.getNumber(), Codes.Code.DEADLINE_EXCEEDED).put(DatastoreV4.Error.ErrorCode.PERMISSION_DENIED.getNumber(), Codes.Code.PERMISSION_DENIED).put(DatastoreV4.Error.ErrorCode.BIGTABLE_ERROR.getNumber(), Codes.Code.DEADLINE_EXCEEDED).put(DatastoreV4.Error.ErrorCode.COMMITTED_BUT_STILL_APPLYING.getNumber(), Codes.Code.INTERNAL).put(DatastoreV4.Error.ErrorCode.CAPABILITY_DISABLED.getNumber(), Codes.Code.UNAVAILABLE).put(DatastoreV4.Error.ErrorCode.TRY_ALTERNATE_BACKEND.getNumber(), Codes.Code.UNAVAILABLE).put(DatastoreV4.Error.ErrorCode.SAFE_TIME_TOO_OLD.getNumber(), Codes.Code.FAILED_PRECONDITION).put(90000, Codes.Code.DEADLINE_EXCEEDED).put(90001, Codes.Code.INTERNAL).put(90002, Codes.Code.INTERNAL).build();

    static Codes.Code getCanonicalCodeForAppError(int appCode) {
        Codes.Code code = CANONICAL_ERROR_MAPPING.get(appCode);
        if (code != null) {
            return code;
        }
        return Codes.Code.UNKNOWN;
    }

    public static <S extends MessageLite> RpcSpec<S> createRpcSpec(String packageName, String methodName, Parser<S> responseParser) {
        return new RpcSpec<S>(packageName, methodName, responseParser);
    }

    public <R extends MessageLite, S extends MessageLite> ResponseFutureWrapper<S> call(RpcSpec<S> rpcSpec, R request) {
        return new ResponseFutureWrapper(rpcSpec.responseParser, ApiProxy.makeAsyncCall(rpcSpec.packageName, rpcSpec.methodName, request.toByteArray()));
    }

    public static class ResponseFutureWrapper<S extends MessageLite> {
        private final Parser<S> responseParser;
        private final Future<byte[]> responseByteArrayFuture;

        public ResponseFutureWrapper(Parser<S> responseParser, Future<byte[]> responseByteArrayFuture) {
            this.responseByteArrayFuture = responseByteArrayFuture;
            this.responseParser = responseParser;
        }

        public S getResponse() throws RpcException {
            try {
                return (S)((MessageLite)this.responseParser.parseFrom(this.responseByteArrayFuture.get()));
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                throw new RpcException("Unexpected interrupt.", exception);
            }
            catch (InvalidProtocolBufferException exception) {
                throw new RpcException("Unexpected deserialization failure.", exception);
            }
            catch (ExecutionException exception) {
                throw ResponseFutureWrapper.translateExecutionException(exception);
            }
        }

        private static RpcException translateExecutionException(ExecutionException exception) throws RpcException {
            Throwable cause = exception.getCause();
            if (cause instanceof ApiProxy.ApiProxyException) {
                throw ResponseFutureWrapper.translateApiProxyException((ApiProxy.ApiProxyException)cause);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RpcException("Unexpected exception.", cause);
        }

        private static RpcException translateApiProxyException(ApiProxy.ApiProxyException apiProxyException) throws RpcException {
            Codes.Code errorCode = Codes.Code.INTERNAL;
            String message = apiProxyException.getMessage();
            if (apiProxyException instanceof ApiProxy.ApplicationException) {
                ApiProxy.ApplicationException applicationException = (ApiProxy.ApplicationException)apiProxyException;
                errorCode = InternDatastoreRpcService.getCanonicalCodeForAppError(applicationException.getApplicationError());
                message = applicationException.getErrorDetail();
            } else if (apiProxyException instanceof ApiProxy.ApiDeadlineExceededException) {
                errorCode = Codes.Code.DEADLINE_EXCEEDED;
            } else if (apiProxyException instanceof ApiProxy.RequestTooLargeException) {
                errorCode = Codes.Code.INVALID_ARGUMENT;
            } else if (apiProxyException instanceof ApiProxy.CapabilityDisabledException) {
                errorCode = Codes.Code.PERMISSION_DENIED;
            } else if (apiProxyException instanceof ApiProxy.OverQuotaException) {
                errorCode = Codes.Code.RESOURCE_EXHAUSTED;
            }
            throw new RpcException(errorCode, message, apiProxyException);
        }
    }

    public static class RpcSpec<S extends MessageLite> {
        public final String packageName;
        public final String methodName;
        public final Parser<S> responseParser;

        public RpcSpec(String packageName, String methodName, Parser<S> responseParser) {
            this.packageName = packageName;
            this.methodName = methodName;
            this.responseParser = responseParser;
        }
    }
}

